/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.jca.ActivationSpec;
import org.switchyard.tools.models.switchyard1_0.jca.JCABinding;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundConnection;
import org.switchyard.tools.models.switchyard1_0.jca.JcaFactory;
import org.switchyard.tools.models.switchyard1_0.jca.JcaPackage;
import org.switchyard.tools.models.switchyard1_0.jca.Property;
import org.switchyard.tools.ui.editor.components.jca.JCAPropertyInputDialog;
import org.switchyard.tools.ui.editor.components.jca.JCAPropertyTable;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class JCAActivationSpecPropertyTable
extends JCAPropertyTable {
    private static final FeaturePath ACTIVATION_PROPERTIES = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JcaPackage.Literals.JCA_BINDING__INBOUND_CONNECTION, JcaPackage.Literals.JCA_INBOUND_CONNECTION__ACTIVATION_SPEC, JcaPackage.Literals.ACTIVATION_SPEC__PROPERTY});

    public JCAActivationSpecPropertyTable(Composite parent, int style, FormToolkit toolkit, DataBindingContext context, EditingDomain domain) {
        super(parent, style, false, toolkit, context, ACTIVATION_PROPERTIES, domain);
    }

    public JCAActivationSpecPropertyTable(Composite parent, int style, boolean isReadOnly, FormToolkit toolkit, DataBindingContext context, EditingDomain domain) {
        super(parent, style, isReadOnly, toolkit, context, ACTIVATION_PROPERTIES, domain);
    }

    @Override
    protected void removeFromList() {
        final Property toRemove = this.getTableSelection();
        if (toRemove != null && this.getTargetObject() instanceof JCABinding) {
            JCABinding binding = (JCABinding)this.getTargetObject();
            final ActivationSpec actSpec = binding.getInboundConnection().getActivationSpec();
            if (toRemove.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        boolean flag = actSpec.getProperty().remove((Object)toRemove);
                        System.out.println("Property " + toRemove.getName() + " was removed: " + flag);
                    }
                });
            } else {
                boolean flag = actSpec.getProperty().remove((Object)toRemove);
                System.out.println("Property " + toRemove.getName() + " was removed: " + flag);
            }
        }
    }

    @Override
    protected void addPropertyToList() {
        final JCAPropertyInputDialog dialog = new JCAPropertyInputDialog(Display.getCurrent().getActiveShell());
        int rtn_value = dialog.open();
        if (rtn_value == 0 && this.getTargetObject() instanceof JCABinding) {
            final JCABinding binding = (JCABinding)this.getTargetObject();
            if (this.getTargetObject().eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        Property newProperty = JcaFactory.eINSTANCE.createProperty();
                        newProperty.setName(dialog.getPropertyName());
                        newProperty.setValue((Object)dialog.getPropertyValue());
                        if (binding.getInboundConnection() == null) {
                            JCAInboundConnection inbound = JcaFactory.eINSTANCE.createJCAInboundConnection();
                            inbound.setActivationSpec(JcaFactory.eINSTANCE.createActivationSpec());
                            binding.setInboundConnection(inbound);
                        } else if (binding.getInboundConnection().getActivationSpec() == null) {
                            binding.getInboundConnection().setActivationSpec(JcaFactory.eINSTANCE.createActivationSpec());
                        }
                        ActivationSpec actSpec = binding.getInboundConnection().getActivationSpec();
                        actSpec.getProperty().add((Object)newProperty);
                    }
                });
            } else {
                Property newProperty = JcaFactory.eINSTANCE.createProperty();
                newProperty.setName(dialog.getPropertyName());
                newProperty.setValue((Object)dialog.getPropertyValue());
                if (binding.getInboundConnection() == null) {
                    JCAInboundConnection inbound = JcaFactory.eINSTANCE.createJCAInboundConnection();
                    inbound.setActivationSpec(JcaFactory.eINSTANCE.createActivationSpec());
                    binding.setInboundConnection(inbound);
                } else if (binding.getInboundConnection().getActivationSpec() == null) {
                    binding.getInboundConnection().setActivationSpec(JcaFactory.eINSTANCE.createActivationSpec());
                }
                ActivationSpec actSpec = binding.getInboundConnection().getActivationSpec();
                actSpec.getProperty().add((Object)newProperty);
            }
        }
    }
}

