/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.soap;

import java.util.Collection;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.CellEditorProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.switchyard.tools.models.switchyard1_0.soap.InterceptorType;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPBindingType;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardBindingType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.soap.InterceptorTypeInputDialog;
import org.switchyard.tools.ui.editor.diagram.shared.TableColumnLayout;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class InterceptorTable
extends Composite {
    private TableViewer _interceptorTable;
    private Button _mAddButton;
    private Button _mRemoveButton;
    private Button _mEditButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private ListenerList _changeListeners;
    private final EReference _interceptorsFeature;
    private final EReference _interceptorsListFeature;
    private final EClass _interceptorType;
    private WritableValue _bindingValue;

    public InterceptorTable(Composite parent, int style, EReference interceptorsListFeature, EReference interceptorsFeature, EClass interceptorType, DataBindingContext context) {
        this(parent, style, false, interceptorsListFeature, interceptorsFeature, interceptorType, context);
    }

    public InterceptorTable(Composite parent, int style, boolean isReadOnly, EReference interceptorsListFeature, EReference interceptorsFeature, EClass interceptorType, DataBindingContext context) {
        super(parent, style);
        ObservableListContentProvider contentProvider;
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        this._interceptorsListFeature = interceptorsListFeature;
        this._interceptorsFeature = interceptorsFeature;
        this._interceptorType = interceptorType;
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Composite tableComposite = new Composite((Composite)this, additionalStyles);
        GridData gd11 = new GridData(4, 4, true, false, 1, 3);
        gd11.heightHint = 100;
        tableComposite.setLayoutData((Object)gd11);
        this._interceptorTable = new TableViewer(tableComposite, 0x10A40 | additionalStyles);
        this._interceptorTable.getTable().setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        TableViewerColumn nameColumn = new TableViewerColumn(this._interceptorTable, 16384);
        nameColumn.getColumn().setText(Messages.label_name);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        IEMFValueProperty nameProperty = domain == null ? EMFProperties.value((EStructuralFeature)this._interceptorType.getEStructuralFeature("class")) : EMFEditProperties.value((EditingDomain)domain, (EStructuralFeature)this._interceptorType.getEStructuralFeature("class"));
        IValueProperty cellEditorTextProperty = CellEditorProperties.control().value((IValueProperty)WidgetProperties.text((int)24));
        ObservableTracker.setIgnore((boolean)true);
        try {
            contentProvider = new ObservableListContentProvider();
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        nameColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this._interceptorTable, (DataBindingContext)context, (CellEditor)new TextCellEditor((Composite)this._interceptorTable.getTable()), (IValueProperty)cellEditorTextProperty, (IValueProperty)nameProperty));
        nameColumn.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(nameProperty.observeDetail(contentProvider.getKnownElements())));
        this._interceptorTable.setContentProvider((IContentProvider)contentProvider);
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(256));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterceptorTable.this.addInterceptorTypeToList();
                InterceptorTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._interceptorTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterceptorTable.this.updateInterceptorTypeButtons();
            }
        });
        this._mEditButton = new Button((Composite)this, 0);
        this._mEditButton.setLayoutData((Object)new GridData(256));
        this._mEditButton.setText(Messages.button_edit);
        this._mEditButton.setEnabled(false);
        this._mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterceptorTable.this.editInterceptorType();
                InterceptorTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(256));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterceptorTable.this.removeFromList();
                InterceptorTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._bindingValue = new WritableValue(SWTObservables.getRealm((Display)this.getDisplay()), null, SOAPBindingType.class);
        this._interceptorTable.setInput((Object)EMFProperties.list((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{this._interceptorsListFeature, this._interceptorsFeature})).observeDetail((IObservableValue)this._bindingValue));
        this.updateInterceptorTypeButtons();
    }

    protected void addInterceptorTypeToList() {
        InterceptorTypeInputDialog dialog = new InterceptorTypeInputDialog(Display.getCurrent().getActiveShell());
        InterceptorType interceptor = SOAPFactory.eINSTANCE.createInterceptorType();
        dialog.setInterceptor(interceptor);
        int rtn_value = dialog.open();
        if (rtn_value == 0) {
            final SOAPBindingType soapBinding = (SOAPBindingType)this._targetObj;
            InterceptorType mapping = interceptor;
            if (this._targetObj.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain, (EObject)mapping){
                    private final /* synthetic */ EObject val$mapping;
                    {
                        this.val$mapping = eObject;
                        super($anonymous0);
                    }

                    protected void doExecute() {
                        Object mappings;
                        Object variableContainer = soapBinding.eGet((EStructuralFeature)InterceptorTable.this._interceptorsListFeature);
                        if (variableContainer == null) {
                            EClass variableContainerClass = InterceptorTable.this._interceptorsListFeature.getEReferenceType();
                            variableContainer = variableContainerClass.getEPackage().getEFactoryInstance().create(variableContainerClass);
                            soapBinding.eSet((EStructuralFeature)InterceptorTable.this._interceptorsListFeature, variableContainer);
                        }
                        if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)InterceptorTable.this._interceptorsFeature)) instanceof Collection) {
                            ((Collection)mappings).add(this.val$mapping);
                        }
                    }
                });
            } else {
                Object mappings;
                Object variableContainer = soapBinding.eGet((EStructuralFeature)this._interceptorsListFeature);
                if (variableContainer == null) {
                    EClass variableContainerClass = this._interceptorsListFeature.getEReferenceType();
                    variableContainer = variableContainerClass.getEPackage().getEFactoryInstance().create(variableContainerClass);
                    soapBinding.eSet((EStructuralFeature)this._interceptorsListFeature, variableContainer);
                }
                if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)this._interceptorsFeature)) instanceof Collection) {
                    ((Collection)mappings).add(mapping);
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected void removeFromList() {
        if (this.getTargetObject() instanceof SwitchYardBindingType) {
            final SwitchYardBindingType baseCamel = (SwitchYardBindingType)this.getTargetObject();
            InterceptorType actionToRemove = this.getTableSelection();
            if (baseCamel.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain, (EObject)actionToRemove){
                    private final /* synthetic */ EObject val$actionToRemove;
                    {
                        this.val$actionToRemove = eObject;
                        super($anonymous0);
                    }

                    protected void doExecute() {
                        Object variableContainer = baseCamel.eGet((EStructuralFeature)InterceptorTable.this._interceptorsListFeature);
                        if (variableContainer instanceof EObject) {
                            Object mappings = ((EObject)variableContainer).eGet((EStructuralFeature)InterceptorTable.this._interceptorsFeature);
                            if (mappings instanceof Collection) {
                                ((Collection)mappings).remove(this.val$actionToRemove);
                            }
                            if (((Collection)mappings).isEmpty()) {
                                baseCamel.eSet((EStructuralFeature)InterceptorTable.this._interceptorsListFeature, null);
                            }
                        }
                    }
                });
            } else {
                Object variableContainer = baseCamel.eGet((EStructuralFeature)this._interceptorsListFeature);
                if (variableContainer instanceof EObject) {
                    Object mappings = ((EObject)variableContainer).eGet((EStructuralFeature)this._interceptorsFeature);
                    if (mappings instanceof Collection) {
                        ((Collection)mappings).remove(actionToRemove);
                    }
                    if (((Collection)mappings).isEmpty()) {
                        baseCamel.eSet((EStructuralFeature)this._interceptorsListFeature, null);
                    }
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected void editInterceptorType() {
        if (this.getTargetObject() instanceof SwitchYardBindingType) {
            final SwitchYardBindingType baseCamel = (SwitchYardBindingType)this.getTargetObject();
            InterceptorType actionToRemove = this.getTableSelection();
            InterceptorTypeInputDialog dialog = new InterceptorTypeInputDialog(Display.getCurrent().getActiveShell());
            dialog.setInterceptor(actionToRemove);
            int rtn_value = dialog.open();
            if (rtn_value == 0) {
                if (baseCamel.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain, (EObject)actionToRemove, dialog){
                        private final /* synthetic */ EObject val$actionToRemove;
                        private final /* synthetic */ InterceptorTypeInputDialog val$dialog;
                        {
                            this.val$actionToRemove = eObject;
                            this.val$dialog = interceptorTypeInputDialog;
                            super($anonymous0);
                        }

                        protected void doExecute() {
                            Object mappings;
                            Object variableContainer = baseCamel.eGet((EStructuralFeature)InterceptorTable.this._interceptorsListFeature);
                            if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)InterceptorTable.this._interceptorsFeature)) instanceof Collection) {
                                ((Collection)mappings).remove(this.val$actionToRemove);
                                ((Collection)mappings).add(this.val$dialog.getInterceptor());
                            }
                        }
                    });
                } else {
                    Object mappings;
                    Object variableContainer = baseCamel.eGet((EStructuralFeature)this._interceptorsListFeature);
                    if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)this._interceptorsFeature)) instanceof Collection) {
                        ((Collection)mappings).remove(actionToRemove);
                        ((Collection)mappings).add(dialog.getInterceptor());
                    }
                }
                this.fireChangedEvent((Object)this);
            }
        }
    }

    public EList<InterceptorType> getSelection() {
        if (this._interceptorTable != null && this._interceptorTable.getInput() != null) {
            return (EList)this._interceptorTable.getInput();
        }
        return null;
    }

    public InterceptorType getTableSelection() {
        IStructuredSelection ssel;
        if (this._interceptorTable != null && !this._interceptorTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._interceptorTable.getSelection()).getFirstElement() instanceof InterceptorType) {
            return (InterceptorType)ssel.getFirstElement();
        }
        return null;
    }

    public void updateInterceptorTypeButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
            this._mEditButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            IStructuredSelection ssel = (IStructuredSelection)this._interceptorTable.getSelection();
            if (ssel != null && ssel.getFirstElement() != null) {
                this._mEditButton.setEnabled(true);
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    public void setSelection(EList<InterceptorType> properties) {
        this._interceptorTable.setInput(properties);
        this.updateInterceptorTypeButtons();
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this._bindingValue.setValue((Object)target);
        this.updateInterceptorTypeButtons();
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    protected TableViewer getTableViewer() {
        return this._interceptorTable;
    }
}

