/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.switchyard.tools.ui.editor.diagram.SCADiagramColoredAreas;

public final class StyleUtil {
    public static final FigurePalette REFERENCE_PALETTE = new FigurePalette("291F33", "bf95ea", "a482c6", "bf95ea");
    public static final FigurePalette SERVICE_PALETTE = new FigurePalette("053305", "86ce86", "86c386", "86ce86");
    public static final FigurePalette COMPONENT_PALETTE = new FigurePalette("1A1D33", "aab3fa", "9ba0fc", "aab3fa");
    public static final FigurePalette COMPOSITE_PALETTE = new FigurePalette("1F2933", "a5d2ff", "a5d2ff", "a5d2ff");
    public static final String LINE_COLOR = "758695";
    public static final int[] SMALL_RIGHT_ARROW;
    public static final int SMALL_RIGHT_ARROW_WIDTH = 20;
    public static final int SMALL_RIGHT_ARROW_HEIGHT = 15;
    public static final int[] MEDIUM_RIGHT_ARROW;
    public static final int MEDIUM_RIGHT_ARROW_WIDTH = 50;
    public static final int MEDIUM_RIGHT_ARROW_HEIGHT = 30;
    public static final int[][] LARGE_RIGHT_ARROW;
    public static final int LARGE_RIGHT_ARROW_WIDTH = 100;
    public static final int LARGE_RIGHT_ARROW_HEIGHT = 75;
    public static final int COMPOSITE_WIDTH = 500;
    public static final int COMPOSITE_HEIGHT = 300;
    public static final int COMPOSITE_OUTER_EDGE = 30;
    public static final int COMPOSITE_PROTRUSION_WIDTH = 20;
    public static final int COMPOSITE_INNER_EDGE = 15;
    public static final int COMPOSITE_CHILD_V_SPACING = 10;
    public static final int COMPONENT_WIDTH = 100;
    public static final int COMPONENT_HEIGHT = 50;
    public static final int COMPONENT_EDGE = 15;
    public static final int COMPONENT_CHILD_V_SPACING = 20;
    public static final int SERVICE_WIDTH = 100;
    public static final int SERVICE_HEIGHT = 50;
    public static final int SERVICE_INVISIBLE_RECT_RIGHT = 10;
    public static final int COMPOSITE_REFERENCE_WIDTH = 100;
    public static final int COMPOSITE_REFERENCE_HEIGHT = 50;
    public static final int COMPOSITE_REFERENCE_INVISIBLE_RECT_RIGHT = 10;

    static {
        int[] nArray = new int[14];
        nArray[2] = 15;
        nArray[4] = 20;
        nArray[5] = 5;
        nArray[6] = 15;
        nArray[7] = 10;
        nArray[9] = 10;
        nArray[10] = 3;
        nArray[11] = 5;
        SMALL_RIGHT_ARROW = nArray;
        int[] nArray2 = new int[14];
        nArray2[2] = 45;
        nArray2[4] = 50;
        nArray2[5] = 15;
        nArray2[6] = 45;
        nArray2[7] = 30;
        nArray2[9] = 30;
        nArray2[10] = 33;
        nArray2[11] = 15;
        MEDIUM_RIGHT_ARROW = nArray2;
        int[][] nArrayArray = new int[2][];
        int[] nArray3 = new int[14];
        nArray3[2] = 75;
        nArray3[4] = 100;
        nArray3[5] = 25;
        nArray3[6] = 75;
        nArray3[7] = 50;
        nArray3[9] = 50;
        nArray3[10] = 15;
        nArray3[11] = 25;
        nArrayArray[0] = nArray3;
        nArrayArray[1] = new int[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        LARGE_RIGHT_ARROW = nArrayArray;
    }

    private StyleUtil() {
    }

    public static Style getStyleForComposite(Diagram diagram) {
        Style style = StyleUtil.findStyle((StyleContainer)diagram, "Composite");
        if (style == null) {
            IGaService gaService = Graphiti.getGaService();
            style = gaService.createStyle((StyleContainer)diagram, "Composite");
            style.setForeground(gaService.manageColor(diagram, (IColorConstant)new ColorConstant(COMPOSITE_PALETTE.getForeground())));
            gaService.setRenderingStyle((AbstractStyle)style, SCADiagramColoredAreas.getCompositeAdaptions());
            style.setLineWidth(Integer.valueOf(2));
        }
        return style;
    }

    public static Style getStyleForComponent(Diagram diagram) {
        Style style = StyleUtil.findStyle((StyleContainer)diagram, "Component");
        if (style == null) {
            IGaService gaService = Graphiti.getGaService();
            style = gaService.createStyle((StyleContainer)diagram, "Component");
            style.setForeground(gaService.manageColor(diagram, (IColorConstant)new ColorConstant(COMPONENT_PALETTE.getForeground())));
            gaService.setRenderingStyle((AbstractStyle)style, SCADiagramColoredAreas.getComponentAdaptions());
            style.setLineWidth(Integer.valueOf(2));
        }
        return style;
    }

    public static Style getStyleForService(Diagram diagram) {
        Style style = StyleUtil.findStyle((StyleContainer)diagram, "Service");
        if (style == null) {
            IGaService gaService = Graphiti.getGaService();
            style = gaService.createStyle((StyleContainer)diagram, "Service");
            style.setForeground(gaService.manageColor(diagram, (IColorConstant)new ColorConstant(SERVICE_PALETTE.getForeground())));
            gaService.setRenderingStyle((AbstractStyle)style, SCADiagramColoredAreas.getServiceAdaptions());
            style.setLineWidth(Integer.valueOf(2));
        }
        return style;
    }

    public static Style getStyleForCompositeReference(Diagram diagram) {
        Style style = StyleUtil.findStyle((StyleContainer)diagram, "CompositeReference");
        if (style == null) {
            IGaService gaService = Graphiti.getGaService();
            style = gaService.createStyle((StyleContainer)diagram, "CompositeReference");
            style.setForeground(gaService.manageColor(diagram, (IColorConstant)new ColorConstant(REFERENCE_PALETTE.getForeground())));
            gaService.setRenderingStyle((AbstractStyle)style, SCADiagramColoredAreas.getReferenceAdaptions());
            style.setLineWidth(Integer.valueOf(2));
        }
        return style;
    }

    private static Style findStyle(StyleContainer styleContainer, String id) {
        EList styles = styleContainer.getStyles();
        if (styles != null) {
            for (Style style : styles) {
                if (!id.equals(style.getId())) continue;
                return style;
            }
        }
        return null;
    }

    public static <T extends GraphicsAlgorithm> T findChildGA(GraphicsAlgorithm parent, Class<T> gaSearchType) {
        EList childGAs = parent.getGraphicsAlgorithmChildren();
        for (GraphicsAlgorithm graphicsAlgorithm : childGAs) {
            if (graphicsAlgorithm.getClass().getCanonicalName().contentEquals(gaSearchType.getCanonicalName())) {
                return (T)((GraphicsAlgorithm)gaSearchType.cast(graphicsAlgorithm));
            }
            if (graphicsAlgorithm.getClass() != gaSearchType && gaSearchType.isAssignableFrom(graphicsAlgorithm.getClass())) {
                return (T)((GraphicsAlgorithm)gaSearchType.cast(graphicsAlgorithm));
            }
            if (graphicsAlgorithm.getGraphicsAlgorithmChildren().size() <= 0) continue;
            return StyleUtil.findChildGA(graphicsAlgorithm, gaSearchType);
        }
        return null;
    }

    public static final class FigurePalette {
        private final String _textForeground;
        private final String _foreground;
        private final String _backgroundDark;
        private final String _backgroundLight;

        public FigurePalette(String textForeground, String foreground, String backgroundDark, String backgroundLight) {
            this._textForeground = textForeground;
            this._foreground = foreground;
            this._backgroundDark = backgroundDark;
            this._backgroundLight = backgroundLight;
        }

        public String getTextForeground() {
            return this._textForeground;
        }

        public String getForeground() {
            return this._foreground;
        }

        public String getBackgroundDark() {
            return this._backgroundDark;
        }

        public String getBackgroundLight() {
            return this._backgroundLight;
        }
    }
}

