/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.binding;

import java.util.Collection;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.CellEditorProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardBindingType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.TableColumnLayout;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class CamelAdditionalURIPropertyTable
extends Composite {
    private TableViewer _propertyTreeTable;
    private Button _mAddButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private ListenerList _changeListeners;
    private final EReference _parameterFeature;
    private final EReference _additionalUriParametersFeature;
    private final EClass _parameterType;
    private WritableValue _bindingValue;

    CamelAdditionalURIPropertyTable(Composite parent, int style, EReference additionalUriParametersFeature, EReference parameterFeature, EClass parameterType, DataBindingContext context, EditingDomain domain) {
        this(parent, style, false, additionalUriParametersFeature, parameterFeature, parameterType, context, domain);
    }

    CamelAdditionalURIPropertyTable(Composite parent, int style, boolean isReadOnly, EReference additionalUriParametersFeature, EReference parameterFeature, EClass parameterType, DataBindingContext context, EditingDomain domain) {
        super(parent, style);
        ObservableListContentProvider contentProvider;
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        this._additionalUriParametersFeature = additionalUriParametersFeature;
        this._parameterFeature = parameterFeature;
        this._parameterType = parameterType;
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Composite tableComposite = new Composite((Composite)this, additionalStyles);
        GridData gd11 = new GridData(4, 4, true, false, 1, 2);
        gd11.heightHint = 100;
        tableComposite.setLayoutData((Object)gd11);
        this._propertyTreeTable = new TableViewer(tableComposite, 0x10A40 | additionalStyles);
        this._propertyTreeTable.getTable().setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        TableViewerColumn nameColumn = new TableViewerColumn(this._propertyTreeTable, 16384);
        nameColumn.getColumn().setText(Messages.label_name);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableViewerColumn valueColumn = new TableViewerColumn(this._propertyTreeTable, 16384);
        valueColumn.getColumn().setText(Messages.label_value);
        tableLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        IEMFValueProperty nameProperty = domain == null ? EMFProperties.value((EStructuralFeature)this._parameterType.getEStructuralFeature("name")) : EMFEditProperties.value((EditingDomain)domain, (EStructuralFeature)this._parameterType.getEStructuralFeature("name"));
        IEMFValueProperty valueProperty = domain == null ? EMFProperties.value((EStructuralFeature)this._parameterType.getEStructuralFeature("value")) : EMFEditProperties.value((EditingDomain)domain, (EStructuralFeature)this._parameterType.getEStructuralFeature("value"));
        IValueProperty cellEditorTextProperty = CellEditorProperties.control().value((IValueProperty)WidgetProperties.text((int)24));
        ObservableTracker.setIgnore((boolean)true);
        try {
            contentProvider = new ObservableListContentProvider();
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        nameColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this._propertyTreeTable, (DataBindingContext)context, (CellEditor)new TextCellEditor((Composite)this._propertyTreeTable.getTable()), (IValueProperty)cellEditorTextProperty, (IValueProperty)nameProperty));
        nameColumn.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(nameProperty.observeDetail(contentProvider.getKnownElements())));
        valueColumn.setEditingSupport(ObservableValueEditingSupport.create((ColumnViewer)this._propertyTreeTable, (DataBindingContext)context, (CellEditor)new TextCellEditor((Composite)this._propertyTreeTable.getTable()), (IValueProperty)cellEditorTextProperty, (IValueProperty)valueProperty));
        valueColumn.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider(valueProperty.observeDetail(contentProvider.getKnownElements())));
        this._propertyTreeTable.setContentProvider((IContentProvider)contentProvider);
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CamelAdditionalURIPropertyTable.this.addPropertyToList();
                CamelAdditionalURIPropertyTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CamelAdditionalURIPropertyTable.this.updatePropertyButtons();
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CamelAdditionalURIPropertyTable.this.removeFromList();
                CamelAdditionalURIPropertyTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._bindingValue = new WritableValue(SWTObservables.getRealm((Display)this.getDisplay()), null, Binding.class);
        this._propertyTreeTable.setInput((Object)EMFProperties.list((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{this._additionalUriParametersFeature, this._parameterFeature})).observeDetail((IObservableValue)this._bindingValue));
        this.updatePropertyButtons();
    }

    private void setFeatureValue(EObject eObject, String featureId, Object value) throws Exception {
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && eStructuralFeature.getName().equalsIgnoreCase(featureId)) {
                if (value != null) {
                    eObject.eSet(eStructuralFeature, value);
                } else {
                    eObject.eUnset(eStructuralFeature);
                }
                return;
            }
            ++i;
        }
        System.out.println("CamelAdditionalURIPropertyTable: Didn't find feature: " + featureId);
        this.showFeatures(eObject);
        throw new Exception("CamelAdditionalURIPropertyTable:Feature ID (" + featureId + ") not found.");
    }

    private void addPropertyToList() {
        if (this.getTargetObject() instanceof SwitchYardBindingType) {
            final SwitchYardBindingType baseCamel = (SwitchYardBindingType)this.getTargetObject();
            EClass mappingsClass = this._parameterFeature.getEReferenceType();
            final EObject mapping = mappingsClass.getEPackage().getEFactoryInstance().create(mappingsClass);
            try {
                this.setFeatureValue(mapping, "name", "property");
                this.setFeatureValue(mapping, "value", "value");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (baseCamel.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        Object mappings;
                        Object variableContainer = baseCamel.eGet((EStructuralFeature)CamelAdditionalURIPropertyTable.this._additionalUriParametersFeature);
                        if (variableContainer == null) {
                            EClass variableContainerClass = CamelAdditionalURIPropertyTable.this._additionalUriParametersFeature.getEReferenceType();
                            variableContainer = variableContainerClass.getEPackage().getEFactoryInstance().create(variableContainerClass);
                            baseCamel.eSet((EStructuralFeature)CamelAdditionalURIPropertyTable.this._additionalUriParametersFeature, variableContainer);
                        }
                        if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)CamelAdditionalURIPropertyTable.this._parameterFeature)) instanceof Collection) {
                            ((Collection)mappings).add(mapping);
                        }
                    }
                });
            } else {
                Object mappings;
                Object variableContainer = baseCamel.eGet((EStructuralFeature)this._additionalUriParametersFeature);
                if (variableContainer == null) {
                    EClass variableContainerClass = this._additionalUriParametersFeature.getEReferenceType();
                    variableContainer = variableContainerClass.getEPackage().getEFactoryInstance().create(variableContainerClass);
                    baseCamel.eSet((EStructuralFeature)this._additionalUriParametersFeature, variableContainer);
                }
                if (variableContainer instanceof EObject && (mappings = ((EObject)variableContainer).eGet((EStructuralFeature)this._parameterFeature)) instanceof Collection) {
                    ((Collection)mappings).add(mapping);
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    private void removeFromList() {
        if (this.getTargetObject() instanceof SwitchYardBindingType) {
            final SwitchYardBindingType baseCamel = (SwitchYardBindingType)this.getTargetObject();
            final EObject actionToRemove = this.getTableSelection();
            if (baseCamel.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        Object variableContainer = baseCamel.eGet((EStructuralFeature)CamelAdditionalURIPropertyTable.this._additionalUriParametersFeature);
                        if (variableContainer instanceof EObject) {
                            Object mappings = ((EObject)variableContainer).eGet((EStructuralFeature)CamelAdditionalURIPropertyTable.this._parameterFeature);
                            if (mappings instanceof Collection) {
                                ((Collection)mappings).remove(actionToRemove);
                            }
                            if (((Collection)mappings).isEmpty()) {
                                baseCamel.eSet((EStructuralFeature)CamelAdditionalURIPropertyTable.this._additionalUriParametersFeature, null);
                            }
                        }
                    }
                });
            } else {
                Object variableContainer = baseCamel.eGet((EStructuralFeature)this._additionalUriParametersFeature);
                if (variableContainer instanceof EObject) {
                    Object mappings = ((EObject)variableContainer).eGet((EStructuralFeature)this._parameterFeature);
                    if (mappings instanceof Collection) {
                        ((Collection)mappings).remove(actionToRemove);
                    }
                    if (((Collection)mappings).isEmpty()) {
                        baseCamel.eSet((EStructuralFeature)this._additionalUriParametersFeature, null);
                    }
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    private EObject getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof EObject) {
            return (EObject)ssel.getFirstElement();
        }
        return null;
    }

    private void updatePropertyButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            if (this.getTableSelection() != null) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    private void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this._bindingValue.setValue((Object)target);
        this.updatePropertyButtons();
    }

    private EObject getTargetObject() {
        return this._targetObj;
    }

    private void showFeatures(EObject eObject) {
        EClass eClass = eObject.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable()) {
                System.out.println("CamelAdditionalURIPropertyTable:Feature: " + eStructuralFeature.getName());
            }
            ++i;
        }
    }
}

