/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.component;

import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.switchyard.tools.ui.editor.diagram.StyleUtil;

public class SCADiagramLayoutComponentFeature
extends AbstractLayoutFeature {
    private static final int MIN_HEIGHT = 50;
    private static final int MIN_WIDTH = 100;

    public SCADiagramLayoutComponentFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        PictogramElement pe = context.getPictogramElement();
        return pe instanceof ContainerShape;
    }

    public boolean layout(ILayoutContext context) {
        boolean anythingChanged = false;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
        Component component = (Component)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
        int minHeight = Math.max(Math.max(containerGa.getHeight() - 30, 50), Math.max(component.getService().size() * 20 + 30, component.getReference().size() * 20 + 30));
        int minWidth = Math.max(100, containerGa.getWidth() - 30);
        if (containerGa.getHeight() - 30 < minHeight) {
            containerGa.setHeight(minHeight + 30);
            anythingChanged = true;
        }
        if (containerGa.getWidth() - 30 < minWidth) {
            containerGa.setWidth(minWidth + 30);
            anythingChanged = true;
        }
        IGaService gaService = Graphiti.getGaService();
        for (GraphicsAlgorithm ga : containerGa.getGraphicsAlgorithmChildren()) {
            RoundedRectangle rt;
            IDimension size = gaService.calculateSize(ga);
            if (ga instanceof Rectangle) {
                if (minWidth == size.getWidth() && minHeight == size.getHeight()) continue;
                rt = (Rectangle)ga;
                rt.setHeight(minHeight);
                rt.setWidth(minWidth);
                anythingChanged = true;
                continue;
            }
            if (!(ga instanceof RoundedRectangle)) continue;
            rt = (RoundedRectangle)ga;
            rt.setX(15);
            rt.setY(15);
            rt.setHeight(minHeight);
            rt.setWidth(minWidth);
            int referenceX = containerGa.getWidth() - 15 - 10;
            for (Shape child : containerShape.getChildren()) {
                GraphicsAlgorithm childGa;
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)child);
                if (bo instanceof ComponentReference) {
                    childGa = child.getGraphicsAlgorithm();
                    childGa.setX(referenceX);
                    childGa.setY(25 + component.getReference().indexOf(bo) * 20);
                } else if (bo instanceof ComponentService) {
                    childGa = child.getGraphicsAlgorithm();
                    childGa.setX(5);
                    childGa.setY(25 + component.getService().indexOf(bo) * 20);
                }
                anythingChanged = true;
            }
        }
        int containerWidth = containerGa.getWidth();
        int containerHeight = containerGa.getHeight();
        Text gaFound = StyleUtil.findChildGA(containerGa, Text.class);
        if (gaFound != null && gaFound instanceof Text) {
            Text text = gaFound;
            text.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
            text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
            gaService.setLocationAndSize((GraphicsAlgorithm)text, 15, 15, containerWidth - 60, containerHeight - 60);
            anythingChanged = true;
        }
        return anythingChanged;
    }
}

