/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.model.merge.ComponentMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.util.GraphitiUtil;

public class SCADiagramUpdateComponentFeature
extends AbstractUpdateFeature {
    private boolean _hasDoneChanges;

    public SCADiagramUpdateComponentFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo instanceof Component;
    }

    public IReason updateNeeded(IUpdateContext context) {
        boolean updateNameNeeded;
        PictogramElement pictogramElement = context.getPictogramElement();
        Component component = (Component)this.getBusinessObjectForPictogramElement(pictogramElement);
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)component)) {
            return Reason.createTrueReason((String)String.format(Messages.updateReason_componentRemoved, component.getName()));
        }
        String businessName = component.getName();
        String pictogramName = null;
        Text foundText = GraphitiUtil.findChildGA(pictogramElement.getGraphicsAlgorithm(), Text.class);
        if (foundText != null) {
            pictogramName = foundText.getValue();
        }
        boolean bl = pictogramName == null ? businessName != null : (updateNameNeeded = !pictogramName.equals(businessName));
        if (updateNameNeeded) {
            return Reason.createTrueReason((String)Messages.updateReason_componentOutOfDate);
        }
        if (this.getMissingChildren(component, (ContainerShape)pictogramElement).size() > 0) {
            return Reason.createTrueReason((String)Messages.updateReason_addMissingServicesAndReferences);
        }
        return this.childrenNeedUpdating(component, (ContainerShape)pictogramElement);
    }

    public boolean update(IUpdateContext context) {
        PictogramElement pictogramElement = context.getPictogramElement();
        Component component = (Component)this.getBusinessObjectForPictogramElement(pictogramElement);
        if (!GraphitiInternal.getEmfService().isObjectAlive((EObject)component)) {
            RemoveContext removeContext = new RemoveContext(pictogramElement);
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (removeFeature != null && removeFeature.canRemove((IRemoveContext)removeContext)) {
                removeFeature.remove((IRemoveContext)removeContext);
                this._hasDoneChanges = removeFeature.hasDoneChanges();
                return true;
            }
        }
        String businessName = component.getName();
        Text text = GraphitiUtil.findChildGA(pictogramElement.getGraphicsAlgorithm(), Text.class);
        if (text != null && !text.getValue().equals(businessName)) {
            text.setValue(businessName);
            this._hasDoneChanges = true;
        }
        boolean bl = this._hasDoneChanges = this.updateChildren(component, (ContainerShape)pictogramElement) || this._hasDoneChanges;
        if (this.addMissingChildren(component, (ContainerShape)pictogramElement)) {
            this._hasDoneChanges = true;
            this.layoutPictogramElement(pictogramElement);
        }
        return this._hasDoneChanges;
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    private boolean updateChildren(Component component, ContainerShape containerShape) {
        boolean changed = false;
        List<EObject> children = this.getChildren(component);
        for (Shape shape : new ArrayList(containerShape.getChildren())) {
            if (children.contains(this.getBusinessObjectForPictogramElement((PictogramElement)shape))) {
                UpdateContext updateContext = new UpdateContext((PictogramElement)shape);
                IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
                if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)updateContext) || !updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) continue;
                changed = updateFeature.update((IUpdateContext)updateContext) || changed;
                continue;
            }
            RemoveContext removeContext = new RemoveContext((PictogramElement)shape);
            IRemoveFeature removeFeature = this.getFeatureProvider().getRemoveFeature((IRemoveContext)removeContext);
            if (removeFeature == null || !removeFeature.canRemove((IRemoveContext)removeContext)) continue;
            removeFeature.remove((IRemoveContext)removeContext);
            boolean bl = changed = removeFeature.hasDoneChanges() || changed;
        }
        return changed;
    }

    private boolean addMissingChildren(Component component, ContainerShape containerShape) {
        boolean changed = false;
        AddContext addServiceContext = new AddContext();
        addServiceContext.setX(5);
        addServiceContext.setY(25 + 20 * this.getChildShapeCount(containerShape, ComponentService.class));
        addServiceContext.setTargetContainer(containerShape);
        AddContext addReferenceContext = new AddContext();
        addReferenceContext.setX(containerShape.getGraphicsAlgorithm().getWidth() - 15 - 10);
        addReferenceContext.setY(25 + 20 * this.getChildShapeCount(containerShape, ComponentReference.class));
        addReferenceContext.setTargetContainer(containerShape);
        for (EObject missingChild : this.getMissingChildren(component, containerShape)) {
            if (missingChild instanceof ComponentService) {
                changed = this.addGraphicalRepresentation((IAreaContext)addServiceContext, missingChild) != null || changed;
                addServiceContext.setY(addServiceContext.getY() + 20);
                continue;
            }
            if (!(missingChild instanceof ComponentReference)) continue;
            changed = this.addGraphicalRepresentation((IAreaContext)addReferenceContext, missingChild) != null || changed;
            addReferenceContext.setY(addReferenceContext.getY() + 20);
        }
        return changed;
    }

    private int getChildShapeCount(ContainerShape containerShape, Class<?> boType) {
        int count = 0;
        for (Shape shape : containerShape.getChildren()) {
            if (!boType.isInstance(this.getBusinessObjectForPictogramElement((PictogramElement)shape))) continue;
            ++count;
        }
        return count;
    }

    private List<EObject> getMissingChildren(Component component, ContainerShape containerShape) {
        List<EObject> children = this.getChildren(component);
        for (Shape shape : containerShape.getChildren()) {
            children.removeAll(Arrays.asList(Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)shape)));
        }
        return children;
    }

    private IReason childrenNeedUpdating(Component component, ContainerShape containerShape) {
        List<EObject> children = this.getChildren(component);
        for (Shape shape : containerShape.getChildren()) {
            if (children.contains(this.getBusinessObjectForPictogramElement((PictogramElement)shape))) {
                IReason reason;
                UpdateContext updateContext = new UpdateContext((PictogramElement)shape);
                IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
                if (updateFeature == null || !(reason = updateFeature.updateNeeded((IUpdateContext)updateContext)).toBoolean()) continue;
                return reason;
            }
            return Reason.createTrueReason((String)Messages.updateReason_addMissingChildren);
        }
        return Reason.createFalseReason();
    }

    private List<EObject> getChildren(Component component) {
        ArrayList<EObject> children = new ArrayList<EObject>();
        ComponentMergedModelAdapter mergedComponent = MergedModelUtil.getAdapter((EObject)component, ComponentMergedModelAdapter.class);
        children.addAll(mergedComponent.getServices());
        children.addAll(mergedComponent.getReferences());
        return children;
    }
}

