/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.componentservice;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.model.merge.ComponentMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;

public class SCADiagramAddComponentServiceFeature
extends AbstractAddShapeFeature {
    public SCADiagramAddComponentServiceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        ContainerShape targetContainer;
        return context.getNewObject() instanceof ComponentService && this.getBusinessObjectForPictogramElement((PictogramElement)(targetContainer = context.getTargetContainer())) instanceof Component;
    }

    public PictogramElement add(IAddContext context) {
        ContainerShape targetContainer = context.getTargetContainer();
        Component component = (Component)this.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
        ComponentService service = (ComponentService)context.getNewObject();
        if (service == null) {
            return null;
        }
        List<ComponentService> services = MergedModelUtil.getAdapter((EObject)component, ComponentMergedModelAdapter.class).getServices();
        if (!services.contains(service)) {
            System.err.println("Target component does not contain new service!!!");
            return null;
        }
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        IGaService gaService = Graphiti.getGaService();
        int anchorY = 25 + services.indexOf(service) * 20;
        int anchorX = 5;
        ContainerShape container = peCreateService.createContainerShape(targetContainer, true);
        Image image = gaService.createImage((GraphicsAlgorithmContainer)container, ImageProvider.IMG_COMPONENT_SERVICE_SCALEABLE);
        gaService.setLocationAndSize((GraphicsAlgorithm)image, anchorX, anchorY, 20, 20);
        image.setStretchH(Boolean.valueOf(true));
        image.setStretchV(Boolean.valueOf(true));
        image.setProportional(Boolean.valueOf(true));
        FixPointAnchor anchor = peCreateService.createFixPointAnchor((AnchorContainer)container);
        Rectangle anchorGa = gaService.createRectangle((GraphicsAlgorithmContainer)anchor);
        anchorGa.setFilled(Boolean.valueOf(false));
        anchorGa.setLineVisible(Boolean.valueOf(false));
        gaService.setLocationAndSize((GraphicsAlgorithm)anchorGa, -1, -9, 10, 20);
        anchor.setLocation(gaService.createPoint(1, 9));
        anchor.setUseAnchorLocationAsConnectionEndpoint(true);
        ChopboxAnchor chopboxAnchor = peCreateService.createChopboxAnchor((AnchorContainer)container);
        this.link((PictogramElement)container, service);
        this.link((PictogramElement)anchor, service);
        this.link((PictogramElement)chopboxAnchor, service);
        this.layoutPictogramElement((PictogramElement)container);
        if (this.updatePictogramElementNeeded((PictogramElement)container)) {
            this.updatePictogramElement((PictogramElement)container);
        }
        return container;
    }
}

