/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.composite;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.tools.ui.editor.diagram.StyleUtil;

public class SCADiagramAddCompositeFeature
extends AbstractAddShapeFeature {
    public SCADiagramAddCompositeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context.getNewObject() instanceof Composite && context.getTargetContainer() instanceof Diagram;
    }

    public PictogramElement add(IAddContext context) {
        PictogramElement pe;
        Composite addedComposite = (Composite)context.getNewObject();
        Diagram targetDiagram = (Diagram)context.getTargetContainer();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        ContainerShape containerShape = peCreateService.createContainerShape((ContainerShape)targetDiagram, true);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "sca-type", "composite");
        IGaService gaService = Graphiti.getGaService();
        int outerEdging = 60;
        int innerEdging = 30;
        int width = context.getWidth() <= 0 ? 500 : context.getWidth();
        int height = context.getHeight() <= 0 ? 300 : context.getHeight();
        Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX(), context.getY(), width + outerEdging, height + outerEdging);
        RoundedRectangle roundedRectangle = null;
        roundedRectangle = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)invisibleRectangle, 12, 12);
        roundedRectangle.setStyle(StyleUtil.getStyleForComposite(this.getDiagram()));
        roundedRectangle.setLineWidth(roundedRectangle.getStyle().getLineWidth());
        roundedRectangle.setTransparency(Double.valueOf(0.6));
        gaService.setLocationAndSize((GraphicsAlgorithm)roundedRectangle, 30, 30, width, height);
        Graphiti.getPeService().setPropertyValue((PropertyContainer)roundedRectangle, "sca-type", "composite");
        this.link((PictogramElement)containerShape, addedComposite);
        Text text = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)roundedRectangle, addedComposite.getName());
        text.setForeground(this.manageColor((IColorConstant)new ColorConstant(StyleUtil.COMPOSITE_PALETTE.getTextForeground())));
        text.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        text.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
        Font font = gaService.manageFont(this.getDiagram(), text.getFont().getName(), text.getFont().getSize(), false, true);
        text.setFont(font);
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 15, 15, width - innerEdging, font.getSize() * 2);
        AddContext childContext = SCADiagramAddCompositeFeature.createComponentAddContext(this.getFeatureProvider(), containerShape);
        childContext.setTargetContainer(containerShape);
        for (Component component : addedComposite.getComponent()) {
            pe = this.addGraphicalRepresentation((IAreaContext)childContext, component);
            if (pe == null) {
                childContext.setY(childContext.getY() + 20);
                continue;
            }
            childContext.setY(childContext.getY() + pe.getGraphicsAlgorithm().getHeight() + 10);
        }
        childContext = SCADiagramAddCompositeFeature.createServiceAddContext(this.getFeatureProvider(), containerShape);
        for (Service service : addedComposite.getService()) {
            pe = this.addGraphicalRepresentation((IAreaContext)childContext, service);
            if (pe == null) {
                childContext.setY(childContext.getY() + 20);
                continue;
            }
            childContext.setY(childContext.getY() + pe.getGraphicsAlgorithm().getHeight() + 10);
        }
        childContext = SCADiagramAddCompositeFeature.createReferenceAddContext(this.getFeatureProvider(), containerShape);
        for (Reference reference : addedComposite.getReference()) {
            pe = this.addGraphicalRepresentation((IAreaContext)childContext, reference);
            if (pe == null) {
                childContext.setY(childContext.getY() + 20);
                continue;
            }
            childContext.setY(childContext.getY() + pe.getGraphicsAlgorithm().getHeight() + 10);
        }
        this.layoutPictogramElement((PictogramElement)containerShape);
        return containerShape;
    }

    public static AddContext createComponentAddContext(IFeatureProvider featureProvider, ContainerShape compositeContainer) {
        GraphicsAlgorithm ga = compositeContainer.getGraphicsAlgorithm();
        AddContext context = new AddContext();
        context.setX((ga.getWidth() - 100) / 2 + ga.getX());
        context.setY(Math.max(60 + ga.getY(), SCADiagramAddCompositeFeature.getMaxYForChildShapeCount(featureProvider, compositeContainer, Component.class)));
        context.setTargetContainer(compositeContainer);
        return context;
    }

    public static AddContext createServiceAddContext(IFeatureProvider featureProvider, ContainerShape compositeContainer) {
        GraphicsAlgorithm ga = compositeContainer.getGraphicsAlgorithm();
        AddContext context = new AddContext();
        context.setX(10);
        context.setY(Math.max(60 + ga.getY(), SCADiagramAddCompositeFeature.getMaxYForChildShapeCount(featureProvider, compositeContainer, Service.class)));
        context.setTargetContainer(compositeContainer);
        return context;
    }

    public static AddContext createReferenceAddContext(IFeatureProvider featureProvider, ContainerShape compositeContainer) {
        GraphicsAlgorithm ga = compositeContainer.getGraphicsAlgorithm();
        AddContext context = new AddContext();
        context.setX(ga.getX() + ga.getWidth() - 30 + 20 - 100);
        context.setY(Math.max(60 + ga.getY(), SCADiagramAddCompositeFeature.getMaxYForChildShapeCount(featureProvider, compositeContainer, Reference.class)));
        context.setTargetContainer(compositeContainer);
        return context;
    }

    private static int getMaxYForChildShapeCount(IFeatureProvider featureProvider, ContainerShape containerShape, Class<?> boType) {
        int maxY = 0;
        for (Shape shape : containerShape.getChildren()) {
            if (!boType.isInstance(featureProvider.getBusinessObjectForPictogramElement((PictogramElement)shape))) continue;
            maxY = Math.max(shape.getGraphicsAlgorithm().getHeight() + shape.getGraphicsAlgorithm().getY(), maxY);
        }
        if (maxY > 0) {
            maxY += 10;
        }
        return maxY;
    }
}

