/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.service;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformsType;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.composite.SCADiagramAddCompositeFeature;
import org.switchyard.tools.ui.editor.diagram.service.PromoteServiceWizard;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;

public class SCADiagramCustomPromoteServiceFeature
extends AbstractCustomFeature {
    private boolean _hasDoneChanges = false;

    public SCADiagramCustomPromoteServiceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void execute(ICustomContext context) {
        Object bo;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ComponentService) {
            ComponentService componentService = (ComponentService)bo;
            this.createService(componentService, (Shape)pes[0]);
            this.getDiagramBehavior().refresh();
        }
    }

    private void createService(ComponentService componentService, Shape componentServiceShape) {
        Service newService = null;
        PromoteServiceWizard wizard = new PromoteServiceWizard();
        wizard.init(componentService);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        WizardDialog wizDialog = new WizardDialog(shell, (IWizard)wizard);
        int rtn_code = wizDialog.open();
        if (rtn_code != 0) {
            this._hasDoneChanges = false;
            return;
        }
        newService = (Service)wizard.getContract();
        newService.setPromote(componentService);
        SwitchYardType switchYardRoot = MergedModelUtil.getSwitchYard((EObject)componentService);
        Composite composite = switchYardRoot.getComposite();
        composite.getService().add((Object)newService);
        this._hasDoneChanges = true;
        Collection<TransformType> newTransforms = wizard.getCreatedTransforms();
        if (newTransforms != null && newTransforms.size() > 0) {
            TransformsType transforms = switchYardRoot.getTransforms();
            if (transforms == null) {
                switchYardRoot.setTransforms(SwitchyardFactory.eINSTANCE.createTransformsType());
                transforms = switchYardRoot.getTransforms();
            }
            EList transformsList = transforms.getTransform();
            for (TransformType newTransform : newTransforms) {
                transformsList.add(newTransform);
            }
        }
        ContainerShape compositeShape = (ContainerShape)this.getFeatureProvider().getPictogramElementForBusinessObject((Object)composite);
        AddContext addServiceContext = SCADiagramAddCompositeFeature.createServiceAddContext(this.getFeatureProvider(), compositeShape);
        addServiceContext.setNewObject((Object)newService);
        this.addGraphicalRepresentation((IAreaContext)addServiceContext, newService);
    }

    public String getDescription() {
        return Messages.featureDescription_promoteService;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            return this.getBusinessObjectForPictogramElement(pes[0]) instanceof ComponentService;
        }
        return false;
    }

    public String getName() {
        return Messages.featureName_promoteService;
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_PROMOTE;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }
}

