/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.ITypeFactory;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.operations.AbstractSwitchYardProjectOperation;

public abstract class CreateTypeFeature<T extends EObject, C extends EObject>
extends AbstractCreateFeature {
    private boolean _hasDoneChanges;
    private ITypeFactory<T, C> _factory;
    private Class<C> _containerClass;

    public CreateTypeFeature(IFeatureProvider fp, ITypeFactory<T, C> factory, Class<C> containerClass, String name, String description) {
        super(fp, name, description);
        this._factory = factory;
        this._containerClass = containerClass;
    }

    public boolean canCreate(ICreateContext context) {
        ContainerShape pe = context.getTargetContainer();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)pe);
        return pe != null && this._containerClass.isInstance(bo) && !this.getDiagramBehavior().getEditingDomain().isReadOnly(((EObject)bo).eResource());
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    public Object[] create(ICreateContext context) {
        this._hasDoneChanges = false;
        T newObject = this._factory.createType(this.getShell(), this.getContainerObject(context));
        if (newObject == null) {
            return null;
        }
        Object[] addedObjects = this.updateContainer(context, newObject);
        if (addedObjects == null || addedObjects.length == 0) {
            return null;
        }
        this._hasDoneChanges = true;
        Object[] objectArray = addedObjects;
        int n = addedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.addGraphicalRepresentation((IAreaContext)context, object);
            ++n2;
        }
        this.updateProjectCapabilities(newObject);
        return addedObjects;
    }

    protected abstract Object[] updateContainer(ICreateContext var1, T var2);

    protected abstract Collection<String> getRequiredCapabilities(T var1);

    protected C getContainerObject(ICreateContext context) {
        return (C)((EObject)this._containerClass.cast(this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer())));
    }

    protected ITypeFactory<T, C> getFactory() {
        return this._factory;
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected void updateProjectCapabilities(T newObject) {
        final IProject project = this.getContainingProject(newObject);
        if (project == null) {
            return;
        }
        Collection<String> componentIDs = this.getRequiredCapabilities(newObject);
        if (componentIDs == null || componentIDs.isEmpty()) {
            return;
        }
        final HashSet<ISwitchYardComponentExtension> capabilities = new HashSet<ISwitchYardComponentExtension>();
        for (String id : componentIDs) {
            ISwitchYardComponentExtension capability = SwitchYardComponentExtensionManager.instance().getComponentExtension(id);
            if (capability == null) continue;
            capabilities.add(capability);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    new AbstractSwitchYardProjectOperation(null, capabilities, false, Messages.description_updateSwitchYardCapabilities, null){

                        protected IProject getProject() {
                            return project;
                        }

                        protected void execute(IProgressMonitor monitor) throws CoreException {
                        }
                    }.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.logStatus(e.getStatus());
                }
            }
        });
    }

    private IProject getContainingProject(T newObject) {
        Resource resource = MergedModelUtil.getSwitchYard(newObject.eContainer()).eResource();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true)));
        if (file == null || !file.getProject().isAccessible()) {
            return null;
        }
        return file.getProject();
    }
}

