/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.ui.common.ContractControl;
import org.switchyard.tools.ui.common.InterfaceControl;

public class NewContractWizardPage
extends WizardPage {
    private ContractControl _contractControl;

    public NewContractWizardPage(String pageName, String title, String description, EClass contractType) {
        this(pageName, title, description, contractType, EnumSet.of(InterfaceControl.InterfaceType.Java, InterfaceControl.InterfaceType.WSDL, InterfaceControl.InterfaceType.ESB));
    }

    public NewContractWizardPage(String pageName, String title, String description, EClass contractType, Set<InterfaceControl.InterfaceType> interfaceTypes) {
        super(pageName, title, null);
        this.setDescription(description);
        this._contractControl = new ContractControl(contractType, null, interfaceTypes);
    }

    public void createControl(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        contents.setLayoutData((Object)new GridData(768));
        this._contractControl.createControl(contents, 3);
        this._contractControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewContractWizardPage.this.validate();
            }
        });
        this.createAdditionalControls(contents, 3);
        this.validate();
        this.setErrorMessage(null);
        this.setControl((Control)contents);
    }

    public void init(Contract contract, Contract related) {
        this._contractControl.init(contract, related);
    }

    public Contract getContract() {
        return this._contractControl.getContract();
    }

    public void setJavaProject(IJavaProject project) {
        this._contractControl.setProject(project);
    }

    protected void createAdditionalControls(Composite content, int nColumns) {
    }

    protected void validate() {
        this.setMessage(null);
        this.setErrorMessage(null);
        IStatus status = this._contractControl.getStatus();
        switch (status.getSeverity()) {
            case 4: {
                this.setErrorMessage(status.getMessage());
                break;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 1: {
                this.setMessage(status.getMessage(), 1);
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

