/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.databinding.preference.PreferencePageSupport;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;
import org.switchyard.tools.ui.editor.util.FormToolkitUtil;

public abstract class AbstractPropertyPage<T extends EObject>
extends PropertyPage
implements ICompositeContainer {
    private static final String TRANSACTION_KEY = "switchyard.property.transaction";
    private FormToolkit _toolkit;
    private AbstractModelComposite<T> _composite;
    private DataBindingContext _context;
    private ObservablesManager _observablesManager;
    private PreferencePageSupport _support;

    public AbstractPropertyPage() {
        this.noDefaultAndApplyButton();
        this._context = new EMFDataBindingContext();
        this._observablesManager = new ObservablesManager();
        this._observablesManager.addObservablesFromContext(this._context, true, true);
    }

    @Override
    public FormToolkit getToolkit() {
        return this._toolkit;
    }

    @Override
    public void validated(IStatus status) {
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this._composite == null ? null : this._composite.getDescription(), 0);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(status.getMessage(), 1);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 4: {
                this.setErrorMessage(status.getMessage());
            }
        }
        this.setValid(this.getErrorMessage() == null);
    }

    @Override
    public void layout() {
        if (!this._composite.isDisposed()) {
            this._composite.layout(true);
        }
    }

    public boolean performCancel() {
        Transaction transaction = (Transaction)this.getShell().getData(TRANSACTION_KEY);
        if (transaction != null) {
            transaction.rollback();
        }
        this.getShell().setData(TRANSACTION_KEY, null);
        return true;
    }

    public boolean performOk() {
        Transaction transaction = (Transaction)this.getShell().getData(TRANSACTION_KEY);
        if (transaction != null) {
            try {
                transaction.commit();
            }
            catch (RollbackException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.title_errorCommittingModelChanges, (String)Messages.description_errorCommittingModelChanges, (IStatus)new Status(4, "org.switchyard.tools.ui.editor", e.getMessage(), (Throwable)e));
            }
        }
        this.getShell().setData(TRANSACTION_KEY, null);
        return true;
    }

    @Override
    public EObject getSelectedBusinessObject() {
        return (EObject)this.getElement().getAdapter(EObject.class);
    }

    protected Control createContents(final Composite parent) {
        if (this._toolkit == null) {
            FormColors colors = new FormColors(Display.getCurrent());
            colors.setBackground(null);
            colors.setForeground(null);
            this._toolkit = new FormToolkit(colors);
            FormToolkitUtil.updateFormToolkit(this._toolkit);
        }
        this._observablesManager.runAndCollect(new Runnable(){

            @Override
            public void run() {
                AbstractPropertyPage.this._composite = AbstractPropertyPage.this.createComposite(parent, 0);
            }
        });
        this._composite.refresh();
        this._composite.validate();
        this.setErrorMessage(null);
        this.initializeTransaction();
        this._support = PreferencePageSupport.create((PreferencePage)this, (DataBindingContext)this._context);
        return this._composite;
    }

    protected abstract AbstractModelComposite<T> createComposite(Composite var1, int var2);

    private void initializeTransaction() {
        Transaction transaction = (Transaction)this.getShell().getData(TRANSACTION_KEY);
        if (transaction != null) {
            return;
        }
        try {
            InternalTransactionalEditingDomain transactionalDomain = (InternalTransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)this.getSelectedBusinessObject());
            InternalTransaction newTransaction = transactionalDomain.startTransaction(false, null);
            this.getShell().setData(TRANSACTION_KEY, (Object)newTransaction);
            this.getShell().addDisposeListener(new DisposeListener((Transaction)newTransaction){
                private final /* synthetic */ Transaction val$newTransaction;
                {
                    this.val$newTransaction = transaction;
                }

                public void widgetDisposed(DisposeEvent event) {
                    if (this.val$newTransaction.isActive()) {
                        this.val$newTransaction.rollback();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected Composite getComposite() {
        return this._composite;
    }

    @Override
    public DataBindingContext getDataBindingContext() {
        return this._context;
    }

    @Override
    public ObservablesManager getObservablesManager() {
        return this._observablesManager;
    }

    public void dispose() {
        if (this._observablesManager != null) {
            this._observablesManager.dispose();
        }
        if (this._composite != null) {
            this._composite.dispose();
            this._composite = null;
        }
        if (this._toolkit != null) {
            this._toolkit.dispose();
            this._toolkit = null;
        }
        if (this._support != null) {
            this._support.dispose();
            this._support = null;
        }
        if (this._context != null) {
            this._context.dispose();
        }
        super.dispose();
    }
}

