/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.View;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.tabbed.AdvancedPropertySection;

public class SwitchyardAdvancedPropertySection
extends AdvancedPropertySection
implements IPropertySourceProvider {
    public IPropertySource getPropertySource(Object object) {
        IPropertySource source = null;
        AdapterFactoryContentProvider modelPropertySourceProvider = new AdapterFactoryContentProvider((AdapterFactory)this.initializeAdapterFactory());
        source = object instanceof EditPart ? modelPropertySourceProvider.getPropertySource(((EditPart)object).getModel()) : modelPropertySourceProvider.getPropertySource(object);
        if (source != null) {
            return new UnwrappingPropertySource(source);
        }
        return null;
    }

    protected IPropertySourceProvider getPropertySourceProvider() {
        return this;
    }

    protected AdapterFactory getAdapterFactory(Object object) {
        if (object instanceof EObject) {
            return this.initializeAdapterFactory();
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)object);
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            super.setInput(part, selection);
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        ArrayList<Object> transformedSelection = new ArrayList<Object>(structuredSelection.size());
        Iterator it = structuredSelection.iterator();
        while (it.hasNext()) {
            Object r = this.transformSelection(it.next());
            if (r == null) continue;
            transformedSelection.add(r);
        }
        super.setInput(part, (ISelection)new StructuredSelection(transformedSelection));
    }

    protected Object transformSelection(Object selected) {
        View view;
        if (selected instanceof ContainerShapeEditPart) {
            ContainerShapeEditPart csEdit = (ContainerShapeEditPart)selected;
            PictogramElement pe = csEdit.getPictogramElement();
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            return this.getPropertySourceProvider().getPropertySource((Object)bo);
        }
        if (selected instanceof EditPart) {
            Object model = ((EditPart)selected).getModel();
            return model instanceof View ? ((View)model).getElement() : null;
        }
        if (selected instanceof View) {
            return ((View)selected).getElement();
        }
        if (selected instanceof IAdaptable && (view = (View)((IAdaptable)selected).getAdapter(View.class)) != null) {
            return view.getElement();
        }
        return selected;
    }

    private ComposedAdapterFactory initializeAdapterFactory() {
        ArrayList factories = new ArrayList();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        return adapterFactory;
    }

    public class UnwrappingPropertySource
    implements IPropertySource {
        private IPropertySource _source;

        public UnwrappingPropertySource(IPropertySource source) {
            this._source = source;
        }

        public Object getEditableValue() {
            Object value = this._source.getEditableValue();
            if (value instanceof ItemPropertyDescriptor.PropertyValueWrapper) {
                ItemPropertyDescriptor.PropertyValueWrapper wrapper = (ItemPropertyDescriptor.PropertyValueWrapper)value;
                return wrapper.getEditableValue(null);
            }
            return this._source.getEditableValue();
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return this._source.getPropertyDescriptors();
        }

        public Object getPropertyValue(Object id) {
            Object value = this._source.getPropertyValue(id);
            if (value instanceof ItemPropertyDescriptor.PropertyValueWrapper) {
                ItemPropertyDescriptor.PropertyValueWrapper wrapper = (ItemPropertyDescriptor.PropertyValueWrapper)value;
                return wrapper.getEditableValue(null);
            }
            return this._source.getPropertyValue(id);
        }

        public boolean isPropertySet(Object id) {
            return this._source.isPropertySet(id);
        }

        public void resetPropertyValue(Object id) {
            this._source.resetPropertyValue(id);
        }

        public void setPropertyValue(Object id, Object value) {
            this._source.setPropertyValue(id, value);
        }
    }
}

