/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.component;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class ComponentSecurityPolicyComposite
extends AbstractModelComposite<Component> {
    private static final String AUTHORIZATION = "authorization";
    private boolean _inUpdate = false;
    private Button _authorizationCheckbox;
    private ArrayList<String> _supportedSecurityPolicies = new ArrayList();
    private CheckboxSelectionListener _listener = null;

    public ComponentSecurityPolicyComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        this._supportedSecurityPolicies.add(AUTHORIZATION);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 6;
        layout.marginTop = 6;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        this.setLayout((Layout)layout);
        FormToolkit factory = this.getWidgetFactory();
        this._authorizationCheckbox = factory.createButton((Composite)this, Messages.label_authorization, 32);
        FormData data = new FormData();
        data.left = new FormAttachment(1, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        this._authorizationCheckbox.setLayoutData((Object)data);
        this._listener = new CheckboxSelectionListener();
        this._authorizationCheckbox.addSelectionListener((SelectionListener)this._listener);
        this._authorizationCheckbox.setData((Object)AUTHORIZATION);
    }

    private void updatePolicy(final EObject target, final Button control) {
        final String securityPolicy = (String)control.getData();
        this.wrapOperation(new Runnable(){

            @Override
            public void run() {
                Implementation impl;
                if (target instanceof Implementation && (impl = (Implementation)target) != null) {
                    ArrayList<QName> requires = impl.getRequires();
                    ArrayList<String> existing = new ArrayList<String>();
                    if (requires != null) {
                        for (QName requiresItem : requires) {
                            String localPart = requiresItem.getLocalPart();
                            existing.add(localPart);
                        }
                        if (existing.contains(securityPolicy)) {
                            existing.remove(securityPolicy);
                        }
                    }
                    impl.setRequires(null);
                    requires = new ArrayList<QName>();
                    for (String existingItem : existing) {
                        QName newQName = new QName(existingItem);
                        requires.add(newQName);
                    }
                    if (control.getSelection()) {
                        QName newQName = new QName(securityPolicy);
                        requires.add(newQName);
                    }
                    if (!requires.isEmpty()) {
                        impl.setRequires(requires);
                    }
                }
            }
        });
    }

    @Override
    public void refresh() {
        this._inUpdate = true;
        try {
            boolean authorization = false;
            boolean showAuthorizationCheckbox = true;
            this._authorizationCheckbox.setSelection(false);
            Component component = (Component)this.getTargetObject();
            if (component != null) {
                List implrequires;
                Implementation impl;
                if (component.getImplementation() != null && (impl = component.getImplementation()) != null && (implrequires = impl.getRequires()) != null) {
                    for (QName requiresItem : implrequires) {
                        String localPart = requiresItem.getLocalPart();
                        if (!AUTHORIZATION.contentEquals(localPart)) continue;
                        authorization = true;
                    }
                }
                if (component.eContainer() instanceof Component && component instanceof ComponentReference) {
                    showAuthorizationCheckbox = false;
                }
            }
            if (!this._authorizationCheckbox.isDisposed()) {
                this._authorizationCheckbox.setEnabled(showAuthorizationCheckbox);
            }
            if (authorization && this._authorizationCheckbox != null && !this._authorizationCheckbox.isDisposed()) {
                this._authorizationCheckbox.setSelection(authorization);
            }
        }
        finally {
            this._inUpdate = false;
        }
    }

    public void dispose() {
        this._authorizationCheckbox.removeSelectionListener((SelectionListener)this._listener);
        super.dispose();
    }

    private class CheckboxSelectionListener
    implements SelectionListener {
        private CheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Implementation impl;
            Component component;
            if (e.widget.equals(ComponentSecurityPolicyComposite.this._authorizationCheckbox) && (component = (Component)ComponentSecurityPolicyComposite.this.getTargetObject()).getImplementation() != null && (impl = component.getImplementation()) != null && !ComponentSecurityPolicyComposite.this._inUpdate) {
                Button button = (Button)e.widget;
                ComponentSecurityPolicyComposite.this.updatePolicy((EObject)impl, button);
            }
        }
    }
}

