/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.intfc;

import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.editor.ComponentTypeExtensionManager;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class InterfaceControlComposite
extends AbstractModelComposite<Contract> {
    private Interface _interface;
    private InterfaceControl _interfaceControl = new InterfaceControl(null, EnumSet.of(InterfaceControl.InterfaceType.Java, InterfaceControl.InterfaceType.WSDL, InterfaceControl.InterfaceType.ESB));
    private Contract _service = null;
    private boolean _inUpdate = false;

    public InterfaceControlComposite(ICompositeContainer container, Composite parent, int style) {
        super(Contract.class, container, parent, style);
        int numColumns = 3;
        this.setLayout((Layout)new GridLayout(numColumns, false));
        this._interfaceControl.createControl((Composite)this, numColumns);
        this._interfaceControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                final Interface intf = InterfaceControlComposite.this._interfaceControl.getInterface();
                if (intf != null && !InterfaceControlComposite.this._inUpdate && InterfaceControlComposite.this._service != null) {
                    InterfaceControlComposite.this.wrapOperation(new Runnable(){

                        @Override
                        public void run() {
                            InterfaceControlComposite.this._service.setInterface(intf);
                        }
                    });
                }
            }
        });
        this.adaptChildren((Control)this);
    }

    @Override
    public void refresh() {
        this._inUpdate = true;
        Contract contract = (Contract)this.getTargetObject();
        if (contract != null) {
            this._interface = contract.getInterface();
            this._service = contract;
            this._interfaceControl.init(this._interface, null);
            this._interfaceControl.setProject(JavaCore.create((IProject)PlatformResourceAdapterFactory.getContainingProject((Object)contract)));
            if (this._service.eContainer() instanceof Component) {
                this._interfaceControl.setSupportedTypes(ComponentTypeExtensionManager.getSupportedInterfaceTypes((Component)contract.eContainer()));
            } else {
                this._interfaceControl.setSupportedTypes(EnumSet.allOf(InterfaceControl.InterfaceType.class));
            }
        }
        this._inUpdate = false;
    }
}

