/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.switchyard.tools.ui.editor.refactoring.CreateFolderChange;
import org.switchyard.tools.ui.editor.refactoring.UpdateReferencedModelURIChange;

public class SwitchYardMoveParticipant
extends MoveParticipant {
    private IFile _diagramFile;
    private IFolder _destination;

    protected boolean initialize(Object element) {
        if (!(element instanceof IFile)) {
            return false;
        }
        IFile modelFile = (IFile)element;
        IPath diagramPath = modelFile.getProject().getFullPath().append(".xml").append(modelFile.getProjectRelativePath()).addFileExtension("diagram");
        this._diagramFile = modelFile.getWorkspace().getRoot().getFile(diagramPath);
        IContainer destinationFolder = (IContainer)this.getArguments().getDestination();
        IPath destinationPath = destinationFolder.getProject().getFullPath().append(".xml").append(destinationFolder.getProjectRelativePath());
        this._destination = modelFile.getWorkspace().getRoot().getFolder(destinationPath);
        return this._diagramFile.exists();
    }

    public String getName() {
        return "SwitchYard Diagram File Move";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(this.getName());
        if (!this._destination.exists()) {
            change.add((Change)new CreateFolderChange(this._destination));
        } else {
            IFile newFile = this._destination.getFile(this._diagramFile.getName());
            if (newFile.exists()) {
                change.add((Change)new DeleteResourceChange(newFile.getFullPath(), true));
            }
        }
        change.add((Change)new MoveResourceChange((IResource)this._diagramFile, (IContainer)this._destination));
        change.add((Change)new UpdateReferencedModelURIChange(this._diagramFile){

            @Override
            protected IFile getDestination() {
                return SwitchYardMoveParticipant.this._destination.getFile(SwitchYardMoveParticipant.this._diagramFile.getName());
            }
        });
        return change;
    }
}

