/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.transform.CreateJavaTransformerOperation;
import org.switchyard.tools.ui.editor.transform.INewTransformWizard;
import org.switchyard.tools.ui.editor.transform.NewJavaTransformerClassPage;

public class NewJavaTransformerWizard
extends BasicNewResourceWizard
implements INewTransformWizard {
    private NewJavaTransformerClassPage _page;
    private IFile _newClassFile;
    private boolean _openAfterCreate = false;

    public NewJavaTransformerWizard() {
        this.setWindowTitle(Messages.title_newJavaTransformerClass);
        this.setNeedsProgressMonitor(true);
        this._page = new NewJavaTransformerClassPage();
    }

    @Override
    public void init(IProject project) {
        this._page.init(project);
        super.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)project));
    }

    public void addPages() {
        this.addPage((IWizardPage)this._page);
    }

    @Override
    public void setSelectedTransforms(Collection<TransformType> transforms) {
        this._page.setSelectedTransforms(transforms);
    }

    @Override
    public Collection<TransformType> getCreatedTransforms() {
        return Collections.emptyList();
    }

    public boolean performFinish() {
        final CreateJavaTransformerOperation op = new CreateJavaTransformerOperation(this._page, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (realException instanceof CoreException) {
                Activator.getDefault().getLog().log(((CoreException)realException).getStatus());
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.error_errorCreatingJavaTransformerClass, realException));
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.title_errorCreatingJavaTransformer, (String)realException.getMessage());
            if (!this._page.getModifiedResource().exists()) {
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        IResource resource = this._page.getModifiedResource();
        if (resource instanceof IFile) {
            this._newClassFile = (IFile)resource;
        }
        if (this._newClassFile != null && this._newClassFile.exists()) {
            this.selectAndReveal((IResource)this._newClassFile);
            if (!this._openAfterCreate) {
                return true;
            }
            final IWorkbenchPage activePage = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IDE.openEditor((IWorkbenchPage)activePage, (IFile)NewJavaTransformerWizard.this._newClassFile, (boolean)true);
                        }
                        catch (PartInitException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.error_errorOpeningNewJavaTransformer, (Throwable)e));
                        }
                    }
                });
            }
        }
        return true;
    }
}

