/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.transform.TransformFactory;
import org.switchyard.tools.models.switchyard1_0.transform.XsltTransformType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.transform.INewTransformWizard;
import org.switchyard.tools.ui.editor.transform.ITransformControl;
import org.switchyard.tools.ui.editor.transform.ITransformProvider;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;

public class XSLTransformProvider
implements ITransformProvider {
    private static final String TEMPLATE = "XSLTemplate.ftl";
    private static final String TRANSFORMS_PARAM = "transforms";

    @Override
    public boolean providesWizard() {
        return false;
    }

    @Override
    public INewTransformWizard createWizard() {
        return null;
    }

    @Override
    public ITransformControl createTransformControl(Composite parent, ITransformProvider.IContainer container) {
        return new XSLTransformControl(parent, container);
    }

    @Override
    public String getName() {
        return Messages.label_xslTransformer;
    }

    private static final class XSLTransformControl
    implements ITransformControl {
        private final ITransformProvider.IContainer _container;
        private final IJavaProject _project;
        private Collection<TransformType> _transforms;
        private Composite _content;
        private Text _fileText;
        private Button _createNewFileCheckbox;

        private XSLTransformControl(Composite parent, ITransformProvider.IContainer container) {
            this._container = container;
            this._project = JavaCore.create((IProject)container.getContainingProject());
            this._content = new Composite(parent, 0);
            this._content.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(this._content, 0);
            label.setText(Messages.label_xslFile);
            this._fileText = new Text(this._content, 2052);
            this._fileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    XSLTransformControl.this.internalValidate();
                }
            });
            this._fileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button browseButton = new Button(this._content, 8);
            browseButton.setText(Messages.button_browse);
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    XSLTransformControl.this.browse();
                }
            });
            new Label(this._content, 0);
            this._createNewFileCheckbox = new Button(this._content, 32);
            this._createNewFileCheckbox.setText(Messages.label_createNewXslFile);
            this._createNewFileCheckbox.setSelection(true);
            this._createNewFileCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    XSLTransformControl.this.internalValidate();
                }
            });
        }

        @Override
        public void setVisible(boolean visible) {
            this._content.setVisible(visible);
        }

        @Override
        public void setSelectedTransforms(Collection<TransformType> transforms) {
            this._transforms = transforms;
        }

        @Override
        public IStatus validate() {
            IStatus transformsStaus = this.validateSelectedTransformers();
            if (!transformsStaus.isOK()) {
                return transformsStaus;
            }
            String pathString = this._fileText.getText();
            Path path = new Path(pathString);
            if (!path.isValidPath(pathString)) {
                return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_invalidXslFilePath);
            }
            try {
                IFile file = this._container.getContainingProject().getWorkspace().getRoot().getFile((IPath)path);
                if (this._createNewFileCheckbox.getSelection()) {
                    if (file.exists()) {
                        return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_xslFileExists);
                    }
                } else if (!file.exists()) {
                    return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_xslFileDoesNotExist);
                }
                if (!this._project.isOnClasspath((IResource)file.getParent())) {
                    return new Status(2, "org.switchyard.tools.ui.editor", Messages.error_xslFileNotOnClasspath);
                }
            }
            catch (Exception e) {
                return new Status(4, "org.switchyard.tools.ui.editor", e.getMessage());
            }
            return Status.OK_STATUS;
        }

        private IStatus validateSelectedTransformers() {
            if (this._transforms == null) {
                return Status.OK_STATUS;
            }
            for (TransformType transformer : this._transforms) {
                if (!NewTransformWizard.isJavaType(transformer.getFrom()) && !NewTransformWizard.isJavaType(transformer.getTo())) continue;
                return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_xslDoesNotSupportJavaTypes);
            }
            return Status.OK_STATUS;
        }

        @Override
        public Collection<TransformType> createTransforms() throws CoreException {
            if (this._transforms == null || this._transforms.isEmpty()) {
                return Collections.emptyList();
            }
            IFile xslFile = this._project.getProject().getWorkspace().getRoot().getFile((IPath)new Path(this._fileText.getText()));
            if (this._createNewFileCheckbox.getSelection()) {
                this.createNewXSLFile(xslFile);
            }
            String xslFilePath = JavaUtil.getJavaPathForResource((IResource)xslFile).toString();
            ArrayList<TransformType> xslTransforms = new ArrayList<TransformType>(this._transforms.size());
            for (TransformType transform : this._transforms) {
                XsltTransformType xslTransform = TransformFactory.eINSTANCE.createXsltTransformType();
                xslTransform.setFrom(transform.getFrom());
                xslTransform.setTo(transform.getTo());
                xslTransform.setXsltFile(xslFilePath);
                xslTransforms.add((TransformType)xslTransform);
            }
            return xslTransforms;
        }

        @Override
        public void setLayoutData(Object data) {
            this._content.setLayoutData(data);
        }

        @Override
        public void dispose() {
        }

        private void internalValidate() {
            this._container.updateStatus(this, this.validate());
        }

        private void browse() {
            IResource resource;
            String pathString = this._fileText.getText();
            if (pathString == null || pathString.isEmpty()) {
                IResource temp = JavaUtil.getFirstResourceRoot((IJavaProject)this._project);
                resource = temp == null ? this._project.getResource() : temp;
            } else {
                Path path = new Path(pathString);
                if (path.isValidPath(pathString)) {
                    resource = this._project.getProject().getWorkspace().getRoot().getFile((IPath)path);
                } else {
                    IResource temp = JavaUtil.getFirstResourceRoot((IJavaProject)this._project);
                    IResource iResource = resource = temp == null ? this._project.getResource() : temp;
                }
            }
            if (this._createNewFileCheckbox.getSelection()) {
                FileSelectionWizard wizard = new FileSelectionWizard((IStructuredSelection)new StructuredSelection((Object)resource));
                WizardDialog dialog = new WizardDialog(this._content.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    this._fileText.setText(wizard.getSelection().toString());
                }
            } else {
                ClasspathResourceSelectionDialog dialog = new ClasspathResourceSelectionDialog(this._content.getShell(), (IContainer)resource.getProject(), new HashSet<String>(Arrays.asList("xsl", "xslt")));
                dialog.setInitialPattern("*.xsl");
                dialog.setTitle(Messages.title_selectXslFile);
                if (dialog.open() == 0) {
                    this._fileText.setText(((IResource)dialog.getFirstResult()).getFullPath().toString());
                }
            }
        }

        private void createNewXSLFile(final IFile file) throws CoreException {
            final IAdaptable uiInfo = WorkspaceUndoUtil.getUIInfoAdapter((Shell)this._content.getShell());
            final InputStream contents = this.createContents();
            try {
                try {
                    this._container.getContext().run(false, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                                    public void run(IProgressMonitor monitor) throws CoreException {
                                        try {
                                            new CreateFileOperation(file, null, contents, Messages.message_creatingXslTransformerFile).execute(monitor, uiInfo);
                                        }
                                        catch (ExecutionException e) {
                                            throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.error_errorCreatingXslTransformerFile, (Throwable)e));
                                        }
                                    }
                                }, monitor);
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Throwable realException = e.getTargetException();
                    if (realException instanceof CoreException) {
                        throw (CoreException)realException;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.error_errorCreatingXslTransformerFile, realException));
                }
                catch (InterruptedException e) {
                    throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.error_errorCreatingXslTransformerFile, (Throwable)e));
                }
            }
            finally {
                try {
                    contents.close();
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                }
            }
        }

        private InputStream createContents() throws CoreException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Configuration config = new Configuration();
                config.setClassForTemplateLoading(this.getClass(), "");
                config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(){

                    public TemplateModel wrap(final Object obj) throws TemplateModelException {
                        if (obj instanceof TransformType) {
                            return new TemplateHashModel(){

                                public boolean isEmpty() throws TemplateModelException {
                                    return false;
                                }

                                public TemplateModel get(String param) throws TemplateModelException {
                                    final QName qname = "from".equals(param) ? QName.valueOf(((TransformType)obj).getFrom()) : ("to".equals(param) ? QName.valueOf(((TransformType)obj).getTo()) : null);
                                    if (qname == null) {
                                        return null;
                                    }
                                    return new TemplateHashModel(){

                                        public boolean isEmpty() throws TemplateModelException {
                                            return false;
                                        }

                                        public TemplateModel get(String paramFrom) throws TemplateModelException {
                                            if ("localPart".equals(paramFrom)) {
                                                return this.wrap(qname.getLocalPart());
                                            }
                                            if ("namespaceURI".equals(paramFrom)) {
                                                return this.wrap(qname.getNamespaceURI());
                                            }
                                            return null;
                                        }
                                    };
                                }
                            };
                        }
                        return super.wrap(obj);
                    }
                });
                HashMap<String, Collection<TransformType>> parameters = new HashMap<String, Collection<TransformType>>();
                parameters.put(XSLTransformProvider.TRANSFORMS_PARAM, this._transforms);
                Template template = config.getTemplate(XSLTransformProvider.TEMPLATE);
                template.process(parameters, (Writer)new PrintWriter(baos));
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                return byteArrayInputStream;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.error_errorCreatingXslFile, (Throwable)e));
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                }
            }
        }

        private final class FileSelectionWizard
        extends Wizard {
            private WizardNewFileCreationPage _page;
            private IStructuredSelection _selection;
            private IPath _result;

            private FileSelectionWizard(IStructuredSelection selection) {
                this._selection = selection;
                this.setWindowTitle(Messages.title_newXslTransformerFile);
            }

            private IPath getSelection() {
                return this._result;
            }

            public boolean performFinish() {
                this._result = this._page.getContainerFullPath().append(this._page.getFileName());
                return true;
            }

            public void addPages() {
                this._page = new WizardNewFileCreationPage("pageName", this._selection){

                    protected boolean validatePage() {
                        if (super.validatePage()) {
                            IFile file = XSLTransformControl.this._project.getProject().getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
                            if (!XSLTransformControl.this._project.isOnClasspath((IResource)file.getParent())) {
                                this.setMessage(Messages.error_specifiedFileNotOnClasspath, 2);
                            }
                            return true;
                        }
                        return false;
                    }

                    protected void createAdvancedControls(Composite parent) {
                    }

                    protected IStatus validateLinkedResource() {
                        return Status.OK_STATUS;
                    }
                };
                IResource resource = (IResource)this._selection.getFirstElement();
                if (resource.getType() == 1) {
                    this._page.setFileName(resource.getFullPath().lastSegment());
                }
                this._page.setFileExtension("xsl");
                this._page.setDescription(Messages.description_newXslTransformerFile);
                this.addPage((IWizardPage)this._page);
            }
        }
    }
}

