/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.editor.BindingTypeExtensionManager;
import org.switchyard.tools.ui.editor.ComponentTypeExtensionManager;
import org.switchyard.tools.ui.validation.ValidationProblem;

public class CapabilitiesValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Composite) {
            return this.validate(ctx, (Composite)eObj);
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validate(IValidationContext ctx, Composite composite) {
        ValidationProblem problem;
        Set<ISwitchYardComponentExtension> required;
        ArrayList<ConstraintStatus> statuses = new ArrayList<ConstraintStatus>();
        Set<ISwitchYardComponentExtension> configured = this.getConfiguredCapabilities(composite);
        HashSet<ISwitchYardComponentExtension> allRequired = new HashSet<ISwitchYardComponentExtension>();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        ArrayList<Implementation> implementations = new ArrayList<Implementation>();
        TreeIterator it = composite.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (next instanceof Binding) {
                bindings.add((Binding)next);
                continue;
            }
            if (!(next instanceof Implementation)) continue;
            implementations.add((Implementation)next);
        }
        for (Binding binding : bindings) {
            required = this.getComponents(BindingTypeExtensionManager.instance().getExtensionFor(binding.getClass()).getRequiredCapabilities(binding));
            allRequired.addAll(required);
            required.removeAll(configured);
            for (ISwitchYardComponentExtension missing : required) {
                problem = ValidationProblem.RequiredCapabilityMissing;
                statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)binding.eContainer(), null, (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{missing.getName(), "binding"}));
            }
        }
        for (Implementation implementation : implementations) {
            required = this.getComponents(ComponentTypeExtensionManager.instance().getExtensionFor(implementation.getClass()).getRequiredCapabilities(implementation));
            allRequired.addAll(required);
            required.removeAll(configured);
            for (ISwitchYardComponentExtension missing : required) {
                problem = ValidationProblem.RequiredCapabilityMissing;
                statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)implementation.eContainer(), null, (int)problem.getSeverity(), (int)problem.ordinal(), (String)problem.getMessage(), (Object[])new Object[]{missing.getName(), "implementation"}));
            }
        }
        configured.removeAll(allRequired);
        configured.removeAll(SwitchYardComponentExtensionManager.instance().getComponentExtensions(ISwitchYardComponentExtension.Category.TEST));
        configured.remove(SwitchYardComponentExtensionManager.instance().getRuntimeComponentExtension());
        for (ISwitchYardComponentExtension superfluous : configured) {
            ValidationProblem problem2 = ValidationProblem.UnusedCapability;
            statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)composite, null, (int)problem2.getSeverity(), (int)problem2.ordinal(), (String)problem2.getMessage(), (Object[])new Object[]{superfluous.getName()}));
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
    }

    private Set<ISwitchYardComponentExtension> getComponents(Collection<String> ids) {
        if (ids == null) {
            return Collections.emptySet();
        }
        HashSet<ISwitchYardComponentExtension> components = new HashSet<ISwitchYardComponentExtension>();
        for (String id : ids) {
            ISwitchYardComponentExtension component = SwitchYardComponentExtensionManager.instance().getComponentExtension(id);
            if (component == null) continue;
            components.add(component);
        }
        return components;
    }

    private Set<ISwitchYardComponentExtension> getConfiguredCapabilities(Composite composite) {
        Resource resource = composite.eResource();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true)));
        return new HashSet<ISwitchYardComponentExtension>(SwitchYardProjectManager.instance().getSwitchYardProject(file.getProject()).getComponents());
    }
}

