/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.validator.wizards;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidateType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.property.adapters.LabelAdapter;
import org.switchyard.tools.ui.editor.util.ValidatorTypesUtil;

public class AddValidatorWizardStartPage
extends WizardPage {
    private ListViewer _listViewer;
    private ValidateType _validator = null;
    private static final int LIST_WIDTH = 60;
    private static final int LIST_HEIGHT = 10;

    protected AddValidatorWizardStartPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.title_createNewValidator);
        this.setDescription(Messages.description_createNewValidator);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        Label listLabel = new Label(composite, 0);
        listLabel.setText(Messages.label_validatorType);
        GridData labelGD = new GridData(768);
        labelGD.horizontalSpan = 2;
        listLabel.setLayoutData((Object)labelGD);
        this._listViewer = new ListViewer(composite, 2820);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        this._listViewer.getList().setLayoutData((Object)data);
        this._listViewer.getList().setFont(parent.getFont());
        List<ValidateType> typeList = ValidatorTypesUtil.getSupportedValidateTypes();
        this._listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ValidateType transform = (ValidateType)element;
                return LabelAdapter.getLabel((EObject)transform);
            }
        });
        this._listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List v = (List)inputElement;
                    return v.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this._listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                if (!ssel.isEmpty() && ssel.getFirstElement() instanceof ValidateType) {
                    AddValidatorWizardStartPage.this._validator = (ValidateType)ssel.getFirstElement();
                    AddValidatorWizardStartPage.this.handleModify();
                }
            }
        });
        this._listViewer.setInput(typeList);
        this.setControl((Control)composite);
        this.validate();
        this.setErrorMessage(null);
    }

    public ValidateType getValidator() {
        return this._validator;
    }

    private void handleModify() {
        this.validate();
    }

    private void validate() {
        String errorMessage = null;
        if (this._validator == null) {
            errorMessage = Messages.error_selectValidatorType;
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

