/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.PluginUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.RelationalPackage;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.modelgenerator.xml.XmlImporterUiPlugin;
import org.teiid.designer.modelgenerator.xsd.procedures.ITraversalCtxFactory;
import org.teiid.designer.modelgenerator.xsd.procedures.ProcedureBuilder;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public abstract class XSDElementProcedureBaseAction
extends SortableSelectionAction
implements IObjectActionDelegate,
IEditorActionDelegate,
IViewActionDelegate {
    protected PluginUtil util = XmlImporterUiPlugin.getDefault().getPluginUtil();
    protected ISelection selection;
    private IFile model;
    private RelationalFactory factory = RelationalPackage.eINSTANCE.getRelationalFactory();
    ModelResource modelResource;
    ProcedureBuilder builder;
    private ViewerFilter filter = new ViewerFilter(){

        public boolean select(Viewer theViewer, Object theParent, Object theElement) {
            boolean projectOpen;
            boolean result = false;
            if (theElement instanceof IResource && (projectOpen = ((IResource)theElement).getProject().isOpen())) {
                if (theElement instanceof IProject) {
                    result = true;
                } else if (theElement instanceof IFile) {
                    if (ModelUtil.isModelFile((IResource)((IFile)theElement)) && !ModelUtil.isXsdFile((IResource)((IFile)theElement))) {
                        ModelResource modelResource = ModelerCore.create((IFile)((IFile)theElement));
                        try {
                            if (!ModelUtil.isPhysical((Object)modelResource.getEmfResource())) {
                                result = true;
                            }
                        }
                        catch (ModelWorkspaceException modelWorkspaceException) {}
                    }
                } else if (theElement instanceof IFolder) {
                    result = true;
                }
            }
            return result;
        }
    };

    public boolean isApplicable(ISelection selection) {
        return this.isXSDElementDeclaration(selection);
    }

    protected boolean isValidSelection(ISelection selection) {
        return this.isXSDElementDeclaration(selection);
    }

    private boolean isXSDElementDeclaration(ISelection selection) {
        boolean result = false;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            if (((IStructuredSelection)selection).size() == 1 && sSelection.getFirstElement() instanceof XSDElementDeclaration) {
                result = true;
            }
        }
        return result;
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection);
        this.selection = selection;
    }

    public void run() {
        super.run();
        XSDElementDeclaration element = null;
        if (this.selection != null && this.selection instanceof IStructuredSelection) {
            IStructuredSelection theSelection = (IStructuredSelection)this.selection;
            Object object = theSelection.getFirstElement();
            if (object instanceof XSDElementDeclaration) {
                element = (XSDElementDeclaration)object;
            } else if (object instanceof Adapter) {
                element = (XSDElementDeclaration)((Adapter)object).getTarget();
            }
        }
        if (element != null) {
            this.browseWorkspaceForTargetModel();
        }
        if (this.model != null) {
            this.modelResource = ModelerCore.create((IFile)this.model);
            Schema schema = this.factory.createSchema();
            try {
                this.modelResource.getEmfResource().getContents().add((Object)schema);
            }
            catch (ModelWorkspaceException e) {
                String message = this.util.getString("XSDElementProcedureBaseAction.error.creating.schema.in.resource", new Object[]{this.modelResource.getResource().getName()});
                MessageDialog.openError((Shell)this.getShell(), (String)message, (String)e.getMessage());
                this.util.log(4, (Throwable)e, message);
            }
            schema.setName(element.getName());
            schema.setNameInSource(element.getName());
            this.builder = new ProcedureBuilder(schema, this.modelResource);
            ArrayList<XSDElementDeclaration> elements = new ArrayList<XSDElementDeclaration>();
            elements.add(element);
            try {
                this.builder.build(elements, this.getTraversalCtxFactory());
            }
            catch (ModelerCoreException e) {
                String message = this.util.getString("XSDElementProcedureBaseAction.error.creating.procedure", new Object[0]);
                MessageDialog.openError((Shell)this.getShell(), (String)message, (String)e.getMessage());
                this.util.log(4, (Throwable)e, message);
            }
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    String message;
                    try {
                        ModelUtilities.saveModelResource((ModelResource)XSDElementProcedureBaseAction.this.modelResource, (IProgressMonitor)monitor, (boolean)false, (Object)((Object)this));
                    }
                    catch (Exception e) {
                        message = XSDElementProcedureBaseAction.this.util.getString("XSDElementProcedureBaseAction.error.saving.resource", new Object[]{XSDElementProcedureBaseAction.this.modelResource.getResource().getName()});
                        MessageDialog.openError((Shell)XSDElementProcedureBaseAction.this.getShell(), (String)message, (String)e.getMessage());
                        XSDElementProcedureBaseAction.this.util.log(4, (Throwable)e, message);
                    }
                    XSDElementProcedureBaseAction.this.builder.createTransformations();
                    try {
                        ModelUtilities.saveModelResource((ModelResource)XSDElementProcedureBaseAction.this.modelResource, (IProgressMonitor)monitor, (boolean)false, (Object)((Object)this));
                    }
                    catch (Exception e) {
                        message = XSDElementProcedureBaseAction.this.util.getString("XSDElementProcedureBaseAction.error.saving.resource", new Object[]{XSDElementProcedureBaseAction.this.modelResource.getResource().getName()});
                        MessageDialog.openError((Shell)XSDElementProcedureBaseAction.this.getShell(), (String)message, (String)e.getMessage());
                        XSDElementProcedureBaseAction.this.util.log(4, (Throwable)e, message);
                    }
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            try {
                operation.run((IProgressMonitor)monitor);
            }
            catch (Exception ex) {
                if (ex instanceof InvocationTargetException) {
                    Throwable e = ((InvocationTargetException)ex).getTargetException();
                    String message = this.util.getString("XSDElementProcedureBaseAction.error.creating.procedure", new Object[0]);
                    MessageDialog.openError((Shell)this.getShell(), (String)message, (String)e.getMessage());
                    this.util.log(4, e, message);
                }
                ex.printStackTrace();
            }
        }
    }

    void browseWorkspaceForTargetModel() {
        MetamodelDescriptor descriptor = ModelerCore.getMetamodelRegistry().getMetamodelDescriptor("http://www.metamatrix.com/metamodels/Relational");
        Object[] resources = WidgetUtil.showWorkspaceObjectSelectionDialog((String)this.util.getStringOrKey("XSDElementProcedureBaseAction.dialog.browseTargetModel.title"), (String)this.util.getStringOrKey("XSDElementProcedureBaseAction.dialog.browseTargetModel.msg"), (boolean)false, null, (ViewerFilter)this.filter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(descriptor, false), (ILabelProvider)new ModelExplorerLabelProvider());
        if (resources != null && resources.length > 0) {
            this.model = (IFile)resources[0];
        }
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }

    public abstract ITraversalCtxFactory getTraversalCtxFactory();

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void init(IViewPart view) {
    }
}

