/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teiid.designer.modelgenerator.xml.XmlImporterUiPlugin;

public class MapResultSet
implements ResultSet {
    List values;
    Map names;
    String[] reverseNames;
    int row;
    boolean wasNull;
    MetaData metaData;

    public MapResultSet(List values, Map names) {
        this.values = Collections.unmodifiableList(values);
        this.names = names;
        this.reverseNames = new String[names.size() + 1];
        for (Object o : names.keySet()) {
            String name = (String)o;
            Number n = (Number)names.get(name);
            int column = n.intValue();
            this.reverseNames[column] = name;
        }
        this.row = -1;
        this.wasNull = false;
        this.metaData = new MetaData();
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getFetchSize() {
        return 1;
    }

    @Override
    public int getRow() {
        return this.row + 1;
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public void afterLast() {
        this.row = this.values.size();
    }

    @Override
    public void beforeFirst() {
        this.row = -1;
    }

    @Override
    public void cancelRowUpdates() {
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void close() {
    }

    @Override
    public void deleteRow() throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void insertRow() throws SQLException {
        this.throwReadOnly();
    }

    private void throwReadOnly() throws SQLException {
        throw new SQLException(XmlImporterUiPlugin.getDefault().getPluginUtil().getString("MapResultSet.readOnly", new Object[0]));
    }

    private void throwNotImplemented() throws SQLException {
        throw new SQLException(XmlImporterUiPlugin.getDefault().getPluginUtil().getString("MapResultSet.notImplemented", new Object[0]));
    }

    @Override
    public void moveToCurrentRow() {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateRow() throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public boolean first() {
        this.row = 0;
        return this.values.size() > 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.row >= this.values.size();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.row < 0;
    }

    @Override
    public boolean isFirst() {
        return this.row == 0;
    }

    @Override
    public boolean isLast() {
        return this.row == this.values.size() - 1;
    }

    @Override
    public boolean last() {
        this.row = this.values.size() - 1;
        return this.values.size() > 0;
    }

    @Override
    public boolean next() {
        ++this.row;
        return !this.isAfterLast();
    }

    @Override
    public boolean previous() {
        ++this.row;
        return !this.isBeforeFirst();
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public byte getByte(int columnIndex) {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0;
        }
        return new Byte(str);
    }

    @Override
    public double getDouble(int columnIndex) {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0.0;
        }
        return new Double(str);
    }

    @Override
    public float getFloat(int columnIndex) {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0.0f;
        }
        return new Float(str).floatValue();
    }

    @Override
    public int getInt(int columnIndex) {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0;
        }
        return new Integer(str);
    }

    @Override
    public long getLong(int columnIndex) {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0L;
        }
        return new Long(str);
    }

    @Override
    public short getShort(int columnIndex) {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0;
        }
        return new Short(str);
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public boolean absolute(int row) {
        this.row = row > 0 ? row - 1 : this.values.size() + row;
        return !this.isBeforeFirst() && !this.isAfterLast();
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return false;
        }
        return new Boolean(str);
    }

    @Override
    public boolean relative(int rows) {
        this.row += rows;
        return !this.isBeforeFirst() && !this.isAfterLast();
    }

    @Override
    public byte[] getBytes(int columnIndex) {
        Object o = this.getObject(columnIndex);
        boolean bl = this.wasNull = o == null;
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (this.wasNull) {
            return new byte[0];
        }
        return o.toString().getBytes();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Reader reader = this.getCharacterStream(columnIndex);
        boolean bl = this.wasNull = reader == null;
        if (this.wasNull) {
            return null;
        }
        return new ReaderInputStream(reader, "US-ASCII");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) {
        Object o = this.getObject(columnIndex);
        boolean bl = this.wasNull = o == null;
        if (this.wasNull) {
            return null;
        }
        if (o instanceof InputStream) {
            return (InputStream)o;
        }
        if (o instanceof Reader) {
            return new ReaderInputStream((Reader)o, "UTF16");
        }
        byte[] bytes = this.getBytes(columnIndex);
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Reader reader = this.getCharacterStream(columnIndex);
        boolean bl = this.wasNull = reader == null;
        if (this.wasNull) {
            return null;
        }
        return new ReaderInputStream(reader, "UTF16");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        boolean bl = this.wasNull = o == null;
        if (this.wasNull) {
            return null;
        }
        if (o instanceof Reader) {
            return (Reader)o;
        }
        if (o instanceof InputStream) {
            try {
                return new InputStreamReader((InputStream)o, "UTF16");
            }
            catch (UnsupportedEncodingException e) {
                throw this.wrapException(e);
            }
        }
        String str = this.getString(columnIndex);
        return new StringReader(str);
    }

    private SQLException wrapException(Exception e) {
        return new SQLException(e.toString());
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Object getObject(int columnIndex) {
        return this.getObjectFromRow(columnIndex, this.row);
    }

    Object getObjectFromRow(int columnIndex, int rowIndex) {
        List rowvalues = (List)this.values.get(rowIndex);
        return rowvalues.get(columnIndex - 1);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public String getCursorName() {
        return "";
    }

    @Override
    public String getString(int columnIndex) {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public byte getByte(String columnName) {
        int index = this.findColumn(columnName);
        return this.getByte(index);
    }

    @Override
    public double getDouble(String columnName) {
        int index = this.findColumn(columnName);
        return this.getDouble(index);
    }

    @Override
    public float getFloat(String columnName) {
        int index = this.findColumn(columnName);
        return this.getFloat(index);
    }

    @Override
    public int findColumn(String columnName) {
        Object o = this.names.get(columnName);
        Number n = (Number)o;
        int index = n.intValue();
        return index;
    }

    public String reverseFindColumn(int column) {
        return this.reverseNames[column];
    }

    @Override
    public int getInt(String columnName) {
        int index = this.findColumn(columnName);
        return this.getInt(index);
    }

    @Override
    public long getLong(String columnName) {
        int index = this.findColumn(columnName);
        return this.getLong(index);
    }

    @Override
    public short getShort(String columnName) {
        int index = this.findColumn(columnName);
        return this.getShort(index);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public boolean getBoolean(String columnName) {
        int index = this.findColumn(columnName);
        return this.getBoolean(index);
    }

    @Override
    public byte[] getBytes(String columnName) {
        int index = this.findColumn(columnName);
        return this.getBytes(index);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return null;
        }
        return new BigDecimal(str);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) {
        return this.getBigDecimal(columnIndex);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return null;
        }
        try {
            return new URL(str);
        }
        catch (MalformedURLException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Date getDate(int columnIndex) {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        try {
            return new Date(DateFormat.getDateInstance().parse(str).getTime());
        }
        catch (ParseException error) {
            throw new IllegalArgumentException(error);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public Statement getStatement() {
        return null;
    }

    @Override
    public Time getTime(int columnIndex) {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        try {
            return new Time(DateFormat.getTimeInstance().parse(str).getTime());
        }
        catch (ParseException error) {
            throw new IllegalArgumentException(error);
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        try {
            return new Timestamp(DateFormat.getInstance().parse(str).getTime());
        }
        catch (ParseException error) {
            throw new IllegalArgumentException(error);
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getAsciiStream(index);
    }

    @Override
    public InputStream getBinaryStream(String columnName) {
        int index = this.findColumn(columnName);
        return this.getBinaryStream(index);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getUnicodeStream(index);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getCharacterStream(index);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Object getObject(String columnName) {
        int index = this.findColumn(columnName);
        return this.getObject(index);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public String getString(String columnName) {
        int index = this.findColumn(columnName);
        return this.getString(index);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) {
        int index = this.findColumn(columnName);
        return this.getBigDecimal(index);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) {
        return this.getBigDecimal(columnName);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getURL(index);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        int index = this.findColumn(colName);
        return this.getArray(index);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        int index = this.findColumn(colName);
        return this.getBlob(index);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        int index = this.findColumn(colName);
        return this.getClob(index);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Date getDate(String columnName) {
        int index = this.findColumn(columnName);
        return this.getDate(index);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) {
        return this.getDate(columnIndex);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        int index = this.findColumn(colName);
        return this.getRef(index);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Time getTime(String columnName) {
        int index = this.findColumn(columnName);
        return this.getTime(index);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) {
        return this.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName) {
        int index = this.findColumn(columnName);
        return this.getTimestamp(index);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.throwReadOnly();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) {
        int index = this.findColumn(columnName);
        return this.getDate(index);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) {
        int index = this.findColumn(columnName);
        return this.getTime(index);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) {
        int index = this.findColumn(columnName);
        return this.getTimestamp(index);
    }

    @Override
    public int getHoldability() {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) {
        return null;
    }

    @Override
    public NClob getNClob(int columnIndex) {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) {
        return null;
    }

    @Override
    public String getNString(int columnIndex) {
        return null;
    }

    @Override
    public String getNString(String columnLabel) {
        return null;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) {
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) {
        int index = this.findColumn(columnLabel);
        return this.getObject(index);
    }

    @Override
    public RowId getRowId(int columnIndex) {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) {
        return null;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) {
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) {
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) {
    }

    @Override
    public void updateNString(int columnIndex, String string) {
    }

    @Override
    public void updateNString(String columnLabel, String string) {
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) {
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    class MetaData
    implements ResultSetMetaData {
        MetaData() {
        }

        @Override
        public String getCatalogName(int column) {
            return "";
        }

        @Override
        public String getColumnClassName(int column) {
            Class cls = this.getColumnClass(column);
            return cls.getName();
        }

        private Class getColumnClass(int column) {
            Class retval = null;
            int i = 0;
            while (i < MapResultSet.this.values.size()) {
                Object value = MapResultSet.this.getObjectFromRow(column, i);
                if (value != null) {
                    retval = value.getClass();
                    break;
                }
                ++i;
            }
            if (retval == null) {
                retval = Object.class;
            }
            return retval;
        }

        @Override
        public int getColumnCount() {
            return MapResultSet.this.names.size();
        }

        @Override
        public int getColumnDisplaySize(int column) {
            return 32;
        }

        @Override
        public String getColumnLabel(int column) {
            return MapResultSet.this.reverseFindColumn(column);
        }

        @Override
        public String getColumnName(int column) {
            return MapResultSet.this.reverseFindColumn(column);
        }

        @Override
        public int getColumnType(int column) {
            Class cls = this.getColumnClass(column);
            if (cls == String.class) {
                return 12;
            }
            if (cls == String.class) {
                return 12;
            }
            if (cls == BigDecimal.class) {
                return 2;
            }
            if (cls == Boolean.class) {
                return -7;
            }
            if (cls == Integer.class) {
                return 4;
            }
            if (cls == Long.class) {
                return -5;
            }
            if (cls == Float.class) {
                return 7;
            }
            if (cls == Double.class) {
                return 8;
            }
            if (cls == byte[].class) {
                return -3;
            }
            if (cls == Date.class) {
                return 91;
            }
            if (cls == Time.class) {
                return 92;
            }
            if (cls == Timestamp.class) {
                return 93;
            }
            if (cls == Timestamp.class) {
                return 93;
            }
            if (cls == Clob.class) {
                return 2005;
            }
            if (cls == Blob.class) {
                return 2004;
            }
            if (cls == Array.class) {
                return 2003;
            }
            if (cls == Struct.class) {
                return 2002;
            }
            if (cls == Ref.class) {
                return 2006;
            }
            return 2000;
        }

        @Override
        public String getColumnTypeName(int column) {
            Class cls = this.getColumnClass(column);
            return cls.getName();
        }

        @Override
        public int getPrecision(int column) {
            return 10;
        }

        @Override
        public int getScale(int column) {
            return 10;
        }

        @Override
        public String getSchemaName(int column) {
            return "";
        }

        @Override
        public String getTableName(int column) {
            return "";
        }

        @Override
        public boolean isAutoIncrement(int column) {
            return false;
        }

        @Override
        public boolean isCaseSensitive(int column) {
            return true;
        }

        @Override
        public boolean isCurrency(int column) {
            return false;
        }

        @Override
        public boolean isDefinitelyWritable(int column) {
            return false;
        }

        @Override
        public int isNullable(int column) {
            return 0;
        }

        @Override
        public boolean isReadOnly(int column) {
            return true;
        }

        @Override
        public boolean isSearchable(int column) {
            return false;
        }

        @Override
        public boolean isSigned(int column) {
            return false;
        }

        @Override
        public boolean isWritable(int column) {
            return false;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }
    }

    static class ReaderInputStream
    extends InputStream {
        private Reader reader;
        private static final String ASCII = "US-ASCII";
        private static final String UNICODE = "UTF16";
        private String charset;
        private byte[] buffer;

        public ReaderInputStream(Reader reader, String charset) {
            this.reader = reader;
            this.charset = charset;
            this.buffer = new byte[0];
        }

        @Override
        public int read() throws IOException {
            if (this.buffer.length > 0) {
                byte retval = this.buffer[0];
                byte[] newBytes = new byte[this.buffer.length - 1];
                System.arraycopy(this.buffer, 1, newBytes, 0, newBytes.length);
                this.buffer = newBytes;
                return retval;
            }
            int t = this.reader.read();
            if (t <= 0) {
                return t;
            }
            this.buffer = new Character((char)t).toString().getBytes(this.charset);
            if (this.buffer.length == 0) {
                return -1;
            }
            int retval = this.read();
            return retval;
        }
    }
}

