/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;
import org.teiid.designer.modelgenerator.xml.XmlImporterUiPlugin;
import org.teiid.designer.modelgenerator.xml.model.UserSettings;
import org.teiid.designer.schema.tools.model.schema.QName;
import org.teiid.designer.schema.tools.model.schema.RootElement;
import org.teiid.designer.schema.tools.model.schema.SchemaModel;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.processing.RelationshipProcessor;
import org.teiid.designer.schema.tools.processing.RelationshipProcessorFactory;
import org.teiid.designer.schema.tools.processing.SchemaProcessor;
import org.teiid.designer.schema.tools.processing.SchemaUtil;
import org.teiid.designer.schema.tools.processing.internal.SchemaProcessorImpl;

public class StateManager {
    protected Map xsds = new HashMap();
    private ResourceSet resourceSet;
    private SchemaModel schemaModel;
    private SchemaModel processedModel;
    private Collection selectedRoots;
    private SchemaProcessor processor;
    private RelationshipProcessor relationshipProcessor;
    private boolean schemasModified = false;
    private boolean modelDirty = true;
    UserSettings userSettings;
    int catalogType = 1;
    private String customCatalogName;
    public static final int SOURCE_DOCUMENT = 0;
    public static final int SOURCE_HTTP_NO_PARAMS = 1;
    public static final int SOURCE_HTTP_PARAMS = 2;
    public static final int SOURCE_HTTP_REQUEST_DOC = 3;
    public static final int SOURCE_ACS = 4;
    private boolean acsMode = false;
    public static String globalNamespace = XmlImporterUiPlugin.getDefault().getPluginUtil().getString("XsdAsRelationalImportWizard.globalNamespace", new Object[0]);

    public StateManager(UserSettings userSettings) {
        this.userSettings = userSettings;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new XSDResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        this.resourceSet = new ResourceSetImpl();
    }

    public void addSchema(Object key, URI uri) {
        this.xsds.put(key, uri);
        this.schemasModified = true;
    }

    public Set getSchemaKeySet() {
        return this.xsds.keySet();
    }

    public int getSchemaCount() {
        return this.xsds.size();
    }

    public Object removeSchema(Object key) {
        return this.xsds.remove(key);
    }

    public List getSchemaURIs() {
        return new ArrayList(this.xsds.values());
    }

    public Collection getPotentialRoots() throws Exception {
        if (this.processor == null) {
            this.processor = new SchemaProcessorImpl(UserSettings.getMergedChildSep());
        }
        if (this.schemaModel == null || this.schemasModified) {
            this.initSchemaModel();
            this.schemasModified = false;
        }
        if (this.selectedRoots == null) {
            this.selectedRoots = new HashSet();
        }
        List potentialRoots = this.schemaModel.getPotentialRootElements();
        for (RootElement elem : potentialRoots) {
            if (!elem.isUseAsRoot()) continue;
            this.selectedRoots.add(elem);
        }
        return potentialRoots;
    }

    public void setSelectedRoots(Collection selectedRoots) {
        this.selectedRoots = selectedRoots;
        this.modelDirty = true;
    }

    public boolean isUserSelectedRoot(SchemaObject element) {
        for (RootElement root : this.selectedRoots) {
            if (root.getKey() != element.getKey()) continue;
            return true;
        }
        return false;
    }

    private void initSchemaModel() throws Exception {
        List<Object> schemaUriList = Arrays.asList(this.xsds.values().toArray());
        ArrayList<XSDSchema> schemas = new ArrayList<XSDSchema>(schemaUriList.size());
        for (URI uRI : schemaUriList) {
            Resource res;
            File file = new File(uRI.toString());
            if (uRI.scheme() != null && uRI.scheme().equals("ACSResponse") || uRI.scheme() != null && uRI.scheme().equals("ACSRequest")) {
                ByteArrayInputStream stream = new ByteArrayInputStream(uRI.fragment().getBytes("UTF-8"));
                XSDResourceImpl acsResource = new XSDResourceImpl();
                acsResource.setURI(uRI);
                this.resourceSet.getResources().add((Object)acsResource);
                acsResource.load((InputStream)stream, new HashMap());
                res = acsResource;
            } else {
                URI resourceUri = file.isFile() ? URI.createFileURI((String)file.getCanonicalPath().toString()) : uRI;
                res = this.resourceSet.getResource(resourceUri, true);
            }
            schemas.add(((XSDResourceImpl)res).getSchema());
        }
        XSDSchema[] xSDSchemaArray = new XSDSchema[schemas.size()];
        schemas.toArray(xSDSchemaArray);
        this.processor.processSchemas(xSDSchemaArray);
        this.schemaModel = this.processor.getSchemaModel();
    }

    public SchemaModel getProcessedModel() {
        if (this.processedModel == null || !this.modelDirty) {
            if (this.relationshipProcessor == null) {
                this.relationshipProcessor = RelationshipProcessorFactory.getQueryOptimizingProcessor((int)this.userSettings.get_C_threshold(), (int)this.userSettings.get_P_threshold(), (int)this.userSettings.get_F_threshold());
            }
            this.processedModel = this.schemaModel.copy();
            HashSet roots = new HashSet(this.selectedRoots);
            this.processedModel.setSelectedRootElements(roots);
            this.relationshipProcessor.calculateRelationshipTypes(this.processedModel);
        }
        this.modelDirty = false;
        return this.processedModel;
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    public RelationshipProcessor getRelationshipProcessor() {
        return this.relationshipProcessor;
    }

    public List getCatalogs() {
        ArrayList<String> retVal = null;
        switch (this.getCatalogType()) {
            case 1: 
            case 2: {
                retVal = new ArrayList(0);
                break;
            }
            case 3: {
                retVal = this.getFileNames();
                break;
            }
            case 4: {
                retVal = new ArrayList(1);
                retVal.add(this.customCatalogName);
                break;
            }
            default: {
                retVal = new ArrayList<String>();
            }
        }
        return retVal;
    }

    public int getCatalogType() {
        return this.catalogType;
    }

    public void setCatalogType(int catalogType) {
        this.catalogType = catalogType;
    }

    private List getFileNames() {
        ArrayList<String> retVal = new ArrayList<String>(this.xsds.size());
        Collection xsdValues = this.xsds.values();
        for (URI uri : xsdValues) {
            retVal.add(SchemaUtil.shortenFileName((String)SchemaProcessorImpl.getSchemaFromURI((URI)uri).getSchemaLocation()));
        }
        return retVal;
    }

    public void setCustomCatalogName(String name) {
        this.customCatalogName = name;
    }

    public String getCustomCatalogName() {
        return this.customCatalogName;
    }

    public boolean isUsingNoCatalog() {
        return this.catalogType == 1;
    }

    public boolean isUsingNamespaces() {
        return this.catalogType == 2;
    }

    public boolean isUsingFileNames() {
        return this.catalogType == 3;
    }

    public boolean isUsingCustom() {
        return this.catalogType == 4;
    }

    public Map getNamespaces() {
        return this.schemaModel.getNamespaces();
    }

    public String getFirstCatalog() {
        String catalog = "";
        for (Object o : this.xsds.values()) {
            URI uri = (URI)o;
            catalog = SchemaProcessorImpl.getSchemaFromURI((URI)uri).getTargetNamespace();
        }
        return catalog;
    }

    public QName getRequestResponseTable() {
        String namespace;
        List catalogs = this.getCatalogs();
        int global = -1;
        int countExcludingGlobal = catalogs.size();
        int i = 0;
        while (i < catalogs.size()) {
            if (catalogs.get(i) == null || catalogs.get(i).equals(globalNamespace)) {
                global = i;
                --countExcludingGlobal;
                break;
            }
            ++i;
        }
        switch (countExcludingGlobal) {
            case 0: {
                namespace = globalNamespace;
                break;
            }
            case 1: {
                if (global == 0) {
                    namespace = (String)catalogs.get(1);
                    break;
                }
                namespace = (String)catalogs.get(0);
                break;
            }
            default: {
                if (global == -1) {
                    TreeSet treeSet = new TreeSet();
                    int i2 = 0;
                    while (i2 < catalogs.size()) {
                        treeSet.add(catalogs.get(i2));
                        ++i2;
                    }
                    namespace = (String)treeSet.first();
                    break;
                }
                namespace = (String)catalogs.get(global);
            }
        }
        return SchemaUtil.getQName((String)namespace, (String)this.userSettings.getRequestTableLocalName());
    }

    public Boolean isRequestOrResponseTable(QName qname) {
        if (this.userSettings.getSourceType() == 0 || 1 == this.userSettings.getSourceType()) {
            return null;
        }
        boolean retval = qname.equals((Object)this.getRequestResponseTable());
        return new Boolean(retval);
    }

    public String getCatalog(SchemaObject table) {
        String catalog = "";
        if (this.isUsingNamespaces() || this.isUsingNoCatalog()) {
            String namespace = table.getNamespace();
            catalog = namespace == null ? globalNamespace : CoreValidationRulesUtil.getValidString((String)namespace, null, (int)-1);
        }
        if (this.isUsingFileNames()) {
            catalog = table.getFileName();
        }
        if (this.isUsingCustom()) {
            catalog = (String)this.getCatalogs().get(0);
        }
        return catalog;
    }

    public void setACSMode(boolean acsMode) {
        this.acsMode = acsMode;
    }

    public boolean getACSMode() {
        return this.acsMode;
    }
}

