/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.wizards;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.JdbcFactory;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.impl.JdbcFactoryImpl;
import org.teiid.designer.jdbc.metadata.Includes;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.impl.JdbcDatabaseImpl;
import org.teiid.designer.jdbc.relational.JdbcImporter;
import org.teiid.designer.jdbc.relational.RelationalModelProcessor;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.jdbc.relational.util.JdbcModelProcessorManager;
import org.teiid.designer.jdbc.relational.util.JdbcRelationalUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.core.extension.XPackage;
import org.teiid.designer.modelgenerator.xml.XmlImporterUiPlugin;
import org.teiid.designer.modelgenerator.xml.jdbc.ui.util.JdbcUiUtil;
import org.teiid.designer.modelgenerator.xml.model.ConnectionImpl;
import org.teiid.designer.modelgenerator.xml.model.DatabaseMetaDataImpl;
import org.teiid.designer.modelgenerator.xml.model.UserSettings;
import org.teiid.designer.modelgenerator.xml.modelextension.BaseXMLRelationalExtensionManager;
import org.teiid.designer.modelgenerator.xml.modelextension.XMLFileExtensionManager;
import org.teiid.designer.modelgenerator.xml.modelextension.XMLHTTPExtensionManager;
import org.teiid.designer.modelgenerator.xml.modelextension.impl.BaseXMLRelationalExtensionManagerImpl;
import org.teiid.designer.modelgenerator.xml.wizards.IntroductionPage;
import org.teiid.designer.modelgenerator.xml.wizards.JdbcImportObjectsPage;
import org.teiid.designer.modelgenerator.xml.wizards.JdbcImportOptionsPage;
import org.teiid.designer.modelgenerator.xml.wizards.JdbcShowDifferencesPage;
import org.teiid.designer.modelgenerator.xml.wizards.PreferencePage;
import org.teiid.designer.modelgenerator.xml.wizards.RequestSelectionPage;
import org.teiid.designer.modelgenerator.xml.wizards.ResponseSelectionPage;
import org.teiid.designer.modelgenerator.xml.wizards.RootElementsPage;
import org.teiid.designer.modelgenerator.xml.wizards.StateManager;
import org.teiid.designer.modelgenerator.xml.wizards.jdbc.XmlImporterJdbcDriver;
import org.teiid.designer.schema.tools.model.schema.SchemaModel;
import org.teiid.designer.schema.tools.processing.RelationshipProcessor;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class XsdAsRelationalImportWizard
extends AbstractWizard
implements IImportWizard {
    protected static final String WIZARD_TITLE = "title";
    protected static final String XML_FILE_EXTENSION_NAME = "XMLFileExtension";
    protected static final String XML_HTTP_EXTENSION_NAME = "XMLHTTPExtension";
    protected static final String XML_ACS_EXTENSION_NAME = "XMLACSExtension";
    protected static final String TABLES_CLASS_NAME = "RelTables";
    protected static final String CATALOGS_CLASS_NAME = "RelCatalogs";
    protected static final String COLUMNS_CLASS_NAME = "RelColumns";
    protected static final String NAMESPACEPREFIXES_ATTRIBUTE_NAME = "NamespacePrefixes";
    protected static final String COLUMNROLE_ATTRIBUTE_NAME = "Role";
    protected static final String COLUMN_INPUT_PARAM_ATTRIBUTE_NAME = "IsInputParameter";
    protected static final String ACS_URI_SCHEME_RESPONSE = "ACSResponse";
    protected static final String ACS_URI_SCHEME_REQUEST = "ACSRequest";
    protected static final String XPATH_ROOT_FOR_INPUT_ATTRIBUTE_NAME = "XPathRootForInput";
    public static final String RESPONSE_ID_IN_COL_NAME = "ResponseIn";
    public static final String RESPONSE_ID_OUT_COL_NAME = "ResponseOut";
    public static final String COLUMN_ROLE_ENUM = "ColumnRole";
    public static final String RESPONSE_IN_ROLE_ENUM_VALUE = "Response In";
    public static final String RESPONSE_OUT_ROLE_ENUM_VALUE = "Response Out";
    public static final int NO_CATALOG_VAL = 1;
    public static final int NAMESPACE_CATALOG_VAL = 2;
    public static final int FILENAME_CATALOG_VAL = 3;
    public static final int CUSTOM_CATALOG_VAL = 4;
    StateManager manager;
    public static BaseXMLRelationalExtensionManager extManager;
    IntroductionPage introductionPage;
    ResponseSelectionPage responseSelectionPage;
    RequestSelectionPage requestSelectionPage;
    RootElementsPage rootElementsPage;
    JdbcShowDifferencesPage diffsPg;
    JdbcImportOptionsPage optionsPg;
    JdbcImportObjectsPage importObjectsPg;
    UserSettings userSettings;
    RelationshipProcessor relationshipProcessor;
    JdbcFactory jdbcFactory;
    ConnectionImpl jdbcConnection;
    private static final String I18N_PREFIX;
    private static final ImageDescriptor IMAGE;
    PluginUtil util = XmlImporterUiPlugin.getDefault().getPluginUtil();
    private String TITLE = this.getString("title");
    protected String COPY_ERROR_MESSAGE = this.getString("copyErrorMessage");
    private String IMPORT_ERROR_MESSAGE = this.getString("importErrorMessage");
    private static boolean importLicensed;
    private JdbcImporter importer;
    private IContainer folder;
    private String modelName;
    IStatus status;
    DifferenceReport drDifferenceReport;
    ProcessorPack ppProcessorPack;

    static {
        I18N_PREFIX = I18nUtil.getPropertyPrefix(XsdAsRelationalImportWizard.class);
        IMAGE = XmlImporterUiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importDatabase.gif");
        importLicensed = false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.createState();
        if (selection != null && !selection.isEmpty()) {
            List acsPreLoadValues;
            Object obj = selection.getFirstElement();
            if (obj instanceof IProject || obj instanceof IFile) {
                IContainer folder = ModelUtil.getContainer((Object)obj);
                try {
                    if (folder != null && folder.getProject().getNature("org.teiid.designer.core.modelNature") != null) {
                        this.folder = folder;
                    }
                }
                catch (CoreException err) {
                    this.util.log((Throwable)err);
                    WidgetUtil.showError((Throwable)err);
                }
            } else if (obj instanceof String && ((String)obj).equals("acsMode") && (String)(acsPreLoadValues = selection.toList()).get(0) == "acsMode") {
                String opaquePart = String.valueOf((String)acsPreLoadValues.get(1)) + ":" + (String)acsPreLoadValues.get(2);
                this.manager.setACSMode(true);
                this.manager.setCatalogType(4);
                this.manager.setCustomCatalogName((String)acsPreLoadValues.get(2));
                URI acsURI = URI.createGenericURI((String)ACS_URI_SCHEME_RESPONSE, (String)opaquePart, (String)((String)acsPreLoadValues.get(4)));
                this.manager.addSchema(ACS_URI_SCHEME_RESPONSE, acsURI);
                this.setModelName(String.valueOf((String)acsPreLoadValues.get(1)) + "_" + (String)acsPreLoadValues.get(2));
            }
        }
        this.importer = new JdbcImporter();
        this.introductionPage = new IntroductionPage(this);
        if (!this.manager.getACSMode()) {
            this.addPage((IWizardPage)this.introductionPage);
        } else {
            this.userSettings.setSourceType(4);
        }
        this.responseSelectionPage = new ResponseSelectionPage(this, this.util);
        if (!this.manager.getACSMode()) {
            this.addPage((IWizardPage)this.responseSelectionPage);
        }
        this.requestSelectionPage = new RequestSelectionPage(this, this.util);
        this.rootElementsPage = new RootElementsPage(this);
        this.addPage((IWizardPage)this.rootElementsPage);
        this.importObjectsPg = new JdbcImportObjectsPage();
        this.addPage((IWizardPage)this.importObjectsPg);
        this.optionsPg = new JdbcImportOptionsPage();
        this.addPage((IWizardPage)this.optionsPg);
        this.diffsPg = new JdbcShowDifferencesPage(this);
        this.addPage((IWizardPage)this.diffsPg);
        if (this.importer.getUpdatedModel() != null) {
            this.optionsPg.setPageComplete(false);
        }
        String wizardTitle = this.getString(WIZARD_TITLE);
        this.setWindowTitle(wizardTitle);
    }

    private void createState() {
        this.userSettings = new UserSettings((Object)this);
        new PreferencePage();
        IPreferenceStore prefs = XmlImporterUiPlugin.getDefault().getPreferenceStore();
        int cThreshold = prefs.getInt("c_Threshold");
        int pThreshold = prefs.getInt("p_Threshold");
        int fThreshold = prefs.getInt("f_Threshold");
        this.userSettings.set_C_threshold(cThreshold);
        this.userSettings.set_P_threshold(pThreshold);
        this.userSettings.set_F_threshold(fThreshold);
        this.manager = new StateManager(this.userSettings);
        String requestTableLocalName = prefs.getString("requestTable");
        this.userSettings.setRequestTableLocalName(requestTableLocalName);
        String mergedChildSep = prefs.getString("mergedChildSep");
        this.userSettings.setMergedChildSep(mergedChildSep);
        this.jdbcFactory = new JdbcFactoryImpl();
        this.jdbcConnection = new ConnectionImpl(this.manager, this.userSettings, (Object)this);
    }

    public UserSettings getUserSettings() {
        return this.userSettings;
    }

    public RelationshipProcessor getRelationshipProcessor() {
        return this.relationshipProcessor;
    }

    void setUseSchemaTypes(boolean useSchemaTypes) {
        this.userSettings.setUseSchemaTypes(useSchemaTypes);
    }

    void schemaChanged(SchemaModel model) {
        this.jdbcConnection.changed();
        try {
            String validatedName;
            String dbName = this.jdbcConnection.getCatalog();
            if (dbName == null || dbName.equals("")) {
                Object oFirstURI;
                Iterator iter = this.manager.getSchemaURIs().iterator();
                Object v0 = oFirstURI = iter.hasNext() ? this.manager.getSchemaURIs().iterator().next() : null;
                if (oFirstURI instanceof URI) {
                    URI firstURI = oFirstURI;
                    String lastSegment = firstURI.lastSegment();
                    int dot = lastSegment.indexOf(46);
                    dbName = dot > 0 ? lastSegment.substring(0, dot) : lastSegment;
                }
            }
            if ((validatedName = CoreValidationRulesUtil.getValidString((String)dbName, null, (int)-1)) != null) {
                dbName = validatedName;
            }
            JdbcDatabaseImpl db = new JdbcDatabaseImpl((Connection)this.jdbcConnection, dbName);
            this.setDatabase((JdbcDatabase)db);
            JdbcSource source = this.jdbcFactory.createJdbcSource();
            source.setDriverClass(XmlImporterJdbcDriver.class.getName());
            source.setDriverName(XmlImporterJdbcDriver.class.getName());
            Includes includes = db.getIncludes();
            includes.setApproximateIndexes(false);
            includes.setIncludeForeignKeys(true);
            includes.setIncludeIndexes(false);
            includes.setIncludeProcedures(false);
            includes.setUniqueIndexesOnly(false);
            String[] tableTypeNames = DatabaseMetaDataImpl.getTableTypeNames();
            includes.setIncludedTableTypes(tableTypeNames);
            JdbcImportSettings importSettings = this.jdbcFactory.createJdbcImportSettings();
            importSettings.setIncludeApproximateIndexes(false);
            importSettings.setIncludeForeignKeys(true);
            importSettings.setIncludeIndexes(true);
            importSettings.setIncludeProcedures(false);
            importSettings.setIncludeUniqueIndexes(false);
            EList tableTypes = importSettings.getIncludedTableTypes();
            int i = 0;
            while (i < tableTypeNames.length) {
                String tableType = tableTypeNames[i];
                tableTypes.add(tableType);
                ++i;
            }
            source.setImportSettings(importSettings);
            source.setJdbcDriver(null);
            source.setJdbcSourceContainer(null);
            String location = null;
            StringBuffer url = new StringBuffer();
            url.append("xsd:");
            boolean first = true;
            for (Object o : this.manager.getSchemaURIs()) {
                URI uri = (URI)o;
                location = this.manager.getACSMode() ? uri.trimFragment().toString() : uri.toString();
                if (!first) {
                    url.append("&");
                }
                first = false;
                url.append(location);
            }
            source.setUrl(url.toString());
            source.setUsername("");
            this.setSource(source);
            this.processModelName((JdbcDatabase)db);
        }
        catch (Exception err) {
            JdbcUiUtil.showError(err, this.COPY_ERROR_MESSAGE);
        }
    }

    private String getString(String id) {
        return this.util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public XsdAsRelationalImportWizard() {
        super((AbstractUIPlugin)XmlImporterUiPlugin.getDefault(), "", IMAGE);
        super.setWindowTitle(this.TITLE);
    }

    public void createPageControls(Composite pageContainer) {
        if (importLicensed) {
            super.createPageControls(pageContainer);
        }
    }

    public boolean finish() {
        boolean result = false;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        if (XsdAsRelationalImportWizard.this.ppProcessorPack == null) {
                            XPackage xPackage = XsdAsRelationalImportWizard.this.getExtensionPackage(XsdAsRelationalImportWizard.this.getFolder());
                            JdbcSource src = XsdAsRelationalImportWizard.this.getSource();
                            RelationalModelProcessor processor = JdbcModelProcessorManager.createRelationalModelProcessor();
                            processor.setMoveRatherThanCopyAdds(!XsdAsRelationalImportWizard.this.isUpdatedModel());
                            IFile modelFile = XsdAsRelationalImportWizard.this.getFolder().getFile((IPath)new Path(XsdAsRelationalImportWizard.this.getModelName()));
                            ModelResource resrc = ModelerCore.create((IFile)modelFile);
                            ModelAnnotation modelAnnotation = resrc.getModelAnnotation();
                            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                            modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
                            if (xPackage == null) {
                                XsdAsRelationalImportWizard.this.util.log(2, XsdAsRelationalImportWizard.this.util.getString("XsdAsRelationalImportWizard.nullXPackage", new Object[0]));
                            } else {
                                modelAnnotation.setExtensionPackage(xPackage);
                            }
                            if (resrc instanceof ModelResourceImpl) {
                                ((ModelResourceImpl)resrc).setModelType(ModelType.PHYSICAL_LITERAL);
                            }
                            XsdAsRelationalImportWizard.this.status = processor.execute(resrc, XsdAsRelationalImportWizard.this.getDatabase(), src.getImportSettings(), monitor);
                            XsdAsRelationalImportWizard.this.ppProcessorPack = new ProcessorPack(processor, src, modelFile, resrc);
                        } else {
                            XsdAsRelationalImportWizard.this.status = XsdAsRelationalImportWizard.this.ppProcessorPack.getProcessor().execute(XsdAsRelationalImportWizard.this.ppProcessorPack.getModelResource(), XsdAsRelationalImportWizard.this.getDatabase(), XsdAsRelationalImportWizard.this.ppProcessorPack.getJdbcSource().getImportSettings(), monitor);
                        }
                        if (XsdAsRelationalImportWizard.this.status.getSeverity() != 4) {
                            List objs = XsdAsRelationalImportWizard.this.ppProcessorPack.getModelResource().getAllRootEObjects();
                            Iterator iter = objs.iterator();
                            while (iter.hasNext()) {
                                if (!(iter.next() instanceof JdbcSource)) continue;
                                iter.remove();
                                break;
                            }
                            XsdAsRelationalImportWizard.this.ppProcessorPack.getJdbcSource().setJdbcDriver(null);
                            objs.add(XsdAsRelationalImportWizard.this.ppProcessorPack.getJdbcSource());
                            XsdAsRelationalImportWizard.this.ppProcessorPack.getModelResource().save(monitor, true);
                            XsdAsRelationalImportWizard.this.getFolder().refreshLocal(2, monitor);
                            ModelEditorManager.activate((IFile)XsdAsRelationalImportWizard.this.ppProcessorPack.getModelFile(), (boolean)true);
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        monitor.done();
                        XsdAsRelationalImportWizard.this.ppProcessorPack = null;
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    monitor.done();
                    XsdAsRelationalImportWizard.this.ppProcessorPack = null;
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            switch (this.status.getSeverity()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    this.util.log(this.status);
                    WidgetUtil.showError((String)this.IMPORT_ERROR_MESSAGE);
                }
            }
            result = true;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            JdbcUiUtil.showError(err, this.IMPORT_ERROR_MESSAGE);
        }
        return result;
    }

    protected XPackage getExtensionPackage(IContainer folder) throws ModelerCoreException {
        extManager = this.getExtension();
        extManager.loadModelExtensions(folder, (IProgressMonitor)new NullProgressMonitor());
        return extManager.getPackage();
    }

    protected BaseXMLRelationalExtensionManager getExtension() {
        BaseXMLRelationalExtensionManagerImpl modelExtension = this.userSettings.getSourceType() == 0 ? new XMLFileExtensionManager() : new XMLHTTPExtensionManager();
        return modelExtension;
    }

    public boolean canFinish() {
        boolean bCanFinish = false;
        boolean bUpdateSelected = false;
        boolean bDiffsDisplayed = false;
        if (this.diffsPg != null) {
            bDiffsDisplayed = this.diffsPg.isVisible();
        }
        boolean bUpdateStepsPending = false;
        if (bUpdateSelected && !bDiffsDisplayed) {
            bUpdateStepsPending = true;
        }
        bCanFinish = super.canFinish() && this.getDatabase() != null && this.getSource() != null && this.getFolder() != null && this.getModelName() != null && !bUpdateStepsPending;
        return bCanFinish;
    }

    public void dispose() {
        if (importLicensed) {
            try {
                this.importer.disconnect();
            }
            catch (SQLException err) {
                JdbcUiUtil.showAccessError(err);
            }
        }
        super.dispose();
    }

    protected void setSource(JdbcSource source) {
        this.importer.setSource(source);
    }

    protected void setDatabase(JdbcDatabase database) {
        this.importer.setDatabase(database);
    }

    JdbcSource getSource() {
        return this.importer.getSource();
    }

    JdbcDatabase getDatabase() {
        return this.importer.getDatabase();
    }

    IContainer getFolder() {
        return this.folder;
    }

    String getModelName() {
        return this.modelName;
    }

    boolean isUpdatedModel() {
        return this.importer.getUpdatedModel() != null;
    }

    void setFolder(IContainer folder) {
        CoreArgCheck.isNotNull((Object)folder);
        this.folder = folder;
    }

    void setModelName(String name) {
        CoreArgCheck.isNotEmpty((String)name);
        this.modelName = name;
    }

    public DifferenceReport getDifferenceReport() {
        if (this.drDifferenceReport == null) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            JdbcSource src = XsdAsRelationalImportWizard.this.getSource();
                            RelationalModelProcessor processor = JdbcModelProcessorManager.createRelationalModelProcessor();
                            processor.setMoveRatherThanCopyAdds(!XsdAsRelationalImportWizard.this.isUpdatedModel());
                            IFile modelFile = XsdAsRelationalImportWizard.this.getFolder().getFile((IPath)new Path(XsdAsRelationalImportWizard.this.getModelName()));
                            ModelResource resrc = ModelerCore.create((IFile)modelFile);
                            ModelAnnotation modelAnnotation = resrc.getModelAnnotation();
                            modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                            modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
                            if (resrc instanceof ModelResourceImpl) {
                                ((ModelResourceImpl)resrc).setModelType(ModelType.PHYSICAL_LITERAL);
                            }
                            if (processor instanceof RelationalModelProcessorImpl) {
                                XsdAsRelationalImportWizard.this.drDifferenceReport = ((RelationalModelProcessorImpl)processor).generateDifferenceReport(resrc, XsdAsRelationalImportWizard.this.getDatabase(), src.getImportSettings(), monitor);
                            }
                            XsdAsRelationalImportWizard.this.ppProcessorPack = new ProcessorPack(processor, src, modelFile, resrc);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            monitor.done();
                        }
                        catch (Exception err) {
                            throw new InvocationTargetException(err);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, op);
            }
            catch (Throwable err) {
                if (err instanceof InvocationTargetException) {
                    err = ((InvocationTargetException)err).getTargetException();
                }
                JdbcUiUtil.showError(err, this.IMPORT_ERROR_MESSAGE);
            }
        }
        return this.drDifferenceReport;
    }

    protected void processModelName(JdbcDatabase db) throws ModelWorkspaceException {
        if (this.getModelName() == null) {
            String modelName = CoreValidationRulesUtil.getValidString((String)db.getName(), null, (int)-1);
            if (modelName == null) {
                modelName = db.getName();
            }
            if (!CoreStringUtil.isEmpty((String)(modelName = FileUtils.toFileNameWithExtension((String)modelName, (String)".xmi"))) && ModelerCore.getWorkspace().validateName(modelName, 1).isOK()) {
                ModelResource model;
                IResource resrc;
                this.setModelName(modelName);
                if (this.folder != null && (resrc = this.folder.findMember(modelName)) != null && (model = JdbcRelationalUtil.getPhysicalModifiableRelationalModel((Object)resrc)) != null) {
                    this.importer.setUpdatedModel(model);
                }
            }
        }
    }

    public StateManager getStateManager() {
        return this.manager;
    }

    class ProcessorPack {
        private RelationalModelProcessor rmpProcessor;
        private JdbcSource src;
        private IFile modelFile;
        private ModelResource resrc;

        public ProcessorPack() {
        }

        public ProcessorPack(RelationalModelProcessor rmpProcessor, JdbcSource src, IFile modelFile, ModelResource resrc) {
            this.rmpProcessor = rmpProcessor;
            this.src = src;
            this.modelFile = modelFile;
            this.resrc = resrc;
        }

        public void setProcessor(RelationalModelProcessor rmpProcessor) {
            this.rmpProcessor = rmpProcessor;
        }

        public RelationalModelProcessor getProcessor() {
            return this.rmpProcessor;
        }

        public void setJdbcSource(JdbcSource src) {
            this.src = src;
        }

        public JdbcSource getJdbcSource() {
            return this.src;
        }

        public void setModelFile(IFile modelFile) {
            this.modelFile = modelFile;
        }

        public IFile getModelFile() {
            return this.modelFile;
        }

        public void setModelResource(ModelResource resrc) {
            this.resrc = resrc;
        }

        public ModelResource getModelResource() {
            return this.resrc;
        }
    }
}

