/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xml.wizards.jdbc;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.relational.impl.Context;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.AccessPattern;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ColumnSet;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.RelationalEntity;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;
import org.teiid.designer.modelgenerator.xml.model.DatabaseMetaDataImpl;
import org.teiid.designer.modelgenerator.xml.modelextension.BaseXMLRelationalExtensionManager;
import org.teiid.designer.modelgenerator.xml.modelextension.XMLHTTPExtensionManager;
import org.teiid.designer.modelgenerator.xml.modelextension.impl.XMLRequestResponseExtensionManagerImpl;
import org.teiid.designer.modelgenerator.xml.wizards.StateManager;
import org.teiid.designer.modelgenerator.xml.wizards.XsdAsRelationalImportWizard;
import org.teiid.designer.schema.tools.model.schema.QName;
import org.teiid.designer.schema.tools.processing.SchemaUtil;

public class XmlSchemaAsRelationalModelProcessor
extends RelationalModelProcessorImpl {
    BaseXMLRelationalExtensionManager extensions = XsdAsRelationalImportWizard.extManager;

    public XmlSchemaAsRelationalModelProcessor() {
    }

    public XmlSchemaAsRelationalModelProcessor(RelationalFactory factory) {
        super(factory);
    }

    public XmlSchemaAsRelationalModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
    }

    protected void setNameAndNameInSource(RelationalEntity entity, String name, JdbcNode node, Context context, List problems) {
        super.setNameAndNameInSource(entity, name, node, context, problems);
        this.processNewEntity(entity, name, node, context);
    }

    protected void processNewEntity(RelationalEntity entity, String name, JdbcNode node, Context context) {
        if (entity instanceof Catalog) {
            Catalog catalog = (Catalog)entity;
            this.processNewCatalog(name, node, context, catalog);
        } else if (entity instanceof Table) {
            Table table = (Table)entity;
            this.processNewTable(name, node, context, table);
        }
    }

    protected void processNewTable(String name, JdbcNode node, Context context, Table table) {
        JdbcTable tableNode = (JdbcTable)node;
        ModelAnnotation modelAnnotation = context.getModelContents().getModelAnnotation();
        ModelType oldtype = modelAnnotation.getModelType();
        Catalog oldCatalog = table.getCatalog();
        modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
        context.getResource().getContents().add((Object)table);
        try {
            this.setTableNamespacePrefixes(table, tableNode, name, context);
            this.addResponseField(table, tableNode, name, context);
            this.processRequestAttributes(table, tableNode, name, context);
        }
        finally {
            context.getResource().getContents().remove((Object)table);
            if (oldCatalog != null) {
                table.setCatalog(oldCatalog);
            }
            modelAnnotation.setModelType(oldtype);
        }
    }

    protected void processNewCatalog(String name, JdbcNode node, Context context, Catalog catalog) {
        this.setCatalogNamespacePrefixes(catalog, node, name, context);
    }

    protected String computeNameInSource(RelationalEntity object, String name, JdbcNode node, Context context, boolean forced, List problems) {
        String retval = object instanceof Table ? this.getTableNameInSource(object, name, node, context) : (object instanceof Column ? this.getColumnNameInSource(object, name, node, context) : (object instanceof PrimaryKey ? this.getPrimaryKeyNameInSource(object, name, node, context) : (object instanceof ForeignKey ? this.getForeignKeyNameInSource(object, name, node, context) : super.computeNameInSource(object, name, node, context, forced, problems))));
        return retval;
    }

    protected String getTableNameInSource(RelationalEntity object, String name, JdbcNode node, Context context) {
        DatabaseMetaDataImpl databaseMetaData = this.getMetaDataImpl(context);
        QName qname = this.getTableQName(node);
        String nameInSource = databaseMetaData.getTableNameInSource(name, qname.getNamespace());
        return nameInSource;
    }

    protected String getColumnNameInSource(RelationalEntity object, String name, JdbcNode node, Context context) {
        DatabaseMetaDataImpl databaseMetaData = this.getMetaDataImpl(context);
        QName qname = this.getTableQName(node);
        String nameInSource = databaseMetaData.getColumnNameInSource(name, qname.getNamespace(), qname.getLName());
        return nameInSource;
    }

    protected String getPrimaryKeyNameInSource(RelationalEntity object, String name, JdbcNode node, Context context) {
        DatabaseMetaDataImpl databaseMetaData = this.getMetaDataImpl(context);
        QName qname = this.getTableQName(node);
        String nameInSource = databaseMetaData.getPrimaryKeyNameInSource(name, qname.getNamespace());
        return nameInSource;
    }

    protected String getForeignKeyNameInSource(RelationalEntity object, String name, JdbcNode node, Context context) {
        DatabaseMetaDataImpl databaseMetaData = this.getMetaDataImpl(context);
        QName qname = this.getTableQName(node);
        String nameInSource = databaseMetaData.getForeignKeyNameInSource(name, qname.getNamespace());
        return nameInSource;
    }

    private QName getTableQName(JdbcNode node) {
        JdbcTable jdbcTable = (JdbcTable)node;
        String tableName = jdbcTable.getName();
        String tableNamespace = null;
        JdbcNode catalogNode = node;
        while (catalogNode != null && !(catalogNode instanceof JdbcCatalog)) {
            catalogNode = catalogNode.getParent();
        }
        if (catalogNode instanceof JdbcCatalog) {
            JdbcCatalog jdbcCatalog = (JdbcCatalog)catalogNode;
            tableNamespace = jdbcCatalog.getName();
        }
        QName qname = SchemaUtil.getQName(tableNamespace, (String)tableName);
        return qname;
    }

    private void setCatalogNamespacePrefixes(Catalog entity, JdbcNode node, String name, Context context) {
        ModelAnnotation modelAnnotation = context.getModelContents().getModelAnnotation();
        ModelType oldtype = modelAnnotation.getModelType();
        modelAnnotation.setModelType(ModelType.PHYSICAL_LITERAL);
        context.getResource().getContents().add((Object)entity);
        try {
            this.setNamespacePrefixesAttribute((RelationalEntity)entity, name, context);
        }
        finally {
            context.getResource().getContents().remove((Object)entity);
            modelAnnotation.setModelType(oldtype);
        }
    }

    private void addResponseField(Table entity, JdbcTable node, String name, Context context) {
        QName qname = this.getTableQName((JdbcNode)node);
        DatabaseMetaDataImpl metaDataImpl = this.getMetaDataImpl(context);
        Boolean requestTriState = metaDataImpl.isRequestOrResponseTable(qname);
        if (requestTriState == null) {
            return;
        }
        boolean request = requestTriState;
        ArrayList problems = new ArrayList();
        Column column = this.getFactory().createColumn();
        column.setOwner((ColumnSet)entity);
        String colName = request ? "ResponseOut" : "ResponseIn";
        int arbitrarySize = 1000;
        this.setColumnInfo(column, node, context, problems, colName, 12, String.class.getName(), arbitrarySize, 0, 0, 1, "", 0);
        column.setSelectable(request);
        if (this.extensions instanceof XMLHTTPExtensionManager) {
            ((XMLHTTPExtensionManager)this.extensions).setColumnRoleAttribute(column, request ? XMLRequestResponseExtensionManagerImpl.RESPONSE_OUT_ROLE : XMLRequestResponseExtensionManagerImpl.RESPONSE_IN_ROLE);
            ((XMLHTTPExtensionManager)this.extensions).setColumnInputParamAttribute(column, request ? Boolean.FALSE : Boolean.TRUE);
        }
        if (!request) {
            AccessPattern accessPattern = this.getFactory().createAccessPattern();
            accessPattern.setName(colName);
            accessPattern.setTable(entity);
            accessPattern.getColumns().add((Object)column);
        }
    }

    private void processRequestAttributes(Table entity, JdbcTable node, String name, Context context) {
        QName qname = this.getTableQName((JdbcNode)node);
        DatabaseMetaDataImpl metaDataImpl = this.getMetaDataImpl(context);
        Boolean requestTriState = metaDataImpl.isRequestOrResponseTable(qname);
        if (requestTriState == null) {
            return;
        }
        boolean request = requestTriState;
        if (request) {
            this.setXpathRootForInputAttribute((RelationalEntity)entity);
        }
    }

    private void setXpathRootForInputAttribute(RelationalEntity entity) {
        String xrfi_attribute_value = null;
        xrfi_attribute_value = "/";
        ((XMLHTTPExtensionManager)this.extensions).setXPathRootForInputAttribute(entity, xrfi_attribute_value);
    }

    private void setTableNamespacePrefixes(Table entity, JdbcTable node, String name, Context context) {
        QName qname = this.getTableQName((JdbcNode)node);
        if (qname.getNamespace() != null && qname.getNamespace().equals(StateManager.globalNamespace)) {
            qname.setNamespace(null);
        }
        this.setNamespacePrefixesAttribute((RelationalEntity)entity, qname.getNamespace(), context);
    }

    private static String quoteString(String str) {
        if (str.indexOf(39) == -1) {
            return String.valueOf('\'') + str + '\'';
        }
        if (str.indexOf(34) == -1) {
            return String.valueOf('\"') + str + '\"';
        }
        StringBuffer retval = new StringBuffer();
        retval.append('\'');
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\'') {
                retval.append("&apos;");
            } else {
                retval.append(c);
            }
            ++i;
        }
        retval.append('\'');
        return retval.toString();
    }

    private void setNamespacePrefixesAttribute(RelationalEntity entity, String name, Context context) {
        DatabaseMetaDataImpl metaDataImpl = this.getMetaDataImpl(context);
        if (metaDataImpl != null) {
            Map prefixes = metaDataImpl.getNamespacePrefixes(name);
            StringBuffer namespacePrefixes = new StringBuffer();
            for (Object oNamespace : prefixes.keySet()) {
                if (oNamespace == null) continue;
                String namespace = (String)oNamespace;
                Object oPrefix = prefixes.get(oNamespace);
                String prefix = (String)oPrefix;
                if (namespacePrefixes.length() != 0) {
                    namespacePrefixes.append(' ');
                }
                namespacePrefixes.append("xmlns");
                if (prefix != null && !prefix.equals("")) {
                    namespacePrefixes.append(':');
                }
                if (prefix != null) {
                    namespacePrefixes.append(prefix);
                }
                namespacePrefixes.append('=');
                String quotedNamespace = XmlSchemaAsRelationalModelProcessor.quoteString(namespace);
                namespacePrefixes.append(quotedNamespace);
            }
            this.extensions.setNamespacePrefixesAttribute(entity, namespacePrefixes.toString());
        }
    }

    private DatabaseMetaDataImpl getMetaDataImpl(Context context) {
        DatabaseMetaData metaData;
        JdbcDatabase db = context.getJdbcDatabase();
        try {
            metaData = db.getDatabaseMetaData();
        }
        catch (JdbcException e) {
            context.getWarnings().add(e);
            metaData = null;
        }
        DatabaseMetaDataImpl metaDataImpl = metaData instanceof DatabaseMetaDataImpl ? (DatabaseMetaDataImpl)metaData : null;
        return metaDataImpl;
    }
}

