/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xsd.procedures;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.RelationalPackage;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.modelgenerator.xml.XmlImporterUiPlugin;
import org.teiid.designer.modelgenerator.xsd.procedures.ITraversalCtxFactory;
import org.teiid.designer.modelgenerator.xsd.procedures.TraversalContext;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.ElementImpl;
import org.teiid.designer.schema.tools.model.schema.impl.TypeDefinition;

public class ProcedureBuilder {
    RelationalFactory factory = RelationalPackage.eINSTANCE.getRelationalFactory();
    private Set<String> procedures = new HashSet<String>();
    private Schema operationSchema;
    private ITraversalCtxFactory traversalCtxFactory;
    private ModelResource modelResource;
    private List<TraversalContext> traversalContexts = new ArrayList<TraversalContext>();

    public ProcedureBuilder(Schema schema, ModelResource resource) {
        this.operationSchema = schema;
        this.modelResource = resource;
    }

    public boolean procedureExists(String name) {
        return this.procedures.contains(name);
    }

    public boolean addProcedure(String name) {
        return this.procedures.add(name);
    }

    public void build(List<XSDElementDeclaration> elements, ITraversalCtxFactory traversalCtxFactory) throws ModelerCoreException {
        CoreArgCheck.isTrue((elements.size() == 1 ? 1 : 0) != 0, (String)XmlImporterUiPlugin.getDefault().getPluginUtil().getString("ProcedureBuilder.wrongNumberElementsReturnedFromXsd", new Object[0]));
        XSDElementDeclaration element = elements.get(0);
        this.traversalCtxFactory = traversalCtxFactory;
        TraversalContext ctx = this.traversalCtxFactory.getTraversalContext(element.getName(), new QName(element.getTargetNamespace(), ""), this);
        this.traversalContexts.add(ctx);
        XSDTypeDefinition type = element.getType();
        String name = this.getName(type);
        if (!this.procedureExists(name)) {
            this.addProcedure(name);
            if (type instanceof XSDComplexTypeDefinition) {
                ctx.appendToPath(element.getName());
                XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
                this.addComplexTypeDefToProcedureResult(complexType, ctx);
            } else if (type instanceof XSDSimpleTypeDefinition) {
                XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)element.getType();
                this.addElementDeclarationToProcedureResult(element, simpleType, ctx);
            }
        }
    }

    public void build(SchemaObject sObject, ITraversalCtxFactory traversalCtxFactory) throws ModelerCoreException {
        this.traversalCtxFactory = traversalCtxFactory;
        TraversalContext ctx = this.traversalCtxFactory.getTraversalContext(sObject.getName(), new QName(sObject.getNamespace(), ""), this);
        this.traversalContexts.add(ctx);
        XSDTypeDefinition type = sObject.getType();
        String name = this.getName(type);
        if (!this.procedureExists(name)) {
            this.addProcedure(name);
            if (type instanceof XSDComplexTypeDefinition) {
                ctx.appendToPath(sObject.getName());
                XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)type;
                this.addComplexTypeDefToProcedureResult(complexType, ctx);
            } else if (type instanceof XSDSimpleTypeDefinition) {
                if (sObject instanceof TypeDefinition) {
                    XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)sObject.getType();
                    this.addSimpleTypeDefToProcedureResult(simpleType, ctx);
                } else {
                    XSDElementDeclaration element = ((ElementImpl)sObject).getElem();
                    XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)element.getType();
                    this.addElementDeclarationToProcedureResult(element, simpleType, ctx);
                }
            }
        }
    }

    public void build(XSDSimpleTypeDefinition simpleType, String name, ITraversalCtxFactory traversalCtxFactory) throws ModelerCoreException {
        this.traversalCtxFactory = traversalCtxFactory;
        TraversalContext ctx = this.traversalCtxFactory.getTraversalContext(name, new QName(simpleType.getTargetNamespace(), simpleType.getName()), this);
        this.traversalContexts.add(ctx);
        this.addSimpleTypeDefToProcedureResult(simpleType, name, ctx);
    }

    public void createTransformations() {
        for (TraversalContext context : this.traversalContexts) {
            context.createTransformation();
        }
    }

    private String getName(XSDTypeDefinition type) {
        String name = type.getName();
        if (name == null) {
            name = type.getAliasName();
        }
        return name;
    }

    private void addElementDeclarationToProcedureResult(XSDElementDeclaration element, XSDSimpleTypeDefinition type, TraversalContext ctx) throws ModelerCoreException {
        String name = element.getName();
        if (name == null) {
            name = element.getAliasName();
        }
        ctx.addColumn(name, (XSDTypeDefinition)type);
    }

    private void addComplexTypeDefToProcedureResult(XSDComplexTypeDefinition complexType, TraversalContext ctx) throws ModelerCoreException {
        XSDComplexTypeContent content = complexType.getContent();
        if (content instanceof XSDSimpleTypeDefinition) {
            XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)content;
            this.addSimpleTypeDefToProcedureResult(simpleType, ctx);
        } else if (content instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)content;
            this.addXSDParticleToProcedureResult(particle, ctx);
        }
    }

    private void addXSDParticleToProcedureResult(XSDParticle particle, TraversalContext ctx) throws ModelerCoreException {
        block9: {
            XSDParticleContent content;
            block11: {
                block10: {
                    content = particle.getContent();
                    if (content instanceof XSDWildcard) break block9;
                    if (!(content instanceof XSDModelGroup)) break block10;
                    XSDModelGroup group = (XSDModelGroup)content;
                    EList contents = group.getContents();
                    for (XSDParticle xsdParticle : contents) {
                        this.addXSDParticleToProcedureResult(xsdParticle, ctx);
                    }
                    break block9;
                }
                if (!(content instanceof XSDElementDeclaration)) break block11;
                XSDElementDeclaration element = (XSDElementDeclaration)content;
                if (element.isElementDeclarationReference()) {
                    element = element.getResolvedElementDeclaration();
                }
                if (element.getType() instanceof XSDSimpleTypeDefinition) {
                    XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)element.getType();
                    this.addElementDeclarationToProcedureResult(element, type, ctx);
                } else {
                    XSDComplexTypeDefinition type = (XSDComplexTypeDefinition)element.getType();
                    String name = element.getName();
                    if (name == null) {
                        name = element.getAliasName();
                    }
                    if (this.procedureExists(name)) {
                        return;
                    }
                    ctx.appendToPath(name);
                    if (particle.getMaxOccurs() > 1 || particle.getMaxOccurs() == -1 || ctx.isReachedResultNode()) {
                        ctx = this.traversalCtxFactory.getTraversalContext(name, new QName(element.getTargetNamespace(), ""), ctx, this);
                        this.traversalContexts.add(ctx);
                        if (this.procedureExists(this.getName((XSDTypeDefinition)type))) {
                            return;
                        }
                    }
                    this.addComplexTypeDefToProcedureResult(type, ctx);
                }
                break block9;
            }
            if (!(content instanceof XSDModelGroupDefinition)) break block9;
            XSDModelGroupDefinition groupDefinition = (XSDModelGroupDefinition)content;
            XSDModelGroup group = groupDefinition.getModelGroup();
            EList contents = group.getContents();
            for (XSDParticle xsdParticle : contents) {
                this.addXSDParticleToProcedureResult(xsdParticle, ctx);
            }
        }
    }

    private void addSimpleTypeDefToProcedureResult(XSDSimpleTypeDefinition simpleType, TraversalContext ctx) throws ModelerCoreException {
        String name = simpleType.getName();
        if (name == null) {
            name = simpleType.getAliasName();
        }
        ctx.addColumn(name, (XSDTypeDefinition)simpleType);
        ctx.setReachedResultNode(true);
    }

    private void addSimpleTypeDefToProcedureResult(XSDSimpleTypeDefinition simpleType, String name, TraversalContext ctx) throws ModelerCoreException {
        ctx.addColumn(name, (XSDTypeDefinition)simpleType);
        ctx.setReachedResultNode(true);
    }

    public Schema getSchema() {
        return this.operationSchema;
    }

    public ModelResource getModelResource() {
        return this.modelResource;
    }
}

