/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.xsd.procedures;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.modelgenerator.xsd.procedures.BaseTraversalContext;
import org.teiid.designer.modelgenerator.xsd.procedures.IBuilderConstants;
import org.teiid.designer.modelgenerator.xsd.procedures.ProcedureBuilder;
import org.teiid.designer.modelgenerator.xsd.procedures.TraversalContext;
import org.teiid.designer.schema.tools.NameUtil;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationMappingHelper;

public class RequestBuilderTraversalContext
extends BaseTraversalContext
implements TraversalContext {
    public static final String REQUEST = "request_";
    public static final String XML_OUT = "xml_out";
    private Procedure procedure;
    private List<ProcedureParameter> cachedParams = new ArrayList<ProcedureParameter>();
    private ProcedureResult procedureResult;

    public RequestBuilderTraversalContext(String procedureName, QName namespace, TraversalContext ctx, ProcedureBuilder builder) {
        super(procedureName, namespace, ctx, builder);
    }

    public RequestBuilderTraversalContext(String procedureName, QName namespace, ProcedureBuilder builder) {
        super(procedureName, namespace, builder);
    }

    @Override
    public void addColumn(String name, XSDTypeDefinition type) throws ModelerCoreException {
        if (this.procedure == null) {
            this.procedure = this.createProcedure(this.procedureName);
        }
        ProcedureParameter param = this.factory.createProcedureParameter();
        this.procedure.getParameters().add((Object)param);
        param.setDirection(DirectionKind.IN_LITERAL);
        String uniqueName = this.getUniqueName((EObject)param, NameUtil.normalizeName((String)name));
        param.setName(uniqueName);
        param.setNameInSource(uniqueName);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        param.setType(this.datatypeManager.getDatatypeForXsdType((EObject)type));
        this.setReachedResultNode(true);
        this.cachedParams.add(param);
    }

    Procedure createProcedure(String procedureNameBase) throws ModelWorkspaceException, ModelerCoreException {
        Procedure procedure = this.factory.createProcedure();
        this.builder.getSchema().getProcedures().add((Object)procedure);
        String uniqueName = this.getUniqueName((EObject)procedure, REQUEST + NameUtil.normalizeName((String)procedureNameBase));
        procedure.setName(uniqueName);
        procedure.setNameInSource(procedureNameBase);
        this.builder.addProcedure(procedureNameBase);
        this.procedureResult = this.factory.createProcedureResult();
        procedure.setResult(this.procedureResult);
        this.procedureResult.setName(String.valueOf(NameUtil.normalizeName((String)procedureNameBase)) + IBuilderConstants.V_FUNC_RESULT);
        this.procedureResult.setNameInSource(procedureNameBase);
        Column resultCol = this.factory.createColumn();
        this.procedureResult.getColumns().add((Object)resultCol);
        resultCol.setName(XML_OUT);
        resultCol.setType(this.datatypeManager.getBuiltInDatatype("XMLLiteral"));
        return procedure;
    }

    @Override
    public void createTransformation() {
        if (this.procedure != null) {
            StringBuffer sqlString = new StringBuffer();
            sqlString.append(IBuilderConstants.V_FUNC_PREAMBLE);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_SELECT);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_XML_ELEMENT);
            sqlString.append(IBuilderConstants.V_FUNC_OPEN);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_NAME);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_DOUBLE_QUOTE);
            sqlString.append(this.procedureResult.getNameInSource());
            sqlString.append(IBuilderConstants.V_FUNC_DOUBLE_QUOTE);
            sqlString.append(IBuilderConstants.V_FUNC_COMMA);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            if (this.getNamespace() != null || !this.getNamespace().getNamespaceURI().isEmpty()) {
                sqlString.append(IBuilderConstants.V_FUNC_XMLNAMESPACES);
                sqlString.append(IBuilderConstants.V_FUNC_OPEN);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(IBuilderConstants.V_FUNC_DEFAULT);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(IBuilderConstants.V_FUNC_QUOTE);
                sqlString.append(this.getNamespace().getNamespaceURI());
                sqlString.append(IBuilderConstants.V_FUNC_QUOTE);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(IBuilderConstants.V_FUNC_CLOSE);
                sqlString.append(IBuilderConstants.V_FUNC_COMMA);
            }
            boolean firstTime = true;
            for (ProcedureParameter param : this.cachedParams) {
                if (!firstTime) {
                    sqlString.append(IBuilderConstants.V_FUNC_COMMA);
                    sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                }
                sqlString.append(IBuilderConstants.V_FUNC_XML_ELEMENT);
                sqlString.append(IBuilderConstants.V_FUNC_OPEN);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(IBuilderConstants.V_FUNC_NAME);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(IBuilderConstants.V_FUNC_DOUBLE_QUOTE);
                sqlString.append(param.getNameInSource());
                sqlString.append(IBuilderConstants.V_FUNC_DOUBLE_QUOTE);
                sqlString.append(IBuilderConstants.V_FUNC_COMMA);
                sqlString.append(IBuilderConstants.V_FUNC_SPACE);
                sqlString.append(param.getName());
                sqlString.append(IBuilderConstants.V_FUNC_CLOSE);
                firstTime = false;
            }
            sqlString.append(IBuilderConstants.V_FUNC_CLOSE);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_AS_XML_OUT);
            sqlString.append(IBuilderConstants.V_FUNC_SPACE);
            sqlString.append(IBuilderConstants.V_FUNC_POSTSCRIPT);
            SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)this.procedure);
            TransformationHelper.setSqlString((Object)root, (String)sqlString.toString(), (int)0, (boolean)true, (Object)this);
            TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)root, (Object)this);
        }
    }

    private String getUniqueName(EObject eObject, String proposedName) {
        CoreArgCheck.isNotNull((Object)eObject);
        EStructuralFeature nameFeature = ModelerCore.getModelEditor().getNameFeature(eObject);
        if (nameFeature != null) {
            return this.generateUniqueInternalName(eObject.eContainer() == null ? eObject.eResource().getContents() : eObject.eContainer().eContents(), eObject, nameFeature, proposedName);
        }
        return proposedName;
    }

    private String generateUniqueInternalName(EList siblings, EObject eObject, EStructuralFeature nameFeature, String name) {
        String newName = name;
        if (siblings != null) {
            HashSet<Object> siblingNames = new HashSet<Object>();
            for (EObject child : siblings) {
                if (!eObject.getClass().equals(child.getClass())) continue;
                siblingNames.add(child.eGet(nameFeature));
            }
            boolean foundUniqueName = false;
            int index = 1;
            while (!foundUniqueName) {
                if (siblingNames.contains(newName)) {
                    newName = String.valueOf(name) + String.valueOf(index++);
                    continue;
                }
                foundUniqueName = true;
            }
        }
        return newName;
    }
}

