/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.di;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNLabel;
import org.eclipse.bpmn2.di.BPMNLabelStyle;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.Font;
import org.eclipse.dd.dc.Point;
import org.eclipse.dd.di.DiagramElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.ILayoutService;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class DIUtils {
    public static BPMNShape createDIShape(Shape shape, BaseElement elem, BPMNShape bpmnShape, IFeatureProvider fp) {
        if (bpmnShape == null) {
            Diagram diagram = Graphiti.getPeService().getDiagramForShape(shape);
            ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram(shape);
            int x = loc.getX();
            int y = loc.getY();
            int w = shape.getGraphicsAlgorithm().getWidth();
            int h = shape.getGraphicsAlgorithm().getHeight();
            bpmnShape = DIUtils.createDIShape(shape, elem, x, y, w, h, fp, diagram);
        } else {
            fp.link((PictogramElement)shape, new Object[]{elem, bpmnShape});
        }
        return bpmnShape;
    }

    public static BPMNShape createDIShape(Shape shape, BaseElement elem, int x, int y, int w, int h, IFeatureProvider fp, Diagram diagram) {
        EList businessObjects = Graphiti.getLinkService().getLinkForPictogramElement((PictogramElement)diagram).getBusinessObjects();
        BPMNShape bpmnShape = null;
        for (EObject eObject : businessObjects) {
            if (!(eObject instanceof BPMNDiagram)) continue;
            BPMNDiagram bpmnDiagram = (BPMNDiagram)eObject;
            bpmnShape = BpmnDiFactory.eINSTANCE.createBPMNShape();
            bpmnShape.setBpmnElement(elem);
            Bounds bounds = DcFactory.eINSTANCE.createBounds();
            bounds.setX((float)x);
            bounds.setY((float)y);
            bounds.setWidth((float)w);
            bounds.setHeight((float)h);
            bpmnShape.setBounds(bounds);
            DIUtils.getOrCreateDILabel((DiagramElement)bpmnShape);
            DIUtils.addDIElement((DiagramElement)bpmnShape, bpmnDiagram);
            ModelUtil.setID((EObject)bpmnShape);
            fp.link((PictogramElement)shape, new Object[]{elem, bpmnShape});
            break;
        }
        return bpmnShape;
    }

    public static void updateDIShape(PictogramElement element) {
        BPMNShape bpmnShape = BusinessObjectUtil.getFirstElementOfType(element, BPMNShape.class);
        if (bpmnShape == null) {
            return;
        }
        ILocation loc = Graphiti.getLayoutService().getLocationRelativeToDiagram((Shape)element);
        Bounds bounds = bpmnShape.getBounds();
        bounds.setX((float)loc.getX());
        bounds.setY((float)loc.getY());
        GraphicsAlgorithm graphicsAlgorithm = element.getGraphicsAlgorithm();
        IDimension size = Graphiti.getGaService().calculateSize(graphicsAlgorithm);
        bounds.setHeight((float)size.getHeight());
        bounds.setWidth((float)size.getWidth());
        if (element instanceof ContainerShape) {
            EList children = ((ContainerShape)element).getChildren();
            for (Shape shape : children) {
                if (!(shape instanceof ContainerShape)) continue;
                DIUtils.updateDIShape((PictogramElement)shape);
            }
        }
        DIUtils.updateConnections(element);
    }

    private static void updateConnections(PictogramElement element) {
        if (element instanceof Shape) {
            EList anchors = ((Shape)element).getAnchors();
            for (Anchor anchor : anchors) {
                List connections = Graphiti.getPeService().getAllConnections(anchor);
                for (Connection connection : connections) {
                    DIUtils.updateDIEdge(connection);
                }
                connections.size();
            }
            anchors.size();
        }
    }

    public static BPMNEdge createDIEdge(Connection connection, BaseElement elem, BPMNEdge bpmnEdge, IFeatureProvider fp) {
        if (bpmnEdge == null) {
            Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement((PictogramElement)connection);
            EList businessObjects = Graphiti.getLinkService().getLinkForPictogramElement((PictogramElement)diagram).getBusinessObjects();
            for (EObject eObject : businessObjects) {
                if (!(eObject instanceof BPMNDiagram)) continue;
                BPMNDiagram bpmnDiagram = (BPMNDiagram)eObject;
                bpmnEdge = BpmnDiFactory.eINSTANCE.createBPMNEdge();
                bpmnEdge.setBpmnElement(elem);
                if (elem instanceof Association) {
                    bpmnEdge.setSourceElement(DIUtils.findDiagramElement((EObject)((Association)elem).getSourceRef()));
                    bpmnEdge.setTargetElement(DIUtils.findDiagramElement((EObject)((Association)elem).getTargetRef()));
                } else if (elem instanceof MessageFlow) {
                    bpmnEdge.setSourceElement(DIUtils.findDiagramElement((EObject)((BaseElement)((MessageFlow)elem).getSourceRef())));
                    bpmnEdge.setTargetElement(DIUtils.findDiagramElement((EObject)((BaseElement)((MessageFlow)elem).getTargetRef())));
                } else if (elem instanceof SequenceFlow) {
                    bpmnEdge.setSourceElement(DIUtils.findDiagramElement((EObject)((SequenceFlow)elem).getSourceRef()));
                    bpmnEdge.setTargetElement(DIUtils.findDiagramElement((EObject)((SequenceFlow)elem).getTargetRef()));
                }
                ILocation sourceLoc = Graphiti.getPeService().getLocationRelativeToDiagram(connection.getStart());
                ILocation targetLoc = Graphiti.getPeService().getLocationRelativeToDiagram(connection.getEnd());
                Point point = DcFactory.eINSTANCE.createPoint();
                point.setX((float)sourceLoc.getX());
                point.setY((float)sourceLoc.getY());
                bpmnEdge.getWaypoint().add(point);
                point = DcFactory.eINSTANCE.createPoint();
                point.setX((float)targetLoc.getX());
                point.setY((float)targetLoc.getY());
                bpmnEdge.getWaypoint().add(point);
                DIUtils.getOrCreateDILabel((DiagramElement)bpmnEdge);
                DIUtils.addDIElement((DiagramElement)bpmnEdge, bpmnDiagram);
                ModelUtil.setID((EObject)bpmnEdge);
            }
        }
        fp.link((PictogramElement)connection, new Object[]{elem, bpmnEdge});
        return bpmnEdge;
    }

    public static void updateDIEdge(Connection connection) {
        ILayoutService layoutService = Graphiti.getLayoutService();
        BaseElement be = BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BaseElement.class);
        BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)connection);
        BPMNEdge edge = DIUtils.findBPMNEdge(bpmnDiagram, (EObject)be);
        if (edge != null) {
            Point point = DcFactory.eINSTANCE.createPoint();
            List waypoint = edge.getWaypoint();
            waypoint.clear();
            ILocation loc = layoutService.getLocationRelativeToDiagram(connection.getStart());
            point.setX((float)loc.getX());
            point.setY((float)loc.getY());
            waypoint.add(point);
            if (connection instanceof FreeFormConnection) {
                FreeFormConnection freeForm = (FreeFormConnection)connection;
                EList bendpoints = freeForm.getBendpoints();
                for (org.eclipse.graphiti.mm.algorithms.styles.Point bp : bendpoints) {
                    point = DcFactory.eINSTANCE.createPoint();
                    point.setX((float)bp.getX());
                    point.setY((float)bp.getY());
                    waypoint.add(point);
                }
            }
            point = DcFactory.eINSTANCE.createPoint();
            loc = layoutService.getLocationRelativeToDiagram(connection.getEnd());
            point.setX((float)loc.getX());
            point.setY((float)loc.getY());
            waypoint.add(point);
        }
    }

    public static void addDIElement(DiagramElement elem, BPMNDiagram bpmnDiagram) {
        List elements = bpmnDiagram.getPlane().getPlaneElement();
        elements.add(elem);
    }

    public static BPMNLabel getOrCreateDILabel(DiagramElement de) {
        BPMNLabel bpmnLabel = null;
        EStructuralFeature feature = de.eClass().getEStructuralFeature("label");
        if (feature != null && (bpmnLabel = (BPMNLabel)de.eGet(feature)) == null) {
            bpmnLabel = BpmnDiFactory.eINSTANCE.createBPMNLabel();
            de.eSet(feature, (Object)bpmnLabel);
        }
        return bpmnLabel;
    }

    public static void updateDILabel(PictogramElement pe, int x, int y, int w, int h) {
        DiagramElement de = (DiagramElement)BusinessObjectUtil.getFirstElementOfType(pe, BPMNShape.class);
        if (de == null) {
            de = (DiagramElement)BusinessObjectUtil.getFirstElementOfType(pe, BPMNEdge.class);
        }
        if (de != null) {
            BPMNLabel bpmnLabel = DIUtils.getOrCreateDILabel(de);
            if (w == 0 && h == 0) {
                bpmnLabel.setBounds(null);
            } else {
                Bounds bounds = bpmnLabel.getBounds();
                if (bounds == null) {
                    bounds = DcFactory.eINSTANCE.createBounds();
                }
                bounds.setX((float)x);
                bounds.setY((float)y);
                bounds.setWidth((float)w);
                bounds.setHeight((float)h);
                bpmnLabel.setBounds(bounds);
            }
        }
    }

    public static BPMNLabelStyle getDILabelStyle(BaseElement element) {
        BPMNEdge bpmnEdge;
        BPMNLabelStyle bpmnStyle = null;
        DiagramElement de = DIUtils.findDiagramElement((EObject)element);
        if (de instanceof BPMNShape) {
            BPMNShape bpmnShape = (BPMNShape)de;
            if (bpmnShape.getLabel() != null) {
                bpmnStyle = bpmnShape.getLabel().getLabelStyle();
            }
        } else if (de instanceof BPMNEdge && (bpmnEdge = (BPMNEdge)de).getLabel() != null) {
            bpmnStyle = bpmnEdge.getLabel().getLabelStyle();
        }
        return bpmnStyle;
    }

    public static BPMNLabelStyle getOrCreateDILabelStyle(BaseElement element, ShapeStyle ss) {
        BPMNLabel bpmnLabel;
        BPMNLabelStyle bpmnStyle = null;
        DiagramElement de = DIUtils.findDiagramElement((EObject)element);
        if (de != null && (bpmnLabel = DIUtils.getOrCreateDILabel(de)) != null) {
            BPMNDiagram bpmnDiagram = (BPMNDiagram)de.eContainer().eContainer();
            for (BPMNLabelStyle ls : bpmnDiagram.getLabelStyle()) {
                if (!ss.equals(ls)) continue;
                bpmnStyle = ls;
            }
            if (bpmnStyle == null) {
                bpmnStyle = BpmnDiFactory.eINSTANCE.createBPMNLabelStyle();
                bpmnStyle.setFont(ShapeStyle.toBPMNFont(ss.getLabelFont()));
                bpmnDiagram.getLabelStyle().add(bpmnStyle);
            }
            bpmnLabel.setLabelStyle(bpmnStyle);
        }
        return bpmnStyle;
    }

    private static boolean compareDILabelStyle(BPMNLabelStyle ls1, BPMNLabelStyle ls2) {
        if (ls1 == null) {
            return ls2 == null;
        }
        if (ls2 == null) {
            return false;
        }
        Font f1 = ls1.getFont();
        Font f2 = ls2.getFont();
        if (f1 == null) {
            return f2 == null;
        }
        if (f2 == null) {
            return false;
        }
        return f1.getName().equals(f1.getName()) && f1.getSize() == f2.getSize() && f1.isIsBold() == f2.isIsBold() && f1.isIsItalic() == f2.isIsItalic() && f1.isIsStrikeThrough() == f2.isIsStrikeThrough() && f1.isIsUnderline() == f2.isIsUnderline();
    }

    public static DiagramElement findDiagramElement(List<BPMNDiagram> diagrams, BaseElement bpmnElement) {
        Iterator<BPMNDiagram> iterator = diagrams.iterator();
        if (iterator.hasNext()) {
            BPMNDiagram d = iterator.next();
            BPMNPlane plane = d.getPlane();
            List planeElements = plane.getPlaneElement();
            return DIUtils.findPlaneElement(planeElements, bpmnElement);
        }
        return null;
    }

    public static DiagramElement findPlaneElement(List<DiagramElement> planeElements, BaseElement bpmnElement) {
        for (DiagramElement de : planeElements) {
            if (de instanceof BPMNShape && bpmnElement == ((BPMNShape)de).getBpmnElement()) {
                return de;
            }
            if (de instanceof BPMNEdge) {
                if (bpmnElement != ((BPMNEdge)de).getBpmnElement()) continue;
                return de;
            }
            if (!(de instanceof BPMNPlane)) continue;
            return DIUtils.findPlaneElement(((BPMNPlane)de).getPlaneElement(), bpmnElement);
        }
        return null;
    }

    public static Diagram getOrCreateDiagram(IDiagramBehavior editor, final BPMNDiagram bpmnDiagram) {
        Diagram diagram = DIUtils.findDiagram(editor, bpmnDiagram);
        if (diagram != null) {
            return diagram;
        }
        IDiagramTypeProvider dtp = editor.getDiagramContainer().getDiagramTypeProvider();
        final Resource resource = dtp.getDiagram().eResource() != null ? dtp.getDiagram().eResource() : (Resource)editor.getEditingDomain().getResourceSet().getResources().get(0);
        final Diagram newDiagram = DIUtils.createDiagram(bpmnDiagram.getName());
        final IFeatureProvider featureProvider = dtp.getFeatureProvider();
        TransactionalEditingDomain domain = editor.getEditingDomain();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                resource.getContents().add((Object)newDiagram);
                newDiagram.setActive(true);
                featureProvider.link((PictogramElement)newDiagram, (Object)bpmnDiagram);
            }
        });
        return newDiagram;
    }

    public static Diagram createDiagram(String diagramName) {
        Diagram diagram = Graphiti.getPeCreateService().createDiagram("BPMN2", diagramName, true);
        Bpmn2Preferences prefs = Bpmn2Preferences.getInstance();
        ShapeStyle ss = prefs.getShapeStyle(ShapeStyle.Category.GRID);
        diagram.setGridUnit(ss.getDefaultWidth());
        diagram.setVerticalGridUnit(ss.getDefaultHeight());
        diagram.setSnapToGrid(ss.getSnapToGrid());
        GraphicsAlgorithm ga = diagram.getGraphicsAlgorithm();
        IGaService gaService = Graphiti.getGaService();
        ga.setForeground(gaService.manageColor(diagram, ss.getShapeForeground()));
        ss = prefs.getShapeStyle(ShapeStyle.Category.CANVAS);
        ga.setBackground(gaService.manageColor(diagram, ss.getShapeBackground()));
        return diagram;
    }

    public static Diagram findDiagram(IDiagramBehavior editor, BPMNDiagram bpmnDiagram) {
        ResourceSet resourceSet = editor.getEditingDomain().getResourceSet();
        if (resourceSet != null) {
            return DIUtils.findDiagram(resourceSet, bpmnDiagram);
        }
        return null;
    }

    public static Diagram findDiagram(ResourceSet resourceSet, BPMNDiagram bpmnDiagram) {
        if (resourceSet != null) {
            for (Resource r : resourceSet.getResources()) {
                for (EObject o : r.getContents()) {
                    Diagram diagram;
                    if (!(o instanceof Diagram) || BusinessObjectUtil.getFirstElementOfType((PictogramElement)(diagram = (Diagram)o), BPMNDiagram.class) != bpmnDiagram) continue;
                    return diagram;
                }
            }
        }
        return null;
    }

    public static void deleteDiagram(IDiagramBehavior editor, BPMNDiagram bpmnDiagram) {
        Diagram diagram = DIUtils.findDiagram(editor, bpmnDiagram);
        if (diagram != null) {
            ArrayList<EObject> list = new ArrayList<EObject>();
            TreeIterator iter = diagram.eAllContents();
            while (iter.hasNext()) {
                EObject o = (EObject)iter.next();
                if (o instanceof PictogramLink) {
                    ((PictogramLink)o).getBusinessObjects().clear();
                    if (list.contains(o)) continue;
                    list.add(o);
                    continue;
                }
                if (o instanceof Color) {
                    if (list.contains(o)) continue;
                    list.add(o);
                    continue;
                }
                if (o instanceof org.eclipse.graphiti.mm.algorithms.styles.Font) {
                    if (list.contains(o)) continue;
                    list.add(o);
                    continue;
                }
                if (!(o instanceof Style) || list.contains(o)) continue;
                list.add(o);
            }
            for (EObject o : list) {
                EcoreUtil.delete((EObject)o);
            }
            EcoreUtil.delete((EObject)diagram);
            EcoreUtil.delete((EObject)bpmnDiagram);
        }
    }

    public static BPMNDiagram findBPMNDiagram(PictogramElement pe) {
        Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement(pe);
        BPMNDiagram bpmnDiagram = BusinessObjectUtil.getFirstElementOfType((PictogramElement)diagram, BPMNDiagram.class);
        return bpmnDiagram;
    }

    public static BPMNDiagram findBPMNDiagram(BaseElement baseElement) {
        return DIUtils.findBPMNDiagram(baseElement, false);
    }

    public static boolean isBPMNDiagramChild(BPMNDiagram bpmnDiagram, BaseElement baseElement) {
        for (DiagramElement de : bpmnDiagram.getPlane().getPlaneElement()) {
            BaseElement bpmnElement;
            if (de instanceof BPMNShape) {
                bpmnElement = ((BPMNShape)de).getBpmnElement();
            } else {
                if (!(de instanceof BPMNEdge)) continue;
                bpmnElement = ((BPMNEdge)de).getBpmnElement();
            }
            if (bpmnElement != baseElement) continue;
            return true;
        }
        return false;
    }

    public static List<BPMNDiagram> getBPMNDiagrams(EObject object, int type) {
        ArrayList<BPMNDiagram> result = new ArrayList<BPMNDiagram>();
        if (object == null || object.eResource() == null) {
            return result;
        }
        ResourceSet resourceSet = object.eResource().getResourceSet();
        if (resourceSet == null) {
            return result;
        }
        for (Resource r : resourceSet.getResources()) {
            if (!(r instanceof Bpmn2Resource)) continue;
            for (EObject o : r.getContents()) {
                if (!(o instanceof DocumentRoot)) continue;
                DocumentRoot root = (DocumentRoot)o;
                Definitions defs = root.getDefinitions();
                Iterator iterator = defs.getDiagrams().iterator();
                while (iterator.hasNext()) {
                    BPMNDiagram d;
                    BPMNDiagram bpmnDiagram = d = (BPMNDiagram)iterator.next();
                    BaseElement bpmnElement = bpmnDiagram.getPlane().getBpmnElement();
                    if (type == 0) {
                        result.add(bpmnDiagram);
                    }
                    if ((type & 1) != 0 && !(bpmnElement instanceof SubProcess)) {
                        result.add(bpmnDiagram);
                    }
                    if ((type & 2) == 0 || !(bpmnElement instanceof SubProcess)) continue;
                    result.add(bpmnDiagram);
                }
            }
        }
        return result;
    }

    public static boolean isSubDiagram(Diagram diagram) {
        BPMNDiagram bpmnDiagram = BusinessObjectUtil.getFirstElementOfType((PictogramElement)diagram, BPMNDiagram.class);
        if (bpmnDiagram != null) {
            BaseElement bpmnElement = bpmnDiagram.getPlane().getBpmnElement();
            return bpmnElement instanceof SubProcess;
        }
        return false;
    }

    public static BPMNDiagram findBPMNDiagram(BaseElement baseElement, boolean contains) {
        if (baseElement == null || baseElement.eResource() == null) {
            return null;
        }
        ResourceSet resourceSet = baseElement.eResource().getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        for (Resource r : resourceSet.getResources()) {
            if (!(r instanceof Bpmn2Resource)) continue;
            for (EObject o : r.getContents()) {
                BPMNDiagram bpmnDiagram;
                BaseElement bpmnElement;
                BPMNDiagram bpmnDiagram2;
                if (!(o instanceof DocumentRoot)) continue;
                DocumentRoot root = (DocumentRoot)o;
                Definitions defs = root.getDefinitions();
                for (BPMNDiagram d : defs.getDiagrams()) {
                    bpmnDiagram2 = d;
                    bpmnElement = bpmnDiagram2.getPlane().getBpmnElement();
                    if (bpmnElement != baseElement) continue;
                    return bpmnDiagram2;
                }
                if (!contains) continue;
                Iterator iterator = defs.getDiagrams().iterator();
                while (iterator.hasNext()) {
                    BPMNDiagram d;
                    bpmnDiagram2 = d = (BPMNDiagram)iterator.next();
                    for (DiagramElement de : bpmnDiagram2.getPlane().getPlaneElement()) {
                        if (de instanceof BPMNShape) {
                            bpmnElement = ((BPMNShape)de).getBpmnElement();
                        } else {
                            if (!(de instanceof BPMNEdge)) continue;
                            bpmnElement = ((BPMNEdge)de).getBpmnElement();
                        }
                        if (bpmnElement != baseElement) continue;
                        return bpmnDiagram2;
                    }
                }
                EObject parent = baseElement.eContainer();
                if (!(parent instanceof BaseElement) || parent instanceof Definitions || (bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)parent, true)) == null) continue;
                return bpmnDiagram;
            }
        }
        return null;
    }

    public static BPMNDiagram createBPMNDiagram(Definitions definitions, BaseElement container) {
        Resource resource = definitions.eResource();
        BPMNDiagram bpmnDiagram = BpmnDiFactory.eINSTANCE.createBPMNDiagram();
        ModelUtil.setID((EObject)bpmnDiagram, resource);
        bpmnDiagram.setName(ExtendedPropertiesProvider.getTextValue((EObject)container));
        BPMNPlane plane = BpmnDiFactory.eINSTANCE.createBPMNPlane();
        ModelUtil.setID((EObject)plane, resource);
        plane.setBpmnElement(container);
        bpmnDiagram.setPlane(plane);
        definitions.getDiagrams().add(bpmnDiagram);
        return bpmnDiagram;
    }

    public static BPMNShape findBPMNShape(BaseElement baseElement) {
        Definitions definitions = ModelUtil.getDefinitions(baseElement);
        if (definitions != null) {
            for (BPMNDiagram d : definitions.getDiagrams()) {
                BPMNShape bpmnShape = DIUtils.findBPMNShape(d, baseElement);
                if (bpmnShape == null) continue;
                return bpmnShape;
            }
        }
        return null;
    }

    public static BPMNShape findBPMNShape(BPMNDiagram bpmnDiagram, BaseElement baseElement) {
        for (DiagramElement de : bpmnDiagram.getPlane().getPlaneElement()) {
            if (!(de instanceof BPMNShape) || ((BPMNShape)de).getBpmnElement() != baseElement) continue;
            return (BPMNShape)de;
        }
        return null;
    }

    public static BPMNEdge findBPMNEdge(EObject baseElement) {
        Definitions definitions = ModelUtil.getDefinitions(baseElement);
        if (definitions != null) {
            for (BPMNDiagram d : definitions.getDiagrams()) {
                BPMNEdge bpmnEdge = DIUtils.findBPMNEdge(d, baseElement);
                if (bpmnEdge == null) continue;
                return bpmnEdge;
            }
        }
        return null;
    }

    public static BPMNEdge findBPMNEdge(BPMNDiagram bpmnDiagram, EObject baseElement) {
        for (DiagramElement de : bpmnDiagram.getPlane().getPlaneElement()) {
            if (!(de instanceof BPMNEdge) || ((BPMNEdge)de).getBpmnElement() != baseElement) continue;
            return (BPMNEdge)de;
        }
        return null;
    }

    public static DiagramElement findDiagramElement(EObject object) {
        Definitions definitions = ModelUtil.getDefinitions(object);
        if (definitions != null) {
            for (BPMNDiagram d : definitions.getDiagrams()) {
                DiagramElement de = DIUtils.findDiagramElement(d, object);
                if (de == null) continue;
                return de;
            }
        }
        return null;
    }

    public static DiagramElement findDiagramElement(BPMNDiagram bpmnDiagram, EObject object) {
        for (DiagramElement de : bpmnDiagram.getPlane().getPlaneElement()) {
            EStructuralFeature f = de.eClass().getEStructuralFeature("bpmnElement");
            if (f == null || de.eGet(f) != object) continue;
            return de;
        }
        return null;
    }

    public static BPMNDiagram getBPMNDiagram(DiagramElement de) {
        EObject container = de.eContainer();
        while (!(container instanceof Definitions)) {
            if (container instanceof BPMNDiagram) {
                return (BPMNDiagram)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    public static boolean deleteContainerIfPossible(RootElement rootElement) {
        if (rootElement == null) {
            return false;
        }
        boolean canDelete = false;
        Definitions definitions = (Definitions)rootElement.eContainer();
        if (definitions != null) {
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)rootElement);
            RootElement newRootElement = null;
            if (bpmnDiagram == null) {
                ArrayList<EObject> allObjects = new ArrayList<EObject>();
                TreeIterator iter = definitions.eAllContents();
                while (iter.hasNext()) {
                    allObjects.add((EObject)iter.next());
                }
                Map usages = EcoreUtil.UsageCrossReferencer.findAll(allObjects, (EObject)rootElement);
                canDelete = usages.isEmpty();
            } else {
                for (RootElement r : definitions.getRootElements()) {
                    FlowElementsContainer container;
                    if (r == rootElement || !(r instanceof FlowElementsContainer) && !(r instanceof Collaboration)) continue;
                    if (rootElement instanceof Collaboration) {
                        Collaboration collaboration = (Collaboration)rootElement;
                        if (!collaboration.getParticipants().isEmpty()) break;
                        newRootElement = r;
                        canDelete = true;
                        break;
                    }
                    if (!(rootElement instanceof FlowElementsContainer) || !(container = (FlowElementsContainer)rootElement).getFlowElements().isEmpty()) break;
                    newRootElement = r;
                    canDelete = true;
                    break;
                }
            }
            if (canDelete && bpmnDiagram != null && newRootElement != null) {
                EcoreUtil.delete((EObject)rootElement);
                bpmnDiagram.getPlane().setBpmnElement(newRootElement);
            }
        }
        return canDelete;
    }

    public static void updateDiagramType(Diagram diagram) {
        BaseElement bpmnElement;
        BPMNDiagram bpmnDiagram = BusinessObjectUtil.getFirstElementOfType((PictogramElement)diagram, BPMNDiagram.class);
        if (bpmnDiagram != null && bpmnDiagram.getPlane() != null && (bpmnElement = bpmnDiagram.getPlane().getBpmnElement()) == null) {
            Definitions definitions = ModelUtil.getDefinitions(bpmnDiagram);
            for (RootElement r : definitions.getRootElements()) {
                if (!(r instanceof FlowElementsContainer) && !(r instanceof Collaboration)) continue;
                bpmnDiagram.getPlane().setBpmnElement((BaseElement)r);
                break;
            }
        }
    }

    public static List<PictogramElement> getPictogramElements(ResourceSet resourceSet, BaseElement baseElement) {
        ArrayList<PictogramElement> elements = new ArrayList<PictogramElement>();
        for (Resource r : resourceSet.getResources()) {
            for (EObject o : r.getContents()) {
                if (!(o instanceof Diagram)) continue;
                Diagram diagram = (Diagram)o;
                elements.addAll(Graphiti.getLinkService().getPictogramElements(diagram, (EObject)baseElement));
            }
        }
        return elements;
    }

    public static List<ContainerShape> getContainerShapes(ResourceSet resourceSet, BaseElement baseElement) {
        ArrayList<ContainerShape> shapes = new ArrayList<ContainerShape>();
        List<PictogramElement> pes = DIUtils.getPictogramElements(resourceSet, baseElement);
        for (PictogramElement pe : pes) {
            if (!(pe instanceof ContainerShape) || BusinessObjectUtil.getFirstElementOfType(pe, BPMNShape.class) == null) continue;
            shapes.add((ContainerShape)pe);
        }
        return shapes;
    }

    public static ContainerShape getContainerShape(BaseElement baseElement) {
        DiagramEditor diagramEditor = ModelUtil.getDiagramEditor((EObject)baseElement);
        if (diagramEditor != null) {
            Diagram diagram = diagramEditor.getDiagramTypeProvider().getDiagram();
            for (PictogramElement pe : Graphiti.getLinkService().getPictogramElements(diagram, (EObject)baseElement)) {
                if (!(pe instanceof ContainerShape) || BusinessObjectUtil.getFirstElementOfType(pe, BPMNShape.class) == null) continue;
                return (ContainerShape)pe;
            }
        }
        return null;
    }

    public static List<Connection> getConnections(ResourceSet resourceSet, BaseElement baseElement) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        List<PictogramElement> pes = DIUtils.getPictogramElements(resourceSet, baseElement);
        for (PictogramElement pe : pes) {
            if (!(pe instanceof Connection) || BusinessObjectUtil.getFirstElementOfType(pe, BPMNEdge.class) == null) continue;
            connections.add((Connection)pe);
        }
        return connections;
    }

    public static Connection getConnection(BaseElement baseElement) {
        DiagramEditor diagramEditor = ModelUtil.getDiagramEditor((EObject)baseElement);
        if (diagramEditor != null) {
            Diagram diagram = diagramEditor.getDiagramTypeProvider().getDiagram();
            for (Connection c : diagram.getConnections()) {
                if (BusinessObjectUtil.getFirstBaseElement((PictogramElement)c) != baseElement || BusinessObjectUtil.getFirstElementOfType((PictogramElement)c, BPMNEdge.class) == null) continue;
                return c;
            }
        }
        return null;
    }

    public static Diagram getDiagram(BaseElement baseElement) {
        Resource res = ExtendedPropertiesAdapter.getResource((Notifier)baseElement);
        List<PictogramElement> pes = DIUtils.getPictogramElements(res.getResourceSet(), baseElement);
        if (pes.size() > 0) {
            return Graphiti.getPeService().getDiagramForPictogramElement(pes.get(0));
        }
        return null;
    }
}

