/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBpmn2CreateConnectionFeature<CONNECTION extends BaseElement, SOURCE extends EObject, TARGET extends EObject>
extends AbstractCreateConnectionFeature
implements IBpmn2CreateFeature<CONNECTION, ICreateConnectionContext> {
    protected boolean changesDone = true;

    public AbstractBpmn2CreateConnectionFeature(IFeatureProvider fp) {
        super(fp, "", "");
    }

    public String getCreateName() {
        return ModelUtil.getTypeLabel(this.getFeatureClass());
    }

    public String getCreateDescription() {
        return NLS.bind((String)Messages.AbstractBpmn2CreateConnectionFeature_Create, (Object)this.getCreateName());
    }

    public String getName() {
        return this.getCreateName();
    }

    public String getDescription() {
        return this.getCreateDescription();
    }

    public boolean isAvailable(IContext context) {
        IReconnectionContext rc;
        BaseElement o = null;
        if (context instanceof ICreateConnectionContext) {
            ICreateConnectionContext ccc = (ICreateConnectionContext)context;
            if (ccc.getTargetPictogramElement() != null) {
                o = BusinessObjectUtil.getFirstElementOfType(ccc.getTargetPictogramElement(), BaseElement.class);
            } else if (ccc.getSourcePictogramElement() != null) {
                o = BusinessObjectUtil.getFirstElementOfType(ccc.getSourcePictogramElement(), BaseElement.class);
            }
        } else if (context instanceof IReconnectionContext && (rc = (IReconnectionContext)context).getTargetPictogramElement() != null) {
            o = BusinessObjectUtil.getFirstElementOfType(rc.getTargetPictogramElement(), BaseElement.class);
        }
        if (o instanceof EndEvent || o instanceof Group) {
            return false;
        }
        if (o instanceof EObject) {
            return this.isModelObjectEnabled((EObject)o);
        }
        return false;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        SOURCE o = this.getSourceBo(context);
        return o != null && !(o instanceof Lane);
    }

    public static boolean canCreateConnection(AnchorContainer sourceContainer, AnchorContainer targetContainer, EClass connectionClass, String reconnectType) {
        if (sourceContainer instanceof Diagram || targetContainer instanceof Diagram) {
            return false;
        }
        if (sourceContainer == targetContainer) {
            return true;
        }
        if (sourceContainer != null && targetContainer != null) {
            EObject sourceObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)sourceContainer);
            if (sourceObject instanceof Lane) {
                return false;
            }
            EObject targetObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)targetContainer);
            if (targetObject instanceof Lane) {
                return false;
            }
            Bpmn2Preferences prefs = Bpmn2Preferences.getInstance((EObject)sourceContainer);
            if (!prefs.getAllowMultipleConnections() && connectionClass == Bpmn2Package.eINSTANCE.getSequenceFlow()) {
                EObject o;
                if (!ReconnectionContext.RECONNECT_TARGET.equals(reconnectType) && ((sourceObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)sourceContainer)) instanceof Activity || sourceObject instanceof Event)) {
                    for (Anchor a : sourceContainer.getAnchors()) {
                        for (Connection c : a.getOutgoingConnections()) {
                            o = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)c);
                            if (!(o instanceof SequenceFlow)) continue;
                            return false;
                        }
                    }
                }
                if (!ReconnectionContext.RECONNECT_SOURCE.equals(reconnectType) && ((targetObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)targetContainer)) instanceof Activity || targetObject instanceof Event)) {
                    for (Anchor a : targetContainer.getAnchors()) {
                        for (Connection c : a.getIncomingConnections()) {
                            o = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)c);
                            if (!(o instanceof SequenceFlow)) continue;
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public CONNECTION createBusinessObject(ICreateConnectionContext context) {
        String id;
        EClass eclass;
        Resource resource = this.getResource(context);
        BaseElement businessObject = (BaseElement)Bpmn2ModelerFactory.createObject(resource, eclass = this.getBusinessObjectClass(), new Bpmn2ModelerFactory.KeyValue("custom.element.id", id = (String)context.getProperty((Object)"custom.element.id")));
        EStructuralFeature nameFeature = businessObject.eClass().getEStructuralFeature("name");
        if (nameFeature != null) {
            businessObject.eUnset(nameFeature);
        }
        SOURCE source = this.getSourceBo(context);
        TARGET target = this.getTargetBo(context);
        EStructuralFeature sourceRefFeature = businessObject.eClass().getEStructuralFeature("sourceRef");
        EStructuralFeature targetRefFeature = businessObject.eClass().getEStructuralFeature("targetRef");
        if (sourceRefFeature != null && targetRefFeature != null) {
            businessObject.eSet(sourceRefFeature, source);
            businessObject.eSet(targetRefFeature, target);
        }
        this.putBusinessObject(context, (CONNECTION)businessObject);
        this.changesDone = true;
        return (CONNECTION)businessObject;
    }

    protected Resource getResource(ICreateConnectionContext context) {
        PictogramElement pe = context.getSourcePictogramElement();
        if (pe == null) {
            pe = context.getTargetPictogramElement();
        }
        if (pe == null) {
            pe = context.getSourceAnchor();
        }
        if (pe == null) {
            pe = context.getTargetAnchor();
        }
        return ExtendedPropertiesAdapter.getResource((Notifier)pe);
    }

    @Override
    public CONNECTION getBusinessObject(ICreateConnectionContext context) {
        return (CONNECTION)((BaseElement)context.getProperty((Object)"businessObject"));
    }

    @Override
    public void putBusinessObject(ICreateConnectionContext context, CONNECTION businessObject) {
        context.putProperty((Object)"businessObject", businessObject);
        TargetRuntime rt = TargetRuntime.getRuntime((IDiagramContainer)this.getDiagramEditor());
        LifecycleEvent.notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_INITIALIZED, this.getFeatureProvider(), (IContext)context, businessObject, rt));
    }

    @Override
    public EClass getFeatureClass() {
        return this.getBusinessObjectClass();
    }

    @Override
    public void postExecute(IExecutionInfo executionInfo) {
        IFeatureAndContext[] iFeatureAndContextArray = executionInfo.getExecutionList();
        int n = iFeatureAndContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureAndContext fc = iFeatureAndContextArray[n2];
            IContext context = fc.getContext();
            if (context instanceof ICreateConnectionContext) {
                ICreateConnectionContext cc = (ICreateConnectionContext)context;
                CONNECTION businessObject = this.getBusinessObject(cc);
                Bpmn2Preferences prefs = (Bpmn2Preferences)this.getDiagramEditor().getAdapter(Bpmn2Preferences.class);
                if (prefs != null && prefs.getShowPopupConfigDialog(businessObject)) {
                    ObjectEditingDialog dialog = new ObjectEditingDialog(this.getDiagramEditor(), (EObject)businessObject);
                    dialog.open();
                }
            }
            ++n2;
        }
    }

    protected AddConnectionContext createAddConnectionContext(ICreateConnectionContext context, Object newObject) {
        AddConnectionContext newContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
        newContext.setNewObject(newObject);
        Object value = context.getProperty((Object)"custom.element.id");
        newContext.putProperty((Object)"custom.element.id", value);
        value = context.getProperty((Object)"is.importing");
        newContext.putProperty((Object)"is.importing", value);
        value = context.getProperty((Object)"businessObject");
        newContext.putProperty((Object)"businessObject", value);
        return newContext;
    }

    protected boolean isModelObjectEnabled() {
        ModelEnablements me = this.getModelEnablements();
        if (me != null) {
            return me.isEnabled(this.getBusinessObjectClass());
        }
        return false;
    }

    protected boolean isModelObjectEnabled(EObject o) {
        ModelEnablements me = this.getModelEnablements();
        if (me != null) {
            EClass eclass = o instanceof EClass ? (EClass)o : o.eClass();
            return me.isEnabled(eclass);
        }
        return false;
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }

    protected ModelEnablements getModelEnablements() {
        DiagramEditor editor = this.getDiagramEditor();
        return (ModelEnablements)editor.getAdapter(ModelEnablements.class);
    }

    protected SOURCE getSourceBo(ICreateConnectionContext context) {
        Anchor a = this.getSourceAnchor(context);
        if (a != null) {
            return BusinessObjectUtil.getFirstElementOfType((PictogramElement)a.getParent(), this.getSourceClass());
        }
        PictogramElement pe = context.getSourcePictogramElement();
        if (pe != null) {
            return BusinessObjectUtil.getFirstElementOfType(pe, this.getSourceClass());
        }
        return null;
    }

    protected Anchor getSourceAnchor(ICreateConnectionContext context) {
        Anchor a = context.getSourceAnchor();
        PictogramElement pe = context.getSourcePictogramElement();
        if (a == null && FeatureSupport.isLabelShape(pe)) {
            pe = FeatureSupport.getLabelOwner(pe);
            ((CreateConnectionContext)context).setSourcePictogramElement(pe);
            a = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
            ((CreateConnectionContext)context).setSourceAnchor(a);
        }
        return a;
    }

    protected TARGET getTargetBo(ICreateConnectionContext context) {
        Anchor a = this.getTargetAnchor(context);
        if (a != null) {
            return BusinessObjectUtil.getFirstElementOfType((PictogramElement)a.getParent(), this.getTargetClass());
        }
        return null;
    }

    protected Anchor getTargetAnchor(ICreateConnectionContext context) {
        Anchor a = context.getTargetAnchor();
        PictogramElement pe = context.getTargetPictogramElement();
        if (a == null && FeatureSupport.isLabelShape(pe)) {
            pe = FeatureSupport.getLabelOwner(pe);
            ((CreateConnectionContext)context).setTargetPictogramElement(pe);
            a = Graphiti.getPeService().getChopboxAnchor((AnchorContainer)pe);
            ((CreateConnectionContext)context).setTargetAnchor(a);
        }
        return a;
    }

    protected abstract Class<SOURCE> getSourceClass();

    protected abstract Class<TARGET> getTargetClass();

    protected DiagramEditor getDiagramEditor() {
        return (DiagramEditor)this.getDiagramBehavior().getDiagramContainer();
    }
}

