/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.ToolTipProvider;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBpmn2CreateFeature<T extends BaseElement>
extends AbstractCreateFeature
implements IBpmn2CreateFeature<T, ICreateContext> {
    protected boolean changesDone = true;

    public AbstractBpmn2CreateFeature(IFeatureProvider fp) {
        super(fp, "", "");
    }

    public String getCreateName() {
        return ModelUtil.getTypeLabel(this.getFeatureClass());
    }

    public String getCreateDescription() {
        String description = ToolTipProvider.INSTANCE.getToolTip(this, (EObject)this.getFeatureClass());
        if (!description.isEmpty()) {
            return description;
        }
        return NLS.bind((String)Messages.AbstractBpmn2CreateFeature_Create, (Object)this.getCreateName());
    }

    public String getName() {
        return this.getCreateName();
    }

    public String getDescription() {
        return this.getCreateDescription();
    }

    public boolean isAvailable(IContext context) {
        return this.isModelObjectEnabled();
    }

    public boolean canCreate(ICreateContext context) {
        Collaboration collaboration;
        BPMNDiagram bpmnDiagram;
        BaseElement bpmnElement;
        return !context.getTargetContainer().equals(this.getDiagram()) || !((bpmnElement = (bpmnDiagram = BusinessObjectUtil.getFirstElementOfType((PictogramElement)this.getDiagram(), BPMNDiagram.class)).getPlane().getBpmnElement()) instanceof Collaboration) || (collaboration = (Collaboration)bpmnElement).getConversations().isEmpty();
    }

    @Override
    public T createBusinessObject(ICreateContext context) {
        Resource resource = this.getResource(context);
        EClass eclass = this.getBusinessObjectClass();
        String id = (String)context.getProperty((Object)"custom.element.id");
        BaseElement businessObject = (BaseElement)Bpmn2ModelerFactory.createObject(resource, eclass, new Bpmn2ModelerFactory.KeyValue("custom.element.id", id));
        this.putBusinessObject(context, (T)businessObject);
        this.changesDone = true;
        return (T)businessObject;
    }

    protected Resource getResource(ICreateContext context) {
        ContainerShape pe = context.getTargetContainer();
        if (pe == null) {
            pe = context.getTargetConnection();
        }
        return ExtendedPropertiesAdapter.getResource((Notifier)pe);
    }

    @Override
    public T getBusinessObject(ICreateContext context) {
        return (T)((BaseElement)context.getProperty((Object)"businessObject"));
    }

    @Override
    public void putBusinessObject(ICreateContext context, T businessObject) {
        context.putProperty((Object)"businessObject", businessObject);
        TargetRuntime rt = TargetRuntime.getRuntime((IDiagramContainer)this.getDiagramEditor());
        LifecycleEvent.notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_INITIALIZED, this.getFeatureProvider(), (IContext)context, businessObject, rt));
    }

    @Override
    public EClass getFeatureClass() {
        return this.getBusinessObjectClass();
    }

    protected Object getBusinessObjectForPictogramElement(PictogramElement pe) {
        Object bo = super.getBusinessObjectForPictogramElement(pe);
        if (bo != null) {
            return bo;
        }
        return BusinessObjectUtil.getFirstBaseElement(pe);
    }

    @Override
    public void postExecute(IExecutionInfo executionInfo) {
        IFeatureAndContext[] iFeatureAndContextArray = executionInfo.getExecutionList();
        int n = iFeatureAndContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureAndContext fc = iFeatureAndContextArray[n2];
            IContext context = fc.getContext();
            if (context instanceof ICreateContext) {
                ICreateContext cc = (ICreateContext)context;
                T businessObject = this.getBusinessObject(cc);
                Bpmn2Preferences prefs = (Bpmn2Preferences)this.getDiagramEditor().getAdapter(Bpmn2Preferences.class);
                if (prefs != null && prefs.getShowPopupConfigDialog(businessObject)) {
                    ObjectEditingDialog dialog = new ObjectEditingDialog(this.getDiagramEditor(), (EObject)businessObject);
                    dialog.open();
                }
            }
            ++n2;
        }
    }

    protected AddContext createAddContext(ICreateContext context, Object newObject) {
        AddContext newContext = new AddContext((IAreaContext)context, newObject);
        Object value = context.getProperty((Object)"custom.element.id");
        newContext.putProperty((Object)"custom.element.id", value);
        value = context.getProperty((Object)"is.importing");
        newContext.putProperty((Object)"is.importing", value);
        value = context.getProperty((Object)"businessObject");
        newContext.putProperty((Object)"businessObject", value);
        return newContext;
    }

    protected boolean isModelObjectEnabled() {
        ModelEnablements me = this.getModelEnablements();
        if (me != null) {
            return me.isEnabled(this.getBusinessObjectClass());
        }
        return false;
    }

    protected boolean isModelObjectEnabled(EObject object) {
        ModelEnablements me = this.getModelEnablements();
        if (me != null) {
            return me.isEnabled(object.eClass());
        }
        return false;
    }

    protected ModelEnablements getModelEnablements() {
        DiagramEditor editor = this.getDiagramEditor();
        return (ModelEnablements)editor.getAdapter(ModelEnablements.class);
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }

    protected DiagramEditor getDiagramEditor() {
        return (DiagramEditor)this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
    }
}

