/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.features.CustomElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2FeatureProvider;
import org.eclipse.bpmn2.modeler.core.features.IFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.IShapeFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskImageProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.osgi.util.NLS;

public class CustomShapeFeatureContainer
extends CustomElementFeatureContainer
implements IShapeFeatureContainer {
    @Override
    public String getDescription() {
        if (this.customTaskDescriptor != null) {
            return this.customTaskDescriptor.getDescription();
        }
        return Messages.CustomShapeFeatureContainer_Description;
    }

    @Override
    protected IFeatureContainer createFeatureContainer(IFeatureProvider fp) {
        EClass eClass = (EClass)ModelDecorator.findEClassifier(this.customTaskDescriptor.getRuntime().getModelDescriptor().getEPackage(), this.customTaskDescriptor.getType());
        return ((IBpmn2FeatureProvider)fp).getFeatureContainer(eClass.getInstanceClass());
    }

    @Override
    protected IFeatureContainer getFeatureContainer(IFeatureProvider fp) {
        if (this.featureContainerDelegate == null) {
            this.featureContainerDelegate = this.createFeatureContainer(fp);
        }
        return this.featureContainerDelegate;
    }

    @Override
    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateCustomShapeFeature(fp);
    }

    @Override
    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddCustomShapeFeature(fp);
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getUpdateFeature(fp);
    }

    @Override
    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getDirectEditingFeature(fp);
    }

    @Override
    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getLayoutFeature(fp);
    }

    @Override
    public IRemoveFeature getRemoveFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getRemoveFeature(fp);
    }

    @Override
    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        IShapeFeatureContainer fc = (IShapeFeatureContainer)this.getFeatureContainer(fp);
        return fc.getMoveFeature(fp);
    }

    @Override
    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        IShapeFeatureContainer fc = (IShapeFeatureContainer)this.getFeatureContainer(fp);
        return fc.getResizeFeature(fp);
    }

    @Override
    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getDeleteFeature(fp);
    }

    @Override
    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        return this.getFeatureContainer(fp).getCustomFeatures(fp);
    }

    public class AddCustomShapeFeature
    extends AbstractBpmn2AddFeature<BaseElement> {
        protected AbstractBpmn2AddFeature<BaseElement> addFeatureDelegate;

        public AddCustomShapeFeature(IFeatureProvider fp) {
            super(fp);
            this.addFeatureDelegate = (AbstractBpmn2AddFeature)CustomShapeFeatureContainer.this.getFeatureContainer(fp).getAddFeature(fp);
            Assert.isNotNull(this.addFeatureDelegate);
        }

        public PictogramElement add(IAddContext context) {
            String icon;
            PictogramElement pe = this.addFeatureDelegate.add(context);
            if (pe != null) {
                peService.setPropertyValue((PropertyContainer)pe, "custom.element.id", CustomShapeFeatureContainer.this.getId());
            }
            if ((icon = CustomShapeFeatureContainer.this.customTaskDescriptor.getIcon()) != null && pe instanceof ContainerShape) {
                boolean addImage = true;
                ContainerShape containerShape = (ContainerShape)pe;
                GraphicsAlgorithm ga = (GraphicsAlgorithm)AbstractBpmn2AddFeature.getGraphicsAlgorithm(containerShape);
                for (PictogramElement child : containerShape.getChildren()) {
                    if (!(child.getGraphicsAlgorithm() instanceof Image)) continue;
                    addImage = false;
                    break;
                }
                if (ga != null) {
                    for (GraphicsAlgorithm g : ga.getGraphicsAlgorithmChildren()) {
                        if (!(g instanceof Image)) continue;
                        addImage = false;
                        break;
                    }
                } else {
                    addImage = false;
                }
                if (addImage) {
                    Image img = CustomTaskImageProvider.createImage(CustomShapeFeatureContainer.this.customTaskDescriptor, (GraphicsAlgorithmContainer)ga, icon, 24, 24);
                    Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)img, 2, 2, 24, 24);
                }
            }
            return pe;
        }

        @Override
        public BaseElement getBusinessObject(IAddContext context) {
            return this.addFeatureDelegate.getBusinessObject(context);
        }

        @Override
        public void putBusinessObject(IAddContext context, BaseElement businessObject) {
            this.addFeatureDelegate.putBusinessObject(context, businessObject);
        }

        @Override
        public void postExecute(IExecutionInfo executionInfo) {
            this.addFeatureDelegate.postExecute(executionInfo);
        }

        public boolean canAdd(IAddContext context) {
            return this.addFeatureDelegate.canAdd(context);
        }

        @Override
        public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
            return this.addFeatureDelegate.getAddLabelFeature(fp);
        }

        @Override
        public int getHeight(IAddContext context) {
            return this.addFeatureDelegate.getHeight(context);
        }

        @Override
        public int getWidth(IAddContext context) {
            return this.addFeatureDelegate.getWidth(context);
        }

        @Override
        public Class getBusinessObjectType() {
            return this.addFeatureDelegate.getBusinessObjectType();
        }
    }

    public class CreateCustomShapeFeature
    extends AbstractBpmn2CreateFeature<BaseElement> {
        protected AbstractBpmn2CreateFeature<BaseElement> createFeatureDelegate;
        protected String name;
        protected String description;

        public CreateCustomShapeFeature(IFeatureProvider fp, String name, String description) {
            super(fp);
            IShapeFeatureContainer fc = (IShapeFeatureContainer)CustomShapeFeatureContainer.this.getFeatureContainer(fp);
            this.createFeatureDelegate = (AbstractBpmn2CreateFeature)fc.getCreateFeature(fp);
            Assert.isNotNull(this.createFeatureDelegate);
            this.name = name;
            this.description = description;
        }

        @Override
        public String getCreateName() {
            if (this.name != null && !this.name.isEmpty()) {
                return this.name;
            }
            return this.createFeatureDelegate.getCreateName();
        }

        @Override
        public String getCreateDescription() {
            if (this.description != null && !this.description.isEmpty()) {
                return this.description;
            }
            return this.createFeatureDelegate.getCreateDescription();
        }

        public CreateCustomShapeFeature(IFeatureProvider fp) {
            this(fp, customShapeFeatureContainer.customTaskDescriptor.getName(), NLS.bind((String)Messages.CustomElementFeatureContainer_Create, (Object)customShapeFeatureContainer.customTaskDescriptor.getName()));
        }

        protected PictogramElement addGraphicalRepresentation(IAreaContext context, Object newObject) {
            AddContext addContext = new AddContext(context, newObject);
            CustomShapeFeatureContainer.setId((IContext)addContext, CustomShapeFeatureContainer.this.getId());
            PictogramElement pe = this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "custom.element.id", CustomShapeFeatureContainer.this.id);
            return pe;
        }

        @Override
        public boolean canCreate(ICreateContext context) {
            CustomShapeFeatureContainer.setId((IContext)context, CustomShapeFeatureContainer.this.id);
            return this.createFeatureDelegate.canCreate(context);
        }

        @Override
        public BaseElement createBusinessObject(ICreateContext context) {
            BaseElement businessObject = this.createFeatureDelegate.createBusinessObject(context);
            return businessObject;
        }

        @Override
        public EClass getBusinessObjectClass() {
            return this.createFeatureDelegate.getBusinessObjectClass();
        }

        public Object[] create(ICreateContext context) {
            Assert.isNotNull((Object)CustomShapeFeatureContainer.getId((IContext)context));
            return this.createFeatureDelegate.create(context);
        }

        public String getCreateImageId() {
            String id;
            String icon = CustomShapeFeatureContainer.this.customTaskDescriptor.getIcon();
            if (icon != null && (id = CustomShapeFeatureContainer.this.customTaskDescriptor.getImageId(icon, CustomTaskImageProvider.IconSize.SMALL)) != null) {
                return id;
            }
            return this.createFeatureDelegate.getCreateImageId();
        }

        public String getCreateLargeImageId() {
            String id;
            String icon = CustomShapeFeatureContainer.this.customTaskDescriptor.getIcon();
            if (icon != null && (id = CustomShapeFeatureContainer.this.customTaskDescriptor.getImageId(icon, CustomTaskImageProvider.IconSize.LARGE)) != null) {
                return id;
            }
            return this.createFeatureDelegate.getCreateLargeImageId();
        }
    }
}

