/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.data;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public abstract class AddDataFeature<T extends ItemAwareElement>
extends AbstractBpmn2AddFeature<T> {
    public AddDataFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp);
    }

    public boolean canAdd(IAddContext context) {
        return FeatureSupport.isValidDataTarget((ITargetContext)context);
    }

    public PictogramElement add(IAddContext context) {
        ItemAwareElement businessObject = (ItemAwareElement)this.getBusinessObject(context);
        int width = this.getWidth(context);
        int height = this.getHeight(context);
        int e = 10;
        ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle invisibleRect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, context.getX(), context.getY(), width, height);
        Shape rectShape = peService.createShape(containerShape, false);
        int[] nArray = new int[10];
        nArray[2] = width - e;
        nArray[4] = width;
        nArray[5] = e;
        nArray[6] = width;
        nArray[7] = height;
        nArray[9] = height;
        Polygon rect = gaService.createPolygon((GraphicsAlgorithmContainer)rectShape, nArray);
        rect.setLineWidth(Integer.valueOf(1));
        StyleUtil.applyStyle((GraphicsAlgorithm)rect, (BaseElement)businessObject);
        int p = width - e - 1;
        int[] nArray2 = new int[6];
        nArray2[0] = p;
        nArray2[2] = p;
        nArray2[3] = e + 1;
        nArray2[4] = width;
        nArray2[5] = e + 1;
        Polyline edge = gaService.createPolyline((GraphicsAlgorithmContainer)rect, nArray2);
        edge.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
        edge.setLineWidth(Integer.valueOf(1));
        int whalf = width / 2;
        this.createCollectionShape(containerShape, new int[]{whalf - 2, height - 8, whalf - 2, height});
        this.createCollectionShape(containerShape, new int[]{whalf, height - 8, whalf, height});
        this.createCollectionShape(containerShape, new int[]{whalf + 2, height - 8, whalf + 2, height});
        String value = "false";
        EStructuralFeature feature = businessObject.eClass().getEStructuralFeature("isCollection");
        if (feature != null && businessObject.eGet(feature) != null) {
            value = ((Boolean)businessObject.eGet(feature)).toString();
        }
        peService.setPropertyValue((PropertyContainer)containerShape, "isCollection", value);
        boolean isImport = context.getProperty((Object)"is.importing") != null;
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        ((AddContext)context).setWidth(width);
        ((AddContext)context).setHeight(height);
        this.decorateShape(context, containerShape, businessObject);
        peService.createChopboxAnchor((AnchorContainer)containerShape);
        return containerShape;
    }

    private Shape createCollectionShape(ContainerShape container, int[] xy) {
        Shape collectionShape = peService.createShape(container, false);
        Polyline line = gaService.createPolyline((GraphicsAlgorithmContainer)collectionShape, xy);
        line.setForeground(this.manageColor(StyleUtil.CLASS_FOREGROUND));
        line.setLineWidth(Integer.valueOf(1));
        line.setLineVisible(Boolean.valueOf(false));
        peService.setPropertyValue((PropertyContainer)collectionShape, "hideable", Boolean.toString(true));
        return collectionShape;
    }

    @Override
    protected boolean isHorizontal(ITargetContext context) {
        return false;
    }

    public abstract String getName(T var1);
}

