/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.event.definitions;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2UpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.DecorationAlgorithm;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractUpdateEventDefinitionFeature
extends AbstractBpmn2UpdateFeature {
    public AbstractUpdateEventDefinitionFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void draw(Event event, ContainerShape container) {
        if (FeatureSupport.isLabelShape((PictogramElement)container)) {
            return;
        }
        List<EventDefinition> eventDefinitions = ModelUtil.getEventDefinitions(event);
        int size = eventDefinitions.size();
        ShapeDecoratorUtil.deleteEventShape(container);
        if (size == 1) {
            Shape addedShape = this.getDecorationAlgorithm(event).draw(container);
            this.link((PictogramElement)addedShape, eventDefinitions.get(0));
            Graphiti.getPeService().setPropertyValue((PropertyContainer)addedShape, "event.definition.shape", Boolean.toString(true));
        } else if (size > 1) {
            Shape multipleShape = Graphiti.getPeService().createShape(container, false);
            this.drawForEvent(event, multipleShape);
            this.link((PictogramElement)multipleShape, eventDefinitions.toArray(new EventDefinition[size]));
            Graphiti.getPeService().setPropertyValue((PropertyContainer)multipleShape, "event.definition.shape", Boolean.toString(true));
        }
    }

    public abstract DecorationAlgorithm getDecorationAlgorithm(Event var1);

    private void drawForEvent(Event event, Shape shape) {
        if (event instanceof CatchEvent && ((CatchEvent)event).isParallelMultiple()) {
            AbstractUpdateEventDefinitionFeature.drawParallelMultiple(event, shape);
        } else {
            AbstractUpdateEventDefinitionFeature.drawMultiple(event, shape);
        }
    }

    public static void drawMultiple(Event event, Shape shape) {
        BaseElement be = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BaseElement.class, true);
        Polygon pentagon = ShapeDecoratorUtil.createEventPentagon(shape);
        if (event instanceof ThrowEvent) {
            StyleUtil.setFillStyle((GraphicsAlgorithm)pentagon, StyleUtil.FillStyle.FILL_STYLE_FOREGROUND);
        } else {
            StyleUtil.setFillStyle((GraphicsAlgorithm)pentagon, StyleUtil.FillStyle.FILL_STYLE_BACKGROUND);
        }
        StyleUtil.applyStyle((GraphicsAlgorithm)pentagon, be);
    }

    public static void drawParallelMultiple(Event event, Shape shape) {
        BaseElement be = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BaseElement.class, true);
        Polygon cross = ShapeDecoratorUtil.createEventParallelMultiple(shape);
        StyleUtil.setFillStyle((GraphicsAlgorithm)cross, StyleUtil.FillStyle.FILL_STYLE_BACKGROUND);
        StyleUtil.applyStyle((GraphicsAlgorithm)cross, be);
    }
}

