/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.FeatureEditingDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.MultivalueObjectEditor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ComboObjectEditor
extends MultivalueObjectEditor {
    protected ComboViewer comboViewer;
    protected Composite buttons = null;
    protected boolean keyPressed = false;
    protected Button editButton = null;
    protected Button createButton = null;
    protected Hashtable<String, Object> choices = null;

    public ComboObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        this(parent, object, feature, null);
    }

    public ComboObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature, EClass featureEType) {
        super(parent, object, feature, featureEType);
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        if (label == null) {
            label = ExtendedPropertiesProvider.getLabel(this.object, this.feature);
        }
        this.createLabel(composite, label);
        boolean canEdit = this.canEdit();
        boolean canEditInline = this.canEditInline();
        boolean canCreateNew = this.canCreateNew();
        if (style == 8) {
            canEdit = false;
            canEditInline = false;
            canCreateNew = false;
        }
        if (!canEditInline) {
            style |= 8;
        }
        this.comboViewer = this.createComboViewer(composite, AdapterRegistry.getLabelProvider(), style);
        Combo combo = this.comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 128, true, false, canEdit || canCreateNew ? 1 : 2, 1));
        combo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ComboObjectEditor.this.comboViewer = null;
            }
        });
        if (canEditInline) {
            combo.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    ComboObjectEditor.this.keyPressed = true;
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            combo.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (ComboObjectEditor.this.keyPressed) {
                        ComboObjectEditor.this.keyPressed = false;
                        String text = ComboObjectEditor.this.comboViewer.getCombo().getText();
                        ComboObjectEditor.this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)text));
                    }
                }
            });
        }
        this.buttons = null;
        if (canEdit || canCreateNew) {
            this.buttons = this.getToolkit().createComposite(composite);
            this.buttons.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            this.buttons.setLayout((Layout)new FillLayout(256));
            if (canCreateNew) {
                this.createButton = this.getToolkit().createButton(this.buttons, null, 8);
                this.createButton.setImage(Activator.getDefault().getImage("20/add.png"));
                this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ComboObjectEditor.this.buttonClicked(ID_CREATE_BUTTON);
                        ComboObjectEditor.this.fillCombo();
                    }
                });
            }
            if (canEdit) {
                this.editButton = this.getToolkit().createButton(this.buttons, null, 8);
                this.editButton.setImage(Activator.getDefault().getImage("20/edit.png"));
                this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ComboObjectEditor.this.buttonClicked(ID_EDIT_BUTTON);
                        ComboObjectEditor.this.fillCombo();
                    }
                });
                this.editButton.setEnabled(this.canEdit());
            }
        }
        this.fillCombo();
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection;
                if (!ComboObjectEditor.this.isWidgetUpdating && (selection = ComboObjectEditor.this.comboViewer.getSelection()) instanceof StructuredSelection) {
                    String firstElement = (String)((StructuredSelection)selection).getFirstElement();
                    if (firstElement != null && ComboObjectEditor.this.comboViewer.getData(firstElement) != null) {
                        ComboObjectEditor.this.setValue(ComboObjectEditor.this.comboViewer.getData(firstElement));
                    } else {
                        if (firstElement != null && firstElement.isEmpty()) {
                            firstElement = null;
                        }
                        if (firstElement == null) {
                            firstElement = ComboObjectEditor.this.comboViewer.getCombo().getText();
                        }
                        ComboObjectEditor.this.setValue(firstElement);
                        ComboObjectEditor.this.fillCombo();
                    }
                    if (ComboObjectEditor.this.editButton != null) {
                        ComboObjectEditor.this.editButton.setEnabled(ComboObjectEditor.this.canEdit() && firstElement != null && !firstElement.isEmpty());
                    }
                }
            }
        });
        return combo;
    }

    protected void buttonClicked(int buttonId) {
        ISelection selection;
        if (buttonId == ID_CREATE_BUTTON) {
            try {
                EObject value = this.createObject();
                this.setValue(value);
                this.fillCombo();
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (Exception ex2) {
                Activator.logError(ex2);
            }
        } else if (buttonId == ID_EDIT_BUTTON && (selection = this.comboViewer.getSelection()) instanceof StructuredSelection) {
            String firstElement = (String)((StructuredSelection)selection).getFirstElement();
            if (firstElement != null && firstElement.isEmpty()) {
                firstElement = null;
            }
            if (firstElement != null && this.comboViewer.getData(firstElement) instanceof EObject) {
                EObject value = (EObject)this.comboViewer.getData(firstElement);
                try {
                    value = this.editObject(value);
                    this.setValue(value);
                    this.fillCombo();
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (Exception ex2) {
                    Activator.logError(ex2);
                }
            }
        }
    }

    protected EObject createObject() throws Exception {
        FeatureEditingDialog dialog = this.createFeatureEditingDialog(null);
        dialog.setFeatureEType(this.featureEType);
        if (dialog.open() == 0) {
            return dialog.getNewObject();
        }
        throw new OperationCanceledException("Dialog Cancelled");
    }

    protected EObject editObject(EObject value) throws Exception {
        FeatureEditingDialog dialog = this.createFeatureEditingDialog(value);
        dialog.setFeatureEType(this.featureEType);
        if (dialog.open() == 0) {
            return dialog.getNewObject();
        }
        throw new OperationCanceledException("Dialog Cancelled");
    }

    @Override
    public boolean setValue(Object result) {
        this.keyPressed = false;
        return super.setValue(result);
    }

    @Override
    public Object getValue() {
        EObjectEList list;
        Object v = this.object.eGet(this.feature);
        if (v instanceof EObjectEList && (list = (EObjectEList)v).size() > 0) {
            v = list.get(0);
        }
        return v;
    }

    public String getTextValue() {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(this.object);
        if (adapter != null) {
            return adapter.getFeatureDescriptor(this.feature).getTextValue();
        }
        return this.getValue().toString();
    }

    protected void fillCombo() {
        try {
            this.isWidgetUpdating = true;
            if (this.comboViewer != null) {
                this.comboViewer.getCombo().setRedraw(false);
                Object oldValue = this.getValue();
                String oldTextValue = this.getTextValue();
                while (this.comboViewer.getElementAt(0) != null) {
                    this.comboViewer.remove(this.comboViewer.getElementAt(0));
                }
                this.choices = this.getChoiceOfValues(this.object, this.feature);
                if (this.canSetNull()) {
                    this.comboViewer.add((Object)"");
                }
                ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(oldValue);
                StructuredSelection currentSelection = null;
                if (this.choices != null) {
                    ArrayList<String> list = new ArrayList<String>(this.choices.keySet());
                    Collections.sort(list);
                    for (String key : list) {
                        this.comboViewer.add((Object)key);
                        Object newValue = this.choices.get(key);
                        if (newValue == null) continue;
                        this.comboViewer.setData(key, newValue);
                        if (currentSelection != null) continue;
                        if (newValue.equals(oldValue) || key.equals(oldValue) || key.equals(oldTextValue)) {
                            currentSelection = new StructuredSelection((Object)key);
                            continue;
                        }
                        if (adapter == null || !adapter.getObjectDescriptor().equals(newValue)) continue;
                        currentSelection = new StructuredSelection((Object)key);
                    }
                }
                if (currentSelection != null) {
                    this.comboViewer.setSelection(currentSelection);
                }
                if (this.editButton != null) {
                    this.editButton.setEnabled(this.canEdit() && currentSelection != null);
                }
            }
        }
        finally {
            if (this.comboViewer != null) {
                this.comboViewer.getCombo().setRedraw(true);
            }
            this.isWidgetUpdating = false;
        }
    }

    private boolean itemsChanged() {
        if (this.comboViewer == null) {
            return false;
        }
        Object newValue = this.getValue();
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(newValue);
        Hashtable<String, Object> newChoices = this.getChoiceOfValues(this.object, this.feature);
        if (this.choices == null || this.choices.size() != newChoices.size()) {
            return true;
        }
        StructuredSelection oldSelection = (StructuredSelection)this.comboViewer.getSelection();
        Object oldValue = oldSelection.getFirstElement();
        if (oldValue instanceof String) {
            oldValue = this.comboViewer.getData((String)oldValue);
        }
        if (oldValue == null) {
            return newValue != null;
        }
        if (adapter != null ? !adapter.getObjectDescriptor().equals(oldValue) : !oldValue.equals(newValue)) {
            return true;
        }
        for (Map.Entry<String, Object> entry : newChoices.entrySet()) {
            oldValue = this.choices.get(entry.getKey());
            newValue = entry.getValue();
            adapter = ExtendedPropertiesAdapter.adapt(newValue);
            if (!(newValue == null ? oldValue != null : (adapter != null ? !adapter.getObjectDescriptor().equals(oldValue) : !newValue.equals(oldValue)))) continue;
            return true;
        }
        return false;
    }

    private ComboViewer createComboViewer(Composite parent, AdapterFactoryLabelProvider labelProvider, int style) {
        ComboViewer comboViewer = new ComboViewer(parent, style);
        comboViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        return comboViewer;
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if ((notification.getEventType() == -1 || notification.getFeature() == this.feature) && this.itemsChanged()) {
            this.fillCombo();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.comboViewer.getCombo().setVisible(visible);
        GridData data = (GridData)this.comboViewer.getCombo().getLayoutData();
        boolean bl = data.exclude = !visible;
        if (this.buttons != null) {
            this.buttons.setVisible(visible);
            data = (GridData)this.buttons.getLayoutData();
            data.exclude = !visible;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.comboViewer != null && !this.comboViewer.getCombo().isDisposed()) {
            this.comboViewer.getCombo().dispose();
            this.comboViewer = null;
        }
        if (this.editButton != null && !this.editButton.isDisposed()) {
            this.editButton.dispose();
            this.editButton = null;
        }
        if (this.createButton != null && !this.createButton.isDisposed()) {
            this.createButton.dispose();
            this.createButton = null;
        }
        if (this.buttons != null && !this.buttons.isDisposed()) {
            this.buttons.dispose();
            this.buttons = null;
        }
    }

    @Override
    public Control getControl() {
        return this.comboViewer.getCombo();
    }
}

