/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.handlers;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.jbpm.preferences.JbpmInstallation;
import org.jboss.tools.jbpm.preferences.PreferencesManager;
import org.jboss.tools.runtime.core.model.AbstractRuntimeDetectorDelegate;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;

public class JbpmHandler
extends AbstractRuntimeDetectorDelegate {
    private static final String JBPM3 = "jBPM3";
    private static final String JBPM4 = "jBPM4";
    private static final String JBPM = "JBPM";
    private static final String SOA_P = "SOA-P";
    private static final String SOA_P_STD = "SOA-P-STD";

    public static File getJbpmRoot(RuntimeDefinition runtimeDefinition) {
        String type = runtimeDefinition.getType();
        if (SOA_P.equals(type) || SOA_P_STD.equals(type)) {
            return new File(runtimeDefinition.getLocation(), "jbpm-jpdl");
        }
        if (JBPM.equals(type)) {
            return runtimeDefinition.getLocation();
        }
        return null;
    }

    public void initializeRuntimes(List<RuntimeDefinition> runtimeDefinitions) {
        for (RuntimeDefinition runtimeDefinition : runtimeDefinitions) {
            if (runtimeDefinition.isEnabled() && !JbpmHandler.jbpmExists(runtimeDefinition)) {
                File jbpmRoot = JbpmHandler.getJbpmRoot(runtimeDefinition);
                if (jbpmRoot == null || !jbpmRoot.isDirectory()) continue;
                String type = runtimeDefinition.getType();
                if (JBPM.equals(type)) {
                    PreferencesManager.getInstance().addJbpmInstallation(runtimeDefinition.getName(), jbpmRoot.getAbsolutePath(), runtimeDefinition.getVersion());
                }
            }
            this.initializeRuntimes(runtimeDefinition.getIncludedRuntimeDefinitions());
        }
    }

    public static boolean jbpmExists(RuntimeDefinition runtimeDefinition) {
        File jbpmRoot = JbpmHandler.getJbpmRoot(runtimeDefinition);
        if (jbpmRoot == null || !jbpmRoot.isDirectory()) {
            return false;
        }
        Map jbpmMap = PreferencesManager.getInstance().getJbpmInstallationMap();
        Collection jbpmInstalations = jbpmMap.values();
        for (JbpmInstallation jbpm : jbpmInstalations) {
            String location = jbpm.location;
            if (location == null || !location.equals(jbpmRoot.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public RuntimeDefinition getRuntimeDefinition(File root, IProgressMonitor monitor) {
        if (monitor.isCanceled() || root == null) {
            return null;
        }
        boolean isJBPM = this.isValidJbpmInstallation(root.getAbsolutePath());
        if (isJBPM) {
            String version = "unknown";
            if (JbpmHandler.isJbpm3(root.getAbsolutePath())) {
                version = JBPM3;
            } else if (JbpmHandler.isJbpm4(root.getAbsolutePath())) {
                version = JBPM4;
            }
            String name = root.getName();
            int index = 1;
            boolean nameExists = PreferencesManager.getInstance().getJbpmInstallation(name) != null;
            while (nameExists) {
                name = String.valueOf(root.getName()) + " " + index++;
                boolean bl = nameExists = PreferencesManager.getInstance().getJbpmInstallation(name) != null;
            }
            return new RuntimeDefinition(name, version, JBPM, root.getAbsoluteFile());
        }
        return null;
    }

    private static boolean isJbpm3(String location) {
        return new Path(location).append("/src/resources/gpd/version.info.xml").toFile().exists();
    }

    private static boolean isJbpm4(String location) {
        return new Path(location).append("/jbpm.jar").toFile().exists();
    }

    private boolean isValidJbpmInstallation(String location) {
        return JbpmHandler.isJbpm3(location) || JbpmHandler.isJbpm4(location);
    }

    public boolean exists(RuntimeDefinition runtimeDefinition) {
        if (runtimeDefinition == null || runtimeDefinition.getLocation() == null) {
            return false;
        }
        return JbpmHandler.jbpmExists(runtimeDefinition);
    }

    public void computeIncludedRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
        if (runtimeDefinition == null || !SOA_P.equals(runtimeDefinition.getType())) {
            return;
        }
        File jbpmRoot = new File(runtimeDefinition.getLocation(), "jbpm-jpdl");
        if (jbpmRoot.isDirectory()) {
            String version = JBPM3;
            if (JbpmHandler.isJbpm4(runtimeDefinition.getLocation().getAbsolutePath())) {
                version = JBPM4;
            }
            RuntimeDefinition sd = new RuntimeDefinition(runtimeDefinition.getName(), version, JBPM, jbpmRoot);
            sd.setParent(runtimeDefinition);
            runtimeDefinition.getIncludedRuntimeDefinitions().add(sd);
        }
    }

    public String getVersion(RuntimeDefinition runtimeDefinition) {
        return runtimeDefinition.getVersion();
    }
}

