/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpel;

import javax.xml.namespace.QName;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.soa.sca.sca1_1.model.sca.BPELImplementation;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.bpel.Activator;
import org.switchyard.tools.ui.bpel.Messages;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.property.AbstractChangeAwareModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class BPELImplementationComposite
extends AbstractChangeAwareModelComposite<Component> {
    private Composite _panel;
    private BPELImplementation _implementation;
    private Text _bpelFileText;
    private Button _browseBPELButton;
    private IProject _project;
    private boolean _updating;

    public BPELImplementationComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        FormToolkit factory = this.getWidgetFactory();
        this._panel = this;
        this._panel.setLayout((Layout)new GridLayout(3, false));
        factory.createLabel(this._panel, Messages.BPELImplementationComposite_newBPELFileLinkLabel);
        this._bpelFileText = factory.createText(this._panel, "", 8);
        this._bpelFileText.setLayoutData((Object)new GridData(768));
        this._bpelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                BPELImplementationComposite.this.handleModify((Control)BPELImplementationComposite.this._bpelFileText);
            }
        });
        this._browseBPELButton = factory.createButton(this._panel, Messages.BPELImplementationComposite_browseBPELFileButton, 8);
        this._browseBPELButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BPELImplementationComposite.this.handleBrowse();
            }
        });
        this.adaptChildren((Control)this);
    }

    protected void handleModify(Control control) {
        QName newValue;
        QName qName = newValue = this._bpelFileText.getText().length() == 0 ? null : QName.valueOf(this._bpelFileText.getText());
        if (!this._updating && (newValue == null && this._implementation.getProcess() != null || newValue != null && !newValue.equals(this._implementation.getProcess()))) {
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    BPELImplementationComposite.this._implementation.setProcess(newValue);
                }
            });
        }
    }

    public void refresh() {
        this._implementation = null;
        Component bo = (Component)this.getTargetObject();
        if (bo != null) {
            this._implementation = (BPELImplementation)bo.getImplementation();
            this._project = PlatformResourceAdapterFactory.getContainingProject((Object)this._implementation);
        }
        this._updating = true;
        try {
            if (this._implementation != null && this._implementation.getProcess() != null && this._bpelFileText != null) {
                this._bpelFileText.setText(this._implementation.getProcess().toString());
            } else {
                this.handleModify((Control)this._bpelFileText);
            }
        }
        finally {
            this._updating = false;
        }
    }

    private void handleBrowse() {
        Object[] result;
        Object container = this._project == null ? ResourcesPlugin.getWorkspace().getRoot() : this._project.getProject();
        ClasspathResourceSelectionDialog dialog = new ClasspathResourceSelectionDialog(this._panel.getShell(), (IContainer)container, "bpel");
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IFile) {
            IFile bpelFile = (IFile)result[0];
            if (this._implementation == null) {
                this._implementation = ScaFactory.eINSTANCE.createBPELImplementation();
            }
            final QName processName = Activator.getDefault().getProcessForFile(bpelFile);
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    BPELImplementationComposite.this._implementation.setProcess(processName);
                }
            });
            this._bpelFileText.setText(processName.toString());
            this.handleModify((Control)this._bpelFileText);
            this.fireChangedEvent(this._bpelFileText);
        }
    }
}

