/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic.ui.editor.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.core.translators.TranslatorPropertyDefinition;
import org.teiid.designer.vdb.ui.VdbUiConstants;

public class AddPropertyDialog
extends MessageDialog {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(AddPropertyDialog.class);
    private Button btnOk;
    private final List<String> existingNames;
    private String name;
    private String value;
    private TranslatorOverrideProperty transOverrideProperty;
    private String editingName = null;

    public AddPropertyDialog(Shell parentShell, String title, List<String> existingPropertyNames, TranslatorOverrideProperty transOverrideProperty) {
        super(parentShell, title, null, VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "message", new Object[0]), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.existingNames = existingPropertyNames == null ? new ArrayList(0) : existingPropertyNames;
        this.transOverrideProperty = transOverrideProperty;
        if (this.transOverrideProperty != null) {
            this.name = this.editingName = this.transOverrideProperty.getDefinition().getId();
            this.value = this.transOverrideProperty.getDefinition().getDefaultValue();
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected Control createCustomArea(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblName = new Label(pnl, 0);
        lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblName.setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "lblName.text", new Object[0]));
        Text txtName = new Text(pnl, 2048);
        txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtName.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "txtName.toolTip", new Object[0]));
        if (this.transOverrideProperty != null) {
            txtName.setText(this.transOverrideProperty.getDefinition().getId());
        }
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPropertyDialog.this.handleNameChanged(((Text)e.widget).getText());
            }
        });
        Label lblValue = new Label(pnl, 0);
        lblValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblValue.setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "lblValue.text", new Object[0]));
        Text txtValue = new Text(pnl, 2048);
        txtValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtValue.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "txtValue.toolTip", new Object[0]));
        if (this.transOverrideProperty != null) {
            txtValue.setText(this.transOverrideProperty.getDefinition().getDefaultValue());
        }
        txtValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPropertyDialog.this.handleValueChanged(((Text)e.widget).getText());
            }
        });
        return pnl;
    }

    public TranslatorOverrideProperty getProperty() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return new TranslatorOverrideProperty(new TranslatorPropertyDefinition(this.name, this.value), null);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    void handleNameChanged(String newName) {
        this.name = newName;
        this.updateState();
    }

    void handleValueChanged(String newValue) {
        this.value = newValue.trim();
        this.updateState();
    }

    private void updateState() {
        String msg = this.validateName();
        if (StringUtilities.isEmpty((String)msg)) {
            msg = this.validateValue();
        }
        if (StringUtilities.isEmpty((String)msg)) {
            if (!this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(true);
            }
            if (this.imageLabel.getImage() != null) {
                this.imageLabel.setImage(null);
            }
            this.imageLabel.setImage(this.getInfoImage());
            msg = VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "message", new Object[0]);
        } else {
            if (this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(false);
            }
            this.imageLabel.setImage(this.getErrorImage());
        }
        this.messageLabel.setText(msg);
        this.messageLabel.pack();
    }

    private String validateName() {
        String errorMsg = TranslatorPropertyDefinition.validateName((String)this.name);
        if (errorMsg == null) {
            for (String existingName : this.existingNames) {
                if (!existingName.equals(this.name) || this.editingName != null && this.editingName.equals(this.name)) continue;
                errorMsg = VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "customPropertyAlreadyExists", (Object)this.name);
                break;
            }
        }
        return errorMsg;
    }

    private String validateValue() {
        return TranslatorPropertyDefinition.validateValue((String)this.value);
    }
}

