/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMarkerResolution;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.ui.Messages;

public class VdbModelNotInProjectMarkerResolution
implements IMarkerResolution {
    public String getLabel() {
        return Messages.extractMissingModelsLabel;
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        if (this.isVdbFile(resource)) {
            final IFile theVdbFile = (IFile)resource;
            final Exception[] theException = new Exception[1];
            UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        VdbModelNotInProjectMarkerResolution.this.fixVdb(theVdbFile);
                    }
                    catch (Exception ex) {
                        theException[0] = ex;
                    }
                }
            });
            if (theException[0] != null) {
                ErrorHandler.toExceptionDialog((Throwable)theException[0]);
            }
        }
    }

    void fixVdb(IFile theVdb) throws Exception {
        VdbUtil.synchronizeWorkspace((IFile)theVdb);
    }

    private boolean isVdbFile(IResource resource) {
        return resource.getType() == 1 && "vdb".equals(resource.getFileExtension()) && resource.exists();
    }
}

