/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.editor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.common.table.ComboBoxEditingSupport;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbImportVdbEntry;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.VdbUiPlugin;

public class ShowImportVdbsDialog
extends Dialog {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ShowImportVdbsDialog.class);
    private static final String TITLE = ShowImportVdbsDialog.getString("title");
    private static final String EMPTY_STRING = "";
    static String[] TRUE_FALSE_ARRAY = new String[]{"true", "false"};
    private Vdb vdb;
    TableViewer importVdbViewer;

    private static String getString(String id) {
        return VdbUiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ShowImportVdbsDialog(Shell parent, Vdb vdb) {
        super(parent, TITLE);
        this.vdb = vdb;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainPanel = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        mainPanel.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        Group theGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)ShowImportVdbsDialog.getString("vdbNames"), (int)0, (int)1, (int)4);
        GridData groupGD = new GridData(1808);
        groupGD.heightHint = 160;
        groupGD.widthHint = 400;
        theGroup.setLayoutData((Object)groupGD);
        this.importVdbViewer = new TableViewer((Composite)theGroup, 2816);
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        this.importVdbViewer.getControl().setLayoutData((Object)data);
        int visibleTableRows = 4;
        Table table = this.importVdbViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)table.getLayoutData()).horizontalSpan = 2;
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * visibleTableRows;
        TableViewerColumn column = new TableViewerColumn(this.importVdbViewer, 16384);
        column.getColumn().setText(ShowImportVdbsDialog.getString("name"));
        column.setLabelProvider((CellLabelProvider)new ImportVdbLabelProvider(0));
        column.getColumn().setWidth(200);
        column = new TableViewerColumn(this.importVdbViewer, 16384);
        column.getColumn().setText(ShowImportVdbsDialog.getString("version"));
        column.setLabelProvider((CellLabelProvider)new ImportVdbLabelProvider(1));
        column.setEditingSupport((EditingSupport)new VdbVersionEditingSupport((ColumnViewer)this.importVdbViewer));
        column.getColumn().setWidth(60);
        column = new TableViewerColumn(this.importVdbViewer, 16384);
        column.getColumn().setText(ShowImportVdbsDialog.getString("importDataPolicies"));
        column.setLabelProvider((CellLabelProvider)new ImportVdbLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ImportDataPoliciesEditingSupport((ColumnViewer)this.importVdbViewer));
        column.getColumn().setWidth(60);
        if (this.vdb != null) {
            for (VdbImportVdbEntry row : this.vdb.getImports()) {
                if (row == null) continue;
                this.importVdbViewer.add((Object)row);
            }
        }
        return mainPanel;
    }

    class ImportDataPoliciesEditingSupport
    extends ComboBoxEditingSupport {
        public ImportDataPoliciesEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected String getElementValue(Object element) {
            return Boolean.toString(((VdbImportVdbEntry)element).isImportDataPolicies());
        }

        protected String[] refreshItems(Object element) {
            return TRUE_FALSE_ARRAY;
        }

        protected void setElementValue(Object element, String newValue) {
            if (element instanceof VdbImportVdbEntry) {
                VdbImportVdbEntry info = (VdbImportVdbEntry)element;
                if (info.isImportDataPolicies()) {
                    info.setImportDataPolicies(false);
                    ShowImportVdbsDialog.this.importVdbViewer.refresh(element);
                } else {
                    info.setImportDataPolicies(true);
                    ShowImportVdbsDialog.this.importVdbViewer.refresh(element);
                }
            }
        }
    }

    class ImportVdbLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ImportVdbLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof VdbImportVdbEntry) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((VdbImportVdbEntry)element).getName();
                    }
                    case 1: {
                        return Integer.toString(((VdbImportVdbEntry)element).getVersion());
                    }
                    case 2: {
                        return Boolean.toString(((VdbImportVdbEntry)element).isImportDataPolicies());
                    }
                }
            }
            return ShowImportVdbsDialog.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (element instanceof VdbImportVdbEntry) {
                switch (this.columnNumber) {
                    case 0: {
                        return VdbUiPlugin.singleton.getImage("icons/full/obj16/VDB.gif");
                    }
                    case 1: {
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
    }

    class VdbVersionEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public VdbVersionEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof VdbImportVdbEntry) {
                return Integer.toString(((VdbImportVdbEntry)element).getVersion());
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof VdbImportVdbEntry) {
                int oldValue;
                int newValue = oldValue = ((VdbImportVdbEntry)element).getVersion();
                try {
                    newValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (newValue != oldValue) {
                    ((VdbImportVdbEntry)element).setVersion(newValue);
                    ShowImportVdbsDialog.this.importVdbViewer.refresh(element);
                }
            }
        }
    }
}

