/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.EditorPart;
import org.osgi.service.prefs.BackingStoreException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ResourceChangeUtilities;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.table.CheckBoxColumnProvider;
import org.teiid.designer.ui.common.table.ColumnProvider;
import org.teiid.designer.ui.common.table.DefaultTableProvider;
import org.teiid.designer.ui.common.table.TableAndToolBar;
import org.teiid.designer.ui.common.table.TableProvider;
import org.teiid.designer.ui.common.table.TextColumnProvider;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.common.widget.ButtonProvider;
import org.teiid.designer.ui.common.widget.DefaultContentProvider;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.properties.extension.VdbFileDialogUtil;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbFileEntry;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbSchemaEntry;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.vdb.connections.SourceHandlerExtensionManager;
import org.teiid.designer.vdb.ui.Messages;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.VdbUiPlugin;
import org.teiid.designer.vdb.ui.editor.ConfirmationDialog;
import org.teiid.designer.vdb.ui.editor.ShowImportVdbsDialog;
import org.teiid.designer.vdb.ui.editor.VdbDataRoleResolver;
import org.teiid.designer.vdb.ui.editor.panels.DataRolesPanel;
import org.teiid.designer.vdb.ui.editor.panels.DescriptionPanel;
import org.teiid.designer.vdb.ui.editor.panels.ModelDetailsPanel;
import org.teiid.designer.vdb.ui.editor.panels.PropertiesPanel;
import org.teiid.designer.vdb.ui.editor.panels.UserDefinedPropertiesPanel;
import org.teiid.designer.vdb.ui.translators.TranslatorOverridesPanel;

public final class VdbEditor
extends EditorPart
implements IResourceChangeListener {
    static final String MODEL_COLUMN_NAME = VdbEditor.i18n("modelColumnName");
    static final String SCHEMA_COLUMN_NAME = VdbEditor.i18n("schemaColumnName");
    static final String FILE_COLUMN_NAME = VdbEditor.i18n("fileColumnName");
    static final String PATH_COLUMN_NAME = VdbEditor.i18n("pathColumnName");
    static final String VDB_LOC_COLUMN_NAME = VdbEditor.i18n("locationInVdbColumnName");
    static final String SYNCHRONIZED_COLUMN_NAME = VdbEditor.i18n("synchronizedColumnName");
    static final String VISIBLE_COLUMN_NAME = VdbEditor.i18n("visibleColumnName");
    static final String DESCRIPTION_COLUMN_NAME = VdbEditor.i18n("descriptionColumnName");
    static final String SYNCHRONIZED_TOOLTIP = VdbEditor.i18n("synchronizedTooltip");
    static final String UNSYNCHRONIZED_TOOLTIP = VdbEditor.i18n("unsynchronizedTooltip");
    static final String SYNCHRONIZATION_NOT_APPLICABLE_TOOLTIP = VdbEditor.i18n("synchronizationNotApplicableTooltip");
    static final String VISIBLE_TOOLTIP = VdbEditor.i18n("visibleTooltip");
    static final String NOT_VISIBLE_TOOLTIP = VdbEditor.i18n("notVisibleTooltip");
    static final String ADD_MODEL_DIALOG_TITLE = VdbEditor.i18n("addModelDialogTitle");
    static final String ADD_MODEL_DIALOG_MESSAGE = VdbEditor.i18n("addModelDialogMessage");
    static final String ADD_FILE_DIALOG_TITLE = VdbEditor.i18n("addFileDialogTitle");
    static final String ADD_FILE_DIALOG_MESSAGE = VdbEditor.i18n("addFileDialogMessage");
    static final String ADD_FILE_DIALOG_INVALID_SELECTION_MESSAGE = VdbEditor.i18n("addFileDialogInvalidSelectionMessage");
    static final String ADD_FILE_DIALOG_NON_MODEL_SELECTED_MESSAGE = VdbEditor.i18n("addFileDialogNonModelSelectedMessage");
    static final String ADD_FILE_DIALOG_VDB_SOURCE_MODEL_SELECTED_MESSAGE = VdbEditor.i18n("addFileDialogVdbSourceModelSelectedMessage");
    static final String ADD_FILE_DIALOG_MODEL_WITH_SAME_NAME_EXISTS_SELECTED_MESSAGE = VdbEditor.i18n("addFileDialogModelWithSameNameExistsSelectedMessage");
    static final String CONFIRM_DIRTY_MODELS_DIALOG_TITLE = VdbEditor.i18n("confirmDirtyModelsDialogTitle");
    static final String CONFIRM_DIRTY_MODELS_DIALOG_MESSAGE = VdbEditor.i18n("confirmDirtyModelsSynchronizeMessage");
    static final String CONFIRM_DIALOG_TITLE = VdbEditor.i18n("confirmDialogTitle");
    static final String CONFIRM_SYNCHRONIZE_MESSAGE = VdbEditor.i18n("confirmSynchronizeMessage");
    static final String CONFIRM_SYNCHRONIZE_ALL_MESSAGE = VdbEditor.i18n("confirmSynchronizeAllMessage");
    static final String CONFIRM_REMOVE_MESSAGE = VdbEditor.i18n("confirmRemoveMessage");
    static final String CONFIRM_REMOVE_IMPORTED_BY_MESSAGE = VdbEditor.i18n("confirmRemoveImportedByMessage");
    static final String CONFIRM_OVERWRITE_USERFILE_MESSAGE = VdbEditor.i18n("confirmOverwriteUserFileMessage");
    static final String CONFIRM_OVERWRITE_UDFJAR_MESSAGE = VdbEditor.i18n("confirmOverwriteUdfJarMessage");
    static final String INFORM_DATA_ROLES_ON_ADD_MESSAGE = VdbEditor.i18n("informDataRolesExistOnAddMessage");
    static final String CANNOT_ADD_DUPLICATE_MODEL_NAME_TITLE = VdbEditor.i18n("cannotAddDuplicateModelNameTitle");
    static final String CANNOT_ADD_DUPLICATE_MODEL_NAME_MESSAGE = VdbEditor.i18n("cannotAddDuplicateModelNameMessage");
    static final String INVALID_INTEGER_INPUT_TITLE = VdbEditor.i18n("invalidVdbVersionValueTitle");
    static final String INVALID_INTEGER_INPUT_MESSAGE = VdbEditor.i18n("invalidVdbVersionValueMessage");
    static final int MODELS_PANEL_WIDTH_HINT = 300;
    static final int MODELS_PANEL_IMAGE_COL_WIDTH = 50;
    static final int MODELS_PANEL_MODELNAME_COL_WIDTH_MIN = 200;
    private Vdb vdb;
    Exception vdbLoadingException = null;
    TableAndToolBar<VdbModelEntry> modelsGroup;
    TableAndToolBar<VdbModelEntry> schemaGroup;
    ModelDetailsPanel modelDetailsPanel;
    TableAndToolBar<VdbEntry> otherFilesGroup;
    TableAndToolBar<VdbEntry> udfJarsGroup;
    private Button synchronizeAllButton;
    Button showImportVdbsButton;
    private Label validationDateTimeLabel;
    private Label validationVersionLabel;
    private PropertyChangeListener vdbListener;
    private DataRolesPanel dataRolesPanel;
    VdbDataRoleResolver dataRoleResolver;
    TranslatorOverridesPanel pnlTranslatorOverrides;
    private PropertiesPanel propertiesPanel;
    private UserDefinedPropertiesPanel userDefinedPropertiesPanel;
    DescriptionPanel descriptionPanel;
    boolean disposed = false;
    private final TextColumnProvider<VdbEntry> descriptionColumnProvider = new TextColumnProvider<VdbEntry>(){

        public String getName() {
            return DESCRIPTION_COLUMN_NAME;
        }

        public Image getImage() {
            return null;
        }

        public String getValue(VdbEntry element) {
            return element.getDescription();
        }

        public boolean isEditable(VdbEntry element) {
            return true;
        }

        public void setValue(VdbEntry element, String value) {
            element.setDescription(value);
        }
    };
    private final ModelLabelProvider modelLabelProvider = new ModelLabelProvider();
    private final TextColumnProvider<VdbEntry> locationInVdbColumnProvider = new TextColumnProvider<VdbEntry>(){

        public String getName() {
            return VDB_LOC_COLUMN_NAME;
        }

        public Image getImage() {
            return null;
        }

        public String getValue(VdbEntry element) {
            return element.getDirectory();
        }
    };
    private final CheckBoxColumnProvider<VdbEntry> syncColumnProvider = new CheckBoxColumnProvider<VdbEntry>(){

        public String getName() {
            return null;
        }

        public Image getImage() {
            return VdbUiPlugin.singleton.getImage("icons/full/cview16/synchronizemodels.gif");
        }

        public String getToolTip(VdbEntry element) {
            if (element.getSynchronization() == VdbEntry.Synchronization.Synchronized) {
                return SYNCHRONIZED_TOOLTIP;
            }
            if (element.getSynchronization() == VdbEntry.Synchronization.NotSynchronized) {
                return UNSYNCHRONIZED_TOOLTIP;
            }
            return SYNCHRONIZATION_NOT_APPLICABLE_TOOLTIP;
        }

        public Boolean getValue(VdbEntry element) {
            if (element.getSynchronization() == VdbEntry.Synchronization.Synchronized) {
                return true;
            }
            return false;
        }

        public boolean isEditable(VdbEntry element) {
            return element.getSynchronization() == VdbEntry.Synchronization.NotSynchronized;
        }

        public void setValue(final VdbEntry element, Boolean value) {
            boolean hasDataRoles;
            IPreferenceStore prefStore = VdbUiPlugin.singleton.getPreferenceStore();
            boolean showWarningDialog = "".equals(prefStore.getString("synchronizeWithoutWarning")) ? true : !prefStore.getBoolean("synchronizeWithoutWarning");
            boolean synchronize = !showWarningDialog;
            boolean okIfModelsDirty = true;
            Collection iFiles = VdbUtil.getVdbModels((Vdb)VdbEditor.this.getVdb());
            boolean askedQuestion = false;
            for (IFile theFile : iFiles) {
                if (ModelEditorManager.isOpen((IFile)theFile) && ModelEditorManager.getModelEditorForFile((IFile)theFile, (boolean)false).isDirty()) {
                    askedQuestion = true;
                    boolean confirm = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)CONFIRM_DIRTY_MODELS_DIALOG_TITLE, (String)CONFIRM_DIRTY_MODELS_DIALOG_MESSAGE);
                    okIfModelsDirty = confirm;
                }
                if (askedQuestion) break;
            }
            boolean bl = hasDataRoles = !VdbEditor.this.getVdb().getDataRoles().isEmpty();
            if (okIfModelsDirty && showWarningDialog) {
                if (hasDataRoles) {
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)Display.getCurrent().getActiveShell(), (String)CONFIRM_DIALOG_TITLE, (String)CONFIRM_SYNCHRONIZE_MESSAGE, (String)VdbUiConstants.Util.getString("rememberMyDecision", new Object[0]), (boolean)false, null, null);
                    if (dialog.getReturnCode() == 0) {
                        synchronize = true;
                        if (dialog.getToggleState()) {
                            try {
                                prefStore.setValue("synchronizeWithoutWarning", true);
                                VdbUiPlugin.singleton.getPreferences().flush();
                            }
                            catch (BackingStoreException e) {
                                VdbUiConstants.Util.log((Throwable)e);
                            }
                        }
                    }
                } else {
                    synchronize = true;
                }
            }
            if (okIfModelsDirty && synchronize) {
                final Exception[] failureException = new Exception[1];
                UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            element.synchronize();
                        }
                        catch (Exception ex) {
                            failureException[0] = ex;
                            return;
                        }
                        (this).VdbEditor.this.dataRoleResolver.modelSynchronized(element);
                        VdbEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                        (this).VdbEditor.this.showImportVdbsButton.setEnabled(!VdbEditor.this.getVdb().getImports().isEmpty());
                    }
                });
                if (failureException[0] != null) {
                    ErrorHandler.toExceptionDialog((Throwable)failureException[0]);
                }
            }
        }
    };
    private final ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            int ndx = selection.length;
            while (--ndx >= 0) {
                if (!(selection[ndx] instanceof IContainer)) continue;
                return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_INVALID_SELECTION_MESSAGE, null);
            }
            return new Status(0, "org.teiid.designer.vdb.ui", 0, "", null);
        }
    };
    private final ISelectionStatusValidator modelSelectionValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            int ndx = selection.length;
            while (--ndx >= 0) {
                Object obj = selection[ndx];
                if (obj instanceof IContainer) {
                    return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_INVALID_SELECTION_MESSAGE, null);
                }
                if (!(obj instanceof IFile)) continue;
                IFile file = (IFile)obj;
                if (!ModelUtilities.isModelFile((IResource)file) && !ModelUtil.isXsdFile((IResource)file)) {
                    return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_NON_MODEL_SELECTED_MESSAGE, null);
                }
                ModelUtilities.isVdbSourceModel((IFile)file);
                if (ModelUtil.isXsdFile((IResource)file) || !VdbUtil.modelAlreadyExistsInVdb((String)FileUtils.getNameWithoutExtension((IResource)file), (IPath)file.getFullPath(), (Vdb)VdbEditor.this.getVdb())) continue;
                return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_MODEL_WITH_SAME_NAME_EXISTS_SELECTED_MESSAGE, null);
            }
            return new Status(0, "org.teiid.designer.vdb.ui", 0, "", null);
        }
    };
    private final ISelectionStatusValidator schemaSelectionValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            int ndx = selection.length;
            while (--ndx >= 0) {
                Object obj = selection[ndx];
                if (obj instanceof IContainer) {
                    return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_INVALID_SELECTION_MESSAGE, null);
                }
                if (!(obj instanceof IFile)) continue;
                IFile file = (IFile)obj;
                if (!ModelUtil.isXsdFile((IResource)file)) {
                    return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_NON_MODEL_SELECTED_MESSAGE, null);
                }
                if (!VdbUtil.modelAlreadyExistsInVdb((String)FileUtils.getNameWithoutExtension((IResource)file), (IPath)file.getFullPath(), (Vdb)VdbEditor.this.getVdb())) continue;
                return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_MODEL_WITH_SAME_NAME_EXISTS_SELECTED_MESSAGE, null);
            }
            return new Status(0, "org.teiid.designer.vdb.ui", 0, "", null);
        }
    };

    static String i18n(String id) {
        return VdbUiConstants.Util.getString(id, new Object[0]);
    }

    public void addModels(List<IFile> modelFiles) {
        try {
            for (IFile modelFile : modelFiles) {
                this.vdb.addEntry(modelFile.getFullPath());
            }
        }
        catch (Exception ex) {
            ErrorHandler.toExceptionDialog((Throwable)ex);
        }
        this.modelsGroup.getTable().getViewer().refresh();
        this.pnlTranslatorOverrides.refresh();
        this.packModelsGroup();
        this.showImportVdbsButton.setEnabled(!this.getVdb().getImports().isEmpty());
        this.schemaGroup.getTable().getViewer().refresh();
        this.udfJarsGroup.getTable().getViewer().refresh();
        this.otherFilesGroup.getTable().getViewer().refresh();
    }

    void packModelsGroup() {
        this.modelsGroup.getTable().getColumn(1).getColumn().setWidth(50);
        this.modelsGroup.getTable().getColumn(2).getColumn().setWidth(50);
        Rectangle area = this.modelsGroup.getTable().getViewer().getTable().getClientArea();
        int totalAreaWidth = area.width;
        int col1Width = totalAreaWidth - 50 - 50;
        if (col1Width < 200) {
            col1Width = 200;
        }
        this.modelsGroup.getTable().getColumn(0).getColumn().setWidth(col1Width);
    }

    private Composite createEditorBottom(Composite parent) {
        Composite pnlBottom = new Composite(parent, 2048);
        pnlBottom.setLayout((Layout)new GridLayout());
        pnlBottom.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabFolder tabFolder = WidgetFactory.createTabFolder((Composite)pnlBottom);
        CTabItem theTab = new CTabItem(tabFolder, 0);
        theTab.setText(VdbEditor.i18n("rolesTab"));
        theTab.setToolTipText(VdbEditor.i18n("rolesTabToolTip"));
        Composite tabPanel = new Composite((Composite)tabFolder, 0);
        tabPanel.setLayout((Layout)new GridLayout());
        tabPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        theTab.setControl((Control)tabPanel);
        this.dataRolesPanel = new DataRolesPanel(tabPanel, this);
        theTab.setControl((Control)tabPanel);
        tabPanel.layout();
        theTab = new CTabItem(tabFolder, 0);
        theTab.setText(VdbEditor.i18n("propertiesTab"));
        theTab.setToolTipText(VdbEditor.i18n("propertiesTabToolTip"));
        tabPanel = new Composite((Composite)tabFolder, 0);
        tabPanel.setLayout((Layout)new GridLayout());
        tabPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        theTab.setControl((Control)tabPanel);
        this.propertiesPanel = new PropertiesPanel(tabPanel, this.getVdb());
        theTab.setControl((Control)tabPanel);
        tabPanel.layout();
        theTab = new CTabItem(tabFolder, 0);
        theTab.setText(VdbEditor.i18n("userDefinedPropertiesTab"));
        theTab.setToolTipText(VdbEditor.i18n("userDefinedPropertiesTabToolTip"));
        tabPanel = new Composite((Composite)tabFolder, 0);
        tabPanel.setLayout((Layout)new GridLayout());
        tabPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        theTab.setControl((Control)tabPanel);
        this.userDefinedPropertiesPanel = new UserDefinedPropertiesPanel(tabPanel, this.getVdb());
        theTab.setControl((Control)tabPanel);
        tabPanel.layout();
        theTab = new CTabItem(tabFolder, 0);
        theTab.setText(VdbEditor.i18n("translatorOverridesTab"));
        theTab.setToolTipText(VdbEditor.i18n("translatorOverridesTabToolTip"));
        this.pnlTranslatorOverrides = new TranslatorOverridesPanel((Composite)tabFolder, this.vdb);
        theTab.setControl((Control)this.pnlTranslatorOverrides);
        this.pnlTranslatorOverrides.layout();
        tabFolder.setSelection(0);
        return pnlBottom;
    }

    void addSelectionToVdb(VdbHelper.VdbFolders vdbFolder, TableViewer tableViewer, String confirmOverwriteMessage) {
        IProject vdbProject;
        Shell shell = Display.getCurrent().getActiveShell();
        String fileStr = VdbFileDialogUtil.selectFile((Shell)shell, (IProject)(vdbProject = this.getVdb().getSourceFile().getProject()), (VdbHelper.VdbFolders)vdbFolder);
        if (fileStr == null || fileStr.trim().isEmpty()) {
            return;
        }
        boolean firstTime = tableViewer.getTable().getItemCount() == 0;
        try {
            Path filePath = null;
            File testFile = new File(fileStr);
            if (testFile.exists()) {
                filePath = new Path(testFile.getAbsolutePath());
            } else {
                IFile file = vdbProject.getFile((IPath)new Path(fileStr));
                if (file == null) {
                    throw new Exception("File " + fileStr + " is not available to be added to the vdb");
                }
                filePath = file.getProjectRelativePath();
            }
            String fileName = filePath.lastSegment();
            Collection currentFiles = this.getVdb().getEntries();
            if (this.entrySetContainsName(currentFiles, fileName)) {
                if (ConfirmationDialog.confirm(new ConfirmationDialog(confirmOverwriteMessage))) {
                    VdbEntry matchingEntry = null;
                    for (VdbEntry entry : currentFiles) {
                        String entryShortName = entry.getPathName();
                        if (!entryShortName.equals(fileName)) continue;
                        matchingEntry = entry;
                        break;
                    }
                    if (matchingEntry != null) {
                        this.getVdb().removeEntry(matchingEntry);
                    }
                    this.getVdb().addEntry((IPath)filePath);
                }
            } else {
                this.getVdb().addEntry((IPath)filePath);
            }
        }
        catch (Exception ex) {
            ErrorHandler.toExceptionDialog((Throwable)ex);
        }
        tableViewer.refresh();
        if (firstTime) {
            WidgetUtil.pack((TableViewer)tableViewer);
        }
    }

    void addSchemaToVdb(IStructuredSelection selection) {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IContainer) {
                    IProject proj = ((IContainer)element).getProject();
                    IProject vdbProject = VdbEditor.this.getVdb().getSourceFile().getProject();
                    return proj.isOpen() && proj.equals((Object)vdbProject);
                }
                IFile file = (IFile)element;
                if (!ModelUtil.isXsdFile((IResource)file)) {
                    return false;
                }
                for (VdbSchemaEntry schemaEntry : VdbEditor.this.getVdb().getSchemaEntries()) {
                    if (!file.equals((Object)schemaEntry.findFileInWorkspace())) continue;
                    return false;
                }
                return true;
            }
        };
        ModelingResourceFilter wsFilter = new ModelingResourceFilter(filter);
        wsFilter.setShowHiddenProjects(false);
        Object[] schemas = WidgetUtil.showWorkspaceObjectSelectionDialog((String)ADD_FILE_DIALOG_TITLE, (String)ADD_FILE_DIALOG_MESSAGE, (boolean)true, null, (ViewerFilter)wsFilter, (ISelectionStatusValidator)this.getModelSelectionValidator(), (ILabelProvider)this.getModelLabelProvider());
        try {
            Object[] objectArray = schemas;
            int n = schemas.length;
            int n2 = 0;
            while (n2 < n) {
                Object schema = objectArray[n2];
                this.getVdb().addEntry(((IFile)schema).getFullPath());
                ++n2;
            }
        }
        catch (Exception ex) {
            ErrorHandler.toExceptionDialog((Throwable)ex);
        }
        this.schemaGroup.getTable().getViewer().refresh();
    }

    private void createSchemaFilesControl(Composite parent) {
        final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        this.schemaGroup = new TableAndToolBar(parent, 1, (TableProvider)new DefaultTableProvider<VdbSchemaEntry>(){

            public void doubleClicked(VdbSchemaEntry element) {
                this.openEditor(element);
            }

            public VdbSchemaEntry[] getElements() {
                Set schemaEntries = VdbEditor.this.getVdb().getSchemaEntries();
                return schemaEntries.toArray(new VdbSchemaEntry[schemaEntries.size()]);
            }

            public boolean isDoubleClickSupported() {
                return false;
            }

            void openEditor(VdbSchemaEntry entry) {
                try {
                    IDE.openEditor((IWorkbenchPage)UiUtil.getWorkbenchPage(), (IFile)entry.findFileInWorkspace());
                }
                catch (Exception error) {
                    throw new RuntimeException(error);
                }
            }
        }, new ColumnProvider[]{new TextColumnProvider<VdbSchemaEntry>(){

            public Image getImage(VdbSchemaEntry element) {
                return workbenchLabelProvider.getImage((Object)element.findFileInWorkspace());
            }

            public Image getImage() {
                return null;
            }

            public String getName() {
                return SCHEMA_COLUMN_NAME;
            }

            public String getValue(VdbSchemaEntry element) {
                return element.getPathName();
            }
        }, this.locationInVdbColumnProvider, this.descriptionColumnProvider});
        ButtonProvider addProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/add-schema.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return VdbEditor.i18n("addSchemaToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return true;
            }

            public void selected(IStructuredSelection selection) {
                VdbEditor.this.addSchemaToVdb(selection);
            }
        };
        this.schemaGroup.add(addProvider);
        ButtonProvider removeProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/remove-schema.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return VdbEditor.i18n("removeSchemaToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return !selection.isEmpty();
            }

            public void selected(IStructuredSelection selection) {
                if (!ConfirmationDialog.confirm(CONFIRM_REMOVE_MESSAGE)) {
                    return;
                }
                HashSet<VdbEntry> entries = new HashSet<VdbEntry>();
                final HashSet importedBy = new HashSet();
                for (Object element : selection.toList()) {
                    entries.add((VdbEntry)element);
                    if (!(element instanceof VdbModelEntry)) continue;
                    importedBy.addAll(((VdbModelEntry)element).getImportedBy());
                }
                if (!importedBy.isEmpty()) {
                    importedBy.removeAll(entries);
                }
                if (!importedBy.isEmpty()) {
                    if (!ConfirmationDialog.confirm(new ConfirmationDialog(CONFIRM_REMOVE_IMPORTED_BY_MESSAGE){

                        protected Control createCustomArea(Composite parent) {
                            ListViewer viewer = new ListViewer(parent);
                            viewer.setContentProvider((IContentProvider)new DefaultContentProvider());
                            viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                                public String getText(Object element) {
                                    return ((VdbEntry)element).getName().toString();
                                }
                            });
                            viewer.getList().setLayoutData((Object)new GridData(4, 4, true, true));
                            viewer.setInput((Object)importedBy);
                            return viewer.getControl();
                        }
                    })) {
                        return;
                    }
                    entries.addAll(importedBy);
                }
                VdbEditor.this.dataRoleResolver.modelEntriesRemoved(entries);
                for (VdbEntry entry : entries) {
                    VdbEditor.this.getVdb().removeEntry(entry);
                }
                VdbEditor.this.showImportVdbsButton.setEnabled(!VdbEditor.this.getVdb().getImports().isEmpty());
            }
        };
        this.schemaGroup.add(removeProvider);
    }

    private void createUdfJarsControl(Composite parent) {
        final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        this.udfJarsGroup = new TableAndToolBar(parent, 1, (TableProvider)new DefaultTableProvider<VdbEntry>(){

            public void doubleClicked(VdbEntry element) {
                this.openEditor(element);
            }

            public VdbEntry[] getElements() {
                Set udfJarEntries = VdbEditor.this.getVdb().getUdfJarEntries();
                return (VdbEntry[])udfJarEntries.toArray(new VdbFileEntry[udfJarEntries.size()]);
            }

            public boolean isDoubleClickSupported() {
                return false;
            }

            void openEditor(VdbEntry entry) {
                try {
                    IDE.openEditor((IWorkbenchPage)UiUtil.getWorkbenchPage(), (IFile)entry.findFileInWorkspace());
                }
                catch (Exception error) {
                    throw new RuntimeException(error);
                }
            }
        }, new ColumnProvider[]{new TextColumnProvider<VdbEntry>(){

            public Image getImage(VdbEntry element) {
                Image img = workbenchLabelProvider.getImage((Object)element.findFileInWorkspace());
                if (img == null) {
                    img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
                return img;
            }

            public Image getImage() {
                return null;
            }

            public String getName() {
                return FILE_COLUMN_NAME;
            }

            public String getValue(VdbEntry element) {
                return element.getPathName();
            }
        }, this.locationInVdbColumnProvider, this.descriptionColumnProvider});
        ButtonProvider addProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/add-file.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return VdbEditor.i18n("addUdfJarToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return true;
            }

            public void selected(IStructuredSelection selection) {
                VdbEditor.this.addSelectionToVdb(VdbHelper.VdbFolders.UDF, VdbEditor.this.udfJarsGroup.getTable().getViewer(), CONFIRM_OVERWRITE_UDFJAR_MESSAGE);
            }
        };
        this.udfJarsGroup.add(addProvider);
        ButtonProvider removeProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/remove-file.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return VdbEditor.i18n("removeUdfJarToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return !selection.isEmpty();
            }

            public void selected(IStructuredSelection selection) {
                if (!ConfirmationDialog.confirm(CONFIRM_REMOVE_MESSAGE)) {
                    return;
                }
                HashSet<VdbEntry> entries = new HashSet<VdbEntry>();
                final HashSet importedBy = new HashSet();
                for (Object element : selection.toList()) {
                    entries.add((VdbEntry)element);
                    if (!(element instanceof VdbModelEntry)) continue;
                    importedBy.addAll(((VdbModelEntry)element).getImportedBy());
                }
                if (!importedBy.isEmpty()) {
                    importedBy.removeAll(entries);
                }
                if (!importedBy.isEmpty()) {
                    if (!ConfirmationDialog.confirm(new ConfirmationDialog(CONFIRM_REMOVE_IMPORTED_BY_MESSAGE){

                        protected Control createCustomArea(Composite parent) {
                            ListViewer viewer = new ListViewer(parent);
                            viewer.setContentProvider((IContentProvider)new DefaultContentProvider());
                            viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                                public String getText(Object element) {
                                    return ((VdbEntry)element).getName().toString();
                                }
                            });
                            viewer.getList().setLayoutData((Object)new GridData(4, 4, true, true));
                            viewer.setInput((Object)importedBy);
                            return viewer.getControl();
                        }
                    })) {
                        return;
                    }
                    entries.addAll(importedBy);
                }
                VdbEditor.this.dataRoleResolver.modelEntriesRemoved(entries);
                for (VdbEntry entry : entries) {
                    VdbEditor.this.getVdb().removeEntry(entry);
                }
                VdbEditor.this.showImportVdbsButton.setEnabled(!VdbEditor.this.getVdb().getImports().isEmpty());
            }
        };
        this.udfJarsGroup.add(removeProvider);
    }

    private void createOtherFilesControl(Composite parent) {
        final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        this.otherFilesGroup = new TableAndToolBar(parent, 1, (TableProvider)new DefaultTableProvider<VdbEntry>(){

            public void doubleClicked(VdbEntry element) {
                this.openEditor(element);
            }

            public VdbEntry[] getElements() {
                Set userFileEntries = VdbEditor.this.getVdb().getUserFileEntries();
                return (VdbEntry[])userFileEntries.toArray(new VdbFileEntry[userFileEntries.size()]);
            }

            public boolean isDoubleClickSupported() {
                return false;
            }

            void openEditor(VdbEntry entry) {
                try {
                    IDE.openEditor((IWorkbenchPage)UiUtil.getWorkbenchPage(), (IFile)entry.findFileInWorkspace());
                }
                catch (Exception error) {
                    throw new RuntimeException(error);
                }
            }
        }, new ColumnProvider[]{new TextColumnProvider<VdbEntry>(){

            public Image getImage(VdbEntry element) {
                Image img = workbenchLabelProvider.getImage((Object)element.findFileInWorkspace());
                if (img == null) {
                    img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
                return img;
            }

            public Image getImage() {
                return null;
            }

            public String getName() {
                return FILE_COLUMN_NAME;
            }

            public String getValue(VdbEntry element) {
                return element.getPathName();
            }
        }, this.locationInVdbColumnProvider, this.descriptionColumnProvider});
        ButtonProvider addProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/add-file.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return VdbEditor.i18n("addFileToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return true;
            }

            public void selected(IStructuredSelection selection) {
                VdbEditor.this.addSelectionToVdb(VdbHelper.VdbFolders.OTHER_FILES, VdbEditor.this.otherFilesGroup.getTable().getViewer(), CONFIRM_OVERWRITE_USERFILE_MESSAGE);
            }
        };
        this.otherFilesGroup.add(addProvider);
        ButtonProvider removeProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/remove-file.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return VdbEditor.i18n("removeFileToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return !selection.isEmpty();
            }

            public void selected(IStructuredSelection selection) {
                if (!ConfirmationDialog.confirm(CONFIRM_REMOVE_MESSAGE)) {
                    return;
                }
                HashSet<VdbEntry> entries = new HashSet<VdbEntry>();
                final HashSet importedBy = new HashSet();
                for (Object element : selection.toList()) {
                    entries.add((VdbEntry)element);
                    if (!(element instanceof VdbModelEntry)) continue;
                    importedBy.addAll(((VdbModelEntry)element).getImportedBy());
                }
                if (!importedBy.isEmpty()) {
                    importedBy.removeAll(entries);
                }
                if (!importedBy.isEmpty()) {
                    if (!ConfirmationDialog.confirm(new ConfirmationDialog(CONFIRM_REMOVE_IMPORTED_BY_MESSAGE){

                        protected Control createCustomArea(Composite parent) {
                            ListViewer viewer = new ListViewer(parent);
                            viewer.setContentProvider((IContentProvider)new DefaultContentProvider());
                            viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                                public String getText(Object element) {
                                    return ((VdbEntry)element).getName().toString();
                                }
                            });
                            viewer.getList().setLayoutData((Object)new GridData(4, 4, true, true));
                            viewer.setInput((Object)importedBy);
                            return viewer.getControl();
                        }
                    })) {
                        return;
                    }
                    entries.addAll(importedBy);
                }
                VdbEditor.this.dataRoleResolver.modelEntriesRemoved(entries);
                for (VdbEntry entry : entries) {
                    VdbEditor.this.getVdb().removeEntry(entry);
                }
                VdbEditor.this.showImportVdbsButton.setEnabled(!VdbEditor.this.getVdb().getImports().isEmpty());
            }
        };
        this.otherFilesGroup.add(removeProvider);
    }

    boolean entrySetContainsName(Collection<VdbEntry> entries, String shortName) {
        ArrayList<String> currentNames = new ArrayList<String>(entries.size());
        for (VdbEntry entry : entries) {
            String entryName = entry.getPathName();
            currentNames.add(entryName);
        }
        return currentNames.contains(shortName);
    }

    private void createErrorPanel(Composite parent) {
        Color bgColour = parent.getDisplay().getSystemColor(25);
        parent.setBackground(bgColour);
        final Composite errorPanel = WidgetFactory.createPanel((Composite)parent, (int)0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)errorPanel);
        Composite imgMsgPanel = WidgetFactory.createPanel((Composite)errorPanel);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(imgMsgPanel);
        Label imageLabel = WidgetFactory.createLabel((Composite)imgMsgPanel, (int)0);
        imageLabel.setBackground(bgColour);
        Image image = parent.getDisplay().getSystemImage(1);
        if (image != null) {
            image.setBackground(bgColour);
            imageLabel.setImage(image);
            GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)imageLabel);
        }
        Label errLabel = WidgetFactory.createLabel((Composite)imgMsgPanel, (String)Messages.vdbEditor_loadingErrMessage);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)errLabel);
        final Button detailsButton = WidgetFactory.createButton((Composite)errorPanel, (int)8);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)detailsButton);
        detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        detailsButton.setData((Object)Boolean.FALSE);
        final Composite detailsComposite = WidgetFactory.createPanel((Composite)errorPanel);
        GridDataFactory.defaultsFor((Control)detailsComposite).applyTo((Control)detailsComposite);
        GridLayoutFactory.fillDefaults().margins(25, 25).applyTo(detailsComposite);
        detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Boolean.TRUE.equals(detailsButton.getData())) {
                    Control[] controlArray = detailsComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                    detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
                    detailsButton.setData((Object)Boolean.FALSE);
                } else {
                    String trace = CoreStringUtil.getStackTrace((Throwable)VdbEditor.this.vdbLoadingException);
                    Text exceptionText = WidgetFactory.createTextBox((Composite)detailsComposite, (int)8, (int)4, (int)1, (String)trace);
                    GridDataFactory.fillDefaults().grab(true, true).hint(200, 400).applyTo((Control)exceptionText);
                    detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
                    detailsButton.setData((Object)Boolean.TRUE);
                }
                errorPanel.layout(true);
                errorPanel.getParent().layout(true);
            }
        });
        detailsButton.setVisible(this.vdbLoadingException != null);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData());
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridLayoutFactory.fillDefaults().equalWidth(false).applyTo((Composite)scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, false);
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(768));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        ((GridData)mainPanel.getLayoutData()).minimumWidth = 400;
        ((GridData)mainPanel.getLayoutData()).minimumHeight = 400;
        if (this.vdb == null) {
            this.createErrorPanel(mainPanel);
            return;
        }
        Composite headerPanel = WidgetFactory.createPanel((Composite)mainPanel, (int)0, (int)4, (int)1, (int)6);
        Label projectLabel = new Label(headerPanel, 0);
        projectLabel.setText(Messages.vdbEditor_location);
        Label project = new Label(headerPanel, 0);
        project.setText(this.vdb.getSourceFile().getParent().getFullPath().toString());
        project.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        Color blueColor = Display.getCurrent().getSystemColor(10);
        Label label1 = WidgetFactory.createLabel((Composite)headerPanel, (String)("  " + VdbEditor.i18n("lastValidated") + " : "));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)label1);
        String dateTimeString = VdbEditor.i18n("undefined");
        if (this.getVdb().getValidationDateTime() != null) {
            dateTimeString = this.getVdb().getValidationDateTime().toString();
        }
        this.validationDateTimeLabel = WidgetFactory.createLabel((Composite)headerPanel, (String)dateTimeString);
        this.validationDateTimeLabel.setForeground(blueColor);
        this.validationDateTimeLabel.setText(dateTimeString);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.validationDateTimeLabel);
        Label label3 = WidgetFactory.createLabel((Composite)headerPanel, (String)("    " + VdbEditor.i18n("teiidRuntimeVersion") + " : "));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)label3);
        String versionString = VdbEditor.i18n("undefined");
        if (this.getVdb().getValidationVersion() != null) {
            versionString = this.getVdb().getValidationVersion();
        }
        this.validationVersionLabel = WidgetFactory.createLabel((Composite)headerPanel, (String)versionString);
        this.validationVersionLabel.setForeground(blueColor);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.validationVersionLabel);
        this.addSynchronizePanel(headerPanel);
        CTabFolder tabFolder = WidgetFactory.createTabFolder((Composite)mainPanel);
        tabFolder.setTabPosition(1024);
        CTabItem leftTab = new CTabItem(tabFolder, 0);
        leftTab.setText(Messages.vdbEditor_content_tab_label);
        leftTab.setToolTipText(Messages.vdbEditor_content_tab_tooltip);
        Composite leftPanel = this.createEditorTop((Composite)tabFolder);
        leftTab.setControl((Control)leftPanel);
        CTabItem rightTab = new CTabItem(tabFolder, 0);
        rightTab.setText(Messages.vdbEditor_advanced_tab_label);
        rightTab.setToolTipText(Messages.vdbEditor_advanced_tab_tooltip);
        Composite rightPanel = this.createEditorBottom((Composite)tabFolder);
        rightTab.setControl((Control)rightPanel);
        tabFolder.setSelection(0);
        ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.showImportVdbsButton.setEnabled(!this.getVdb().getImports().isEmpty());
        scrolledComposite.sizeScrolledPanel();
    }

    private void addSynchronizePanel(Composite parent) {
        Composite extraButtonPanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2, (int)2);
        extraButtonPanel.setLayout((Layout)new GridLayout(6, false));
        Label vdbVersionLabel = WidgetFactory.createLabel((Composite)extraButtonPanel, (String)"Version");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)vdbVersionLabel);
        final Text vdbVersionText = WidgetFactory.createTextField((Composite)extraButtonPanel);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)vdbVersionText);
        ((GridData)vdbVersionText.getLayoutData()).widthHint = 30;
        vdbVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int versionValue = Integer.parseInt(vdbVersionText.getText());
                    if (versionValue > -1) {
                        VdbEditor.this.getVdb().setVersion(versionValue);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)INVALID_INTEGER_INPUT_TITLE, (String)INVALID_INTEGER_INPUT_MESSAGE);
                    vdbVersionText.setText(Integer.toString(VdbEditor.this.getVdb().getVersion()));
                }
            }
        });
        vdbVersionText.setText(Integer.toString(this.getVdb().getVersion()));
        this.synchronizeAllButton = WidgetFactory.createButton((Composite)extraButtonPanel, (String)VdbEditor.i18n("synchronizeAllButton"), (int)32);
        this.synchronizeAllButton.setToolTipText(VdbEditor.i18n("synchronizeAllButtonToolTip"));
        this.synchronizeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean hasDataRoles;
                IPreferenceStore prefStore = VdbUiPlugin.singleton.getPreferenceStore();
                boolean showWarningDialog = "".equals(prefStore.getString("synchronizeWithoutWarning")) ? true : !prefStore.getBoolean("synchronizeWithoutWarning");
                boolean synchronize = !showWarningDialog;
                boolean okIfModelsDirty = true;
                Collection iFiles = VdbUtil.getVdbModels((Vdb)VdbEditor.this.getVdb());
                boolean askedQuestion = false;
                for (IFile theFile : iFiles) {
                    if (ModelEditorManager.isOpen((IFile)theFile) && ModelEditorManager.getModelEditorForFile((IFile)theFile, (boolean)false).isDirty()) {
                        askedQuestion = true;
                        boolean confirm = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)CONFIRM_DIRTY_MODELS_DIALOG_TITLE, (String)CONFIRM_DIRTY_MODELS_DIALOG_MESSAGE);
                        okIfModelsDirty = confirm;
                    }
                    if (askedQuestion) break;
                }
                boolean bl = hasDataRoles = !VdbEditor.this.getVdb().getDataRoles().isEmpty();
                if (okIfModelsDirty && showWarningDialog) {
                    if (hasDataRoles) {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)Display.getCurrent().getActiveShell(), (String)CONFIRM_DIALOG_TITLE, (String)CONFIRM_SYNCHRONIZE_ALL_MESSAGE, (String)VdbUiConstants.Util.getString("rememberMyDecision", new Object[0]), (boolean)false, null, null);
                        if (dialog.getReturnCode() == 0) {
                            synchronize = true;
                            if (dialog.getToggleState()) {
                                try {
                                    prefStore.setValue("synchronizeWithoutWarning", true);
                                    VdbUiPlugin.singleton.getPreferences().flush();
                                }
                                catch (BackingStoreException e) {
                                    VdbUiConstants.Util.log((Throwable)e);
                                }
                            }
                        }
                    } else {
                        synchronize = true;
                    }
                }
                if (okIfModelsDirty && synchronize) {
                    final Exception[] finalException = new Exception[1];
                    UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                VdbEditor.this.getVdb().synchronize();
                            }
                            catch (Exception ex) {
                                finalException[0] = ex;
                                return;
                            }
                            (this).VdbEditor.this.modelsGroup.getTable().getViewer().refresh();
                            (this).VdbEditor.this.schemaGroup.getTable().getViewer().refresh();
                            (this).VdbEditor.this.otherFilesGroup.getTable().getViewer().refresh();
                            (this).VdbEditor.this.pnlTranslatorOverrides.refresh();
                            (this).VdbEditor.this.dataRoleResolver.allSynchronized();
                            VdbEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                            (this).VdbEditor.this.showImportVdbsButton.setEnabled(!VdbEditor.this.getVdb().getImports().isEmpty());
                            (this).VdbEditor.this.modelDetailsPanel.refreshModelDetails();
                        }
                    });
                    if (finalException[0] != null) {
                        ErrorHandler.toExceptionDialog((Throwable)finalException[0]);
                    }
                }
            }
        });
        this.synchronizeAllButton.setEnabled(!this.vdb.isSynchronized());
        this.showImportVdbsButton = WidgetFactory.createButton((Composite)extraButtonPanel, (String)"Show Import VDBs", (int)32);
        this.showImportVdbsButton.setToolTipText(VdbEditor.i18n("synchronizeAllButtonToolTip"));
        this.showImportVdbsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ShowImportVdbsDialog dialog = new ShowImportVdbsDialog(Display.getCurrent().getActiveShell(), VdbEditor.this.getVdb());
                dialog.open();
            }
        });
        this.showImportVdbsButton.setEnabled(!this.getVdb().getImports().isEmpty());
    }

    private Composite createEditorTop(Composite parent) {
        Composite pnlTop = new Composite(parent, 2048);
        pnlTop.setLayout((Layout)new GridLayout());
        pnlTop.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabFolder tabFolder = WidgetFactory.createTabFolder((Composite)pnlTop);
        CTabItem modelsTab = new CTabItem(tabFolder, 0);
        modelsTab.setText(VdbEditor.i18n("modelsTab"));
        modelsTab.setToolTipText(VdbEditor.i18n("modelsTabToolTip"));
        Composite pnlModels = new Composite((Composite)tabFolder, 0);
        pnlModels.setLayout((Layout)new GridLayout(1, false));
        pnlModels.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm splitter = new SashForm(pnlModels, 256);
        splitter.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite pnlModelsList = new Composite((Composite)splitter, 0);
        pnlModelsList.setLayout((Layout)new GridLayout());
        pnlModelsList.setLayoutData((Object)new GridData(4, 4, false, true));
        ((GridData)pnlModelsList.getLayoutData()).widthHint = 300;
        this.createModelsSection(pnlModelsList);
        this.modelDetailsPanel = new ModelDetailsPanel((Composite)splitter, this.getVdb());
        splitter.setWeights(new int[]{35, 65});
        modelsTab.setControl((Control)pnlModels);
        CTabItem schemaTab = new CTabItem(tabFolder, 0);
        schemaTab.setText(VdbEditor.i18n("schemaTab"));
        schemaTab.setToolTipText(VdbEditor.i18n("schemaTabToolTip"));
        Composite pnlFiles = new Composite((Composite)tabFolder, 0);
        pnlFiles.setLayout((Layout)new GridLayout());
        pnlFiles.setLayoutData((Object)new GridData(4, 4, true, true));
        schemaTab.setControl((Control)pnlFiles);
        this.createSchemaFilesControl(pnlFiles);
        CTabItem filesTab = new CTabItem(tabFolder, 0);
        filesTab.setText(VdbEditor.i18n("udfJarsTab"));
        filesTab.setToolTipText(VdbEditor.i18n("udfJarsTabToolTip"));
        pnlFiles = new Composite((Composite)tabFolder, 0);
        pnlFiles.setLayout((Layout)new GridLayout());
        pnlFiles.setLayoutData((Object)new GridData(4, 4, true, true));
        filesTab.setControl((Control)pnlFiles);
        this.createUdfJarsControl(pnlFiles);
        filesTab = new CTabItem(tabFolder, 0);
        filesTab.setText(VdbEditor.i18n("filesTab"));
        filesTab.setToolTipText(VdbEditor.i18n("filesTabToolTip"));
        pnlFiles = new Composite((Composite)tabFolder, 0);
        pnlFiles.setLayout((Layout)new GridLayout());
        pnlFiles.setLayoutData((Object)new GridData(4, 4, true, true));
        filesTab.setControl((Control)pnlFiles);
        this.createOtherFilesControl(pnlFiles);
        CTabItem descriptionTab = new CTabItem(tabFolder, 0);
        descriptionTab.setText(VdbEditor.i18n("descriptionTab"));
        descriptionTab.setToolTipText(VdbEditor.i18n("descriptionTabToolTip"));
        Composite pnlDescription = new Composite((Composite)tabFolder, 0);
        pnlDescription.setLayout((Layout)new GridLayout());
        pnlDescription.setLayoutData((Object)new GridData(4, 4, true, true));
        descriptionTab.setControl((Control)pnlDescription);
        this.descriptionPanel = new DescriptionPanel(pnlDescription, this.getVdb());
        this.schemaGroup.setInput((Object)this.vdb);
        this.udfJarsGroup.setInput((Object)this.vdb);
        this.otherFilesGroup.setInput((Object)this.vdb);
        tabFolder.setSelection(0);
        return pnlTop;
    }

    private void createModelsSection(Composite parent) {
        this.modelsGroup = new TableAndToolBar(parent, 68354, 1, (TableProvider)new DefaultTableProvider<VdbModelEntry>(){

            public void doubleClicked(VdbModelEntry element) {
                VdbEditor.this.openEditor((VdbEntry)element);
            }

            public VdbModelEntry[] getElements() {
                Set modelEntries = VdbEditor.this.getVdb().getModelEntries();
                return modelEntries.toArray(new VdbModelEntry[modelEntries.size()]);
            }

            public boolean isDoubleClickSupported() {
                return true;
            }
        }, new ColumnProvider[]{new TextColumnProvider<VdbModelEntry>(){

            public Image getImage(VdbModelEntry element) {
                return ModelIdentifier.getModelImage((IResource)element.findFileInWorkspace());
            }

            public String getName() {
                return MODEL_COLUMN_NAME;
            }

            public Image getImage() {
                return null;
            }

            public String getValue(VdbModelEntry element) {
                return element.getPathName();
            }
        }, this.syncColumnProvider, new CheckBoxColumnProvider<VdbModelEntry>(){

            public String getName() {
                return null;
            }

            public Image getImage() {
                return VdbUiPlugin.singleton.getImage("icons/full/cview16/visible.gif");
            }

            public String getToolTip(VdbModelEntry element) {
                return element.isVisible() ? VISIBLE_TOOLTIP : NOT_VISIBLE_TOOLTIP;
            }

            public Boolean getValue(VdbModelEntry element) {
                return element.isVisible();
            }

            public boolean isEditable(VdbModelEntry element) {
                return true;
            }

            public void setValue(VdbModelEntry element, Boolean value) {
                element.setVisible(value.booleanValue());
            }
        }});
        ButtonProvider addProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/add-model.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return VdbEditor.i18n("addModelToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return true;
            }

            public void selected(IStructuredSelection selection) {
                boolean proceed;
                boolean firstTime;
                Object[] models;
                block15: {
                    ViewerFilter filter = new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parent, Object element) {
                            if (element instanceof IContainer) {
                                IProject proj = ((IContainer)element).getProject();
                                IProject vdbProject = VdbEditor.this.getVdb().getSourceFile().getProject();
                                return proj.isOpen() && proj.equals((Object)vdbProject);
                            }
                            IFile file = (IFile)element;
                            if (!ModelUtilities.isModelFile((IResource)file) || ModelUtilities.isVdbSourceModel((IFile)file)) {
                                return false;
                            }
                            if (ModelUtil.isXsdFile((IResource)file)) {
                                return false;
                            }
                            for (VdbEntry modelEntry : VdbEditor.this.getVdb().getModelEntries()) {
                                if (!file.equals((Object)modelEntry.findFileInWorkspace())) continue;
                                return false;
                            }
                            return true;
                        }
                    };
                    ModelingResourceFilter wsFilter = new ModelingResourceFilter(filter);
                    wsFilter.setShowHiddenProjects(false);
                    models = WidgetUtil.showWorkspaceObjectSelectionDialog((String)ADD_FILE_DIALOG_TITLE, (String)ADD_FILE_DIALOG_MESSAGE, (boolean)true, null, (ViewerFilter)wsFilter, (ISelectionStatusValidator)VdbEditor.this.getModelSelectionValidator(), (ILabelProvider)VdbEditor.this.getModelLabelProvider());
                    if (!VdbEditor.this.getVdb().getDataRoles().isEmpty()) {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)CONFIRM_DIALOG_TITLE, (String)INFORM_DATA_ROLES_ON_ADD_MESSAGE);
                    }
                    firstTime = VdbEditor.this.modelsGroup.getTable().getViewer().getTable().getItemCount() == 0;
                    boolean success = false;
                    boolean foundDuplicateNames = false;
                    proceed = false;
                    try {
                        try {
                            Object model;
                            boolean canAdd;
                            Object[] objectArray = models;
                            if (models.length != 0 && !(canAdd = VdbUtil.canAddModelToVdb((IFile)((IFile)(model = objectArray[0])), (Vdb)VdbEditor.this.getVdb()))) {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)CANNOT_ADD_DUPLICATE_MODEL_NAME_TITLE, (String)CANNOT_ADD_DUPLICATE_MODEL_NAME_MESSAGE);
                                foundDuplicateNames = true;
                            }
                            success = true;
                        }
                        catch (Exception ex) {
                            ErrorHandler.toExceptionDialog((Throwable)ex);
                            if (success) {
                                proceed = !foundDuplicateNames;
                            }
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            proceed = !foundDuplicateNames;
                        }
                        throw throwable;
                    }
                    if (success) {
                        boolean bl = proceed = !foundDuplicateNames;
                    }
                }
                if (proceed) {
                    try {
                        Object[] objectArray = models;
                        int n = models.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object modelFile = objectArray[n2];
                            VdbEditor.this.getVdb().addEntry(((IFile)modelFile).getFullPath());
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        ErrorHandler.toExceptionDialog((Throwable)ex);
                    }
                }
                VdbEditor.this.modelsGroup.getTable().getViewer().refresh();
                VdbEditor.this.pnlTranslatorOverrides.refresh();
                VdbEditor.this.udfJarsGroup.getTable().getViewer().refresh();
                if (firstTime) {
                    VdbEditor.this.packModelsGroup();
                }
                VdbEditor.this.showImportVdbsButton.setEnabled(!VdbEditor.this.getVdb().getImports().isEmpty());
            }
        };
        this.modelsGroup.add(addProvider);
        ButtonProvider removeProvider = new ButtonProvider(){

            public ImageDescriptor getImageDescriptor() {
                return VdbUiPlugin.singleton.getImageDescriptor("icons/full/ctool16/remove-model.png");
            }

            public String getText() {
                return null;
            }

            public String getToolTip() {
                return VdbEditor.i18n("removeModelToolTip");
            }

            public boolean isEnabled(IStructuredSelection selection) {
                return !selection.isEmpty();
            }

            public void selected(IStructuredSelection selection) {
                if (!ConfirmationDialog.confirm(CONFIRM_REMOVE_MESSAGE)) {
                    return;
                }
                HashSet<VdbEntry> entries = new HashSet<VdbEntry>();
                final HashSet importedBy = new HashSet();
                for (Object element : selection.toList()) {
                    entries.add((VdbEntry)element);
                    if (!(element instanceof VdbModelEntry)) continue;
                    importedBy.addAll(((VdbModelEntry)element).getImportedBy());
                }
                if (!importedBy.isEmpty()) {
                    importedBy.removeAll(entries);
                }
                if (!importedBy.isEmpty()) {
                    if (!ConfirmationDialog.confirm(new ConfirmationDialog(CONFIRM_REMOVE_IMPORTED_BY_MESSAGE){

                        protected Control createCustomArea(Composite parent) {
                            ListViewer viewer = new ListViewer(parent);
                            viewer.setContentProvider((IContentProvider)new DefaultContentProvider());
                            viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                                public String getText(Object element) {
                                    return ((VdbEntry)element).getName().toString();
                                }
                            });
                            viewer.getList().setLayoutData((Object)new GridData(4, 4, true, true));
                            viewer.setInput((Object)importedBy);
                            return viewer.getControl();
                        }
                    })) {
                        return;
                    }
                    entries.addAll(importedBy);
                }
                VdbEditor.this.dataRoleResolver.modelEntriesRemoved(entries);
                for (VdbEntry entry : entries) {
                    VdbEditor.this.getVdb().removeEntry(entry);
                }
                VdbEditor.this.udfJarsGroup.getTable().getViewer().refresh();
                VdbEditor.this.showImportVdbsButton.setEnabled(!VdbEditor.this.getVdb().getImports().isEmpty());
            }
        };
        this.modelsGroup.add(removeProvider);
        final TableViewer viewer = this.modelsGroup.getTable().getViewer();
        final MenuManager menuManager = new MenuManager();
        viewer.getControl().setMenu(menuManager.createContextMenu((Control)parent));
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                menuManager.removeAll();
                Object[] actions = SourceHandlerExtensionManager.findApplicableActions((Object)viewer.getSelection());
                if (actions != null) {
                    Object[] objectArray = actions;
                    int n = actions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object action = objectArray[n2];
                        if (action instanceof IAction) {
                            menuManager.add((IAction)action);
                        }
                        ++n2;
                    }
                }
                IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
                VdbModelEntry selectedEntry = null;
                if (sel.getFirstElement() instanceof VdbModelEntry) {
                    selectedEntry = (VdbModelEntry)sel.getFirstElement();
                }
                VdbEditor.this.modelDetailsPanel.setSelectedVdbModelEntry(selectedEntry);
            }
        });
        this.modelsGroup.setInput((Object)this.vdb);
        this.packModelsGroup();
    }

    public void dispose() {
        this.disposed = true;
        if (this.vdb != null) {
            try {
                this.vdb.removeChangeListener(this.vdbListener);
                this.vdb.close();
                if (this.descriptionPanel != null) {
                    this.descriptionPanel.close();
                }
            }
            catch (Exception err) {
                VdbUiConstants.Util.log((Throwable)err);
                WidgetUtil.showError((Throwable)err);
            }
        }
        ModelerCore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.vdb.setValidationDateTime(new Date());
        this.vdb.setValidationVersion(ModelerCore.getTeiidServerVersion().toString());
        try {
            this.vdb.save();
            this.vdb.getSourceFile().getParent().refreshLocal(2, monitor);
        }
        catch (Exception error) {
            VdbUiConstants.Util.log((Throwable)error);
            ErrorHandler.toExceptionDialog((Throwable)error);
        }
    }

    public void doSaveAs() {
    }

    public Vdb getVdb() {
        return this.vdb;
    }

    ModelLabelProvider getModelLabelProvider() {
        return this.modelLabelProvider;
    }

    ISelectionStatusValidator getValidator() {
        return this.validator;
    }

    ISelectionStatusValidator getModelSelectionValidator() {
        return this.modelSelectionValidator;
    }

    ISelectionStatusValidator getSchemaSelectionValidator() {
        return this.schemaSelectionValidator;
    }

    public void init(IEditorSite site, IEditorInput input) {
        IFile file = ((IFileEditorInput)input).getFile();
        try {
            this.vdb = new XmiVdb(file);
            this.vdbListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent event) {
                    UiUtil.runInSwtThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).VdbEditor.this.disposed) {
                                VdbEditor.this.vdbNotification(event.getPropertyName());
                            }
                        }
                    }, (boolean)true);
                }
            };
            this.vdb.addChangeListener(this.vdbListener);
            this.dataRoleResolver = new VdbDataRoleResolver(this.vdb);
        }
        catch (Exception ex) {
            ErrorHandler.toExceptionDialog((Throwable)ex);
            this.vdbLoadingException = ex;
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(file.getName());
    }

    public boolean isDirty() {
        return this.vdb == null ? false : this.vdb.isModified();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    void openEditor(VdbEntry entry) {
        try {
            IFile model = entry.findFileInWorkspace();
            if (model != null) {
                IDE.openEditor((IWorkbenchPage)UiUtil.getWorkbenchPage(), (IFile)model);
            }
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
    }

    public void setFocus() {
    }

    void vdbNotification(String property) {
        if ("closed".equals(property)) {
            return;
        }
        if ("entry.synchronization".equals(property) || "modelEntry.translator".equals(property) || "modelEntry.jndiName".equals(property)) {
            if (!this.modelsGroup.getTable().getViewer().isBusy()) {
                this.modelsGroup.getTable().getViewer().refresh();
            }
            if (!this.schemaGroup.getTable().getViewer().isBusy()) {
                this.schemaGroup.getTable().getViewer().refresh();
            }
            if (!this.udfJarsGroup.getTable().getViewer().isBusy()) {
                this.udfJarsGroup.getTable().getViewer().refresh();
            }
            if (!this.otherFilesGroup.getTable().getViewer().isBusy()) {
                this.otherFilesGroup.getTable().getViewer().refresh();
            }
            this.modelsGroup.getTable().getViewer().getTable().redraw();
            this.modelDetailsPanel.refreshModelDetails();
        }
        if ("dataPolicyAdded".equals(property) || "dataPolicyRemoved".equals(property)) {
            this.dataRolesPanel.refresh();
        }
        boolean syncChanged = false;
        for (VdbEntry entry : this.vdb.getEntries()) {
            if (entry.getSynchronization() != VdbEntry.Synchronization.NotSynchronized) continue;
            syncChanged = true;
            break;
        }
        for (VdbEntry entry : this.vdb.getModelEntries()) {
            if (entry.getSynchronization() != VdbEntry.Synchronization.NotSynchronized) continue;
            syncChanged = true;
            break;
        }
        this.synchronizeAllButton.setEnabled(syncChanged);
        String dateTimeString = VdbEditor.i18n("undefined");
        if (this.getVdb().getValidationDateTime() != null) {
            dateTimeString = this.getVdb().getValidationDateTime().toString();
        }
        this.validationDateTimeLabel.setText(dateTimeString);
        String validationString = VdbEditor.i18n("undefined");
        if (this.getVdb().getValidationVersion() != null) {
            validationString = this.getVdb().getValidationVersion();
        }
        this.validationVersionLabel.setText(validationString);
        this.firePropertyChange(257);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int type = event.getType();
        if (type == 1) {
            try {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            IResource resource = delta.getResource();
                            if (resource.equals((Object)VdbEditor.this.getVdb().getSourceFile()) && (delta.getKind() & 2) != 0) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (Display.getDefault().isDisposed()) {
                                            return;
                                        }
                                        if (UiPlugin.getDefault().getCurrentWorkbenchWindow() != null && UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage() != null) {
                                            UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().closeEditor((IEditorPart)VdbEditor.this, false);
                                        }
                                    }
                                });
                                return false;
                            }
                            if (resource instanceof IFile && ResourceChangeUtilities.isContentChanged((IResourceDelta)delta)) {
                                boolean foundIt = false;
                                IFile changedFile = (IFile)resource;
                                for (VdbEntry entry : VdbEditor.this.getVdb().getModelEntries()) {
                                    if (!entry.getPath().equals((Object)changedFile.getFullPath())) continue;
                                    entry.setSynchronization(VdbEntry.Synchronization.NotSynchronized);
                                    foundIt = true;
                                    break;
                                }
                                if (!foundIt) {
                                    for (VdbEntry entry : VdbEditor.this.getVdb().getEntries()) {
                                        if (!entry.getPath().equals((Object)changedFile.getFullPath())) continue;
                                        entry.setSynchronization(VdbEntry.Synchronization.NotSynchronized);
                                        break;
                                    }
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
    }
}

