/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.processor;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.modelgenerator.processor.DatatypeFinder;

public class MultiDatatypeFinder
implements DatatypeFinder {
    private final List datatypeFinders;

    public MultiDatatypeFinder(List datatypeFinders) {
        CoreArgCheck.isNotNull((Object)datatypeFinders);
        CoreArgCheck.isPositive((int)datatypeFinders.size());
        this.datatypeFinders = datatypeFinders;
    }

    @Override
    public EObject findDatatype(String name) throws CoreException {
        for (DatatypeFinder finder : this.datatypeFinders) {
            EObject result = finder.findDatatype(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public EObject findDatatype(URI uri) throws CoreException {
        for (DatatypeFinder finder : this.datatypeFinders) {
            EObject result = finder.findDatatype(uri);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List findAllDatatypes(String name) throws CoreException {
        LinkedList<EObject> results = new LinkedList<EObject>();
        for (DatatypeFinder finder : this.datatypeFinders) {
            List result = finder.findAllDatatypes(name);
            for (EObject object : result) {
                if (results.contains(object)) continue;
                results.add(object);
            }
        }
        return results;
    }

    @Override
    public List findAllDatatypes(URI uri) throws CoreException {
        LinkedList<EObject> results = new LinkedList<EObject>();
        for (DatatypeFinder finder : this.datatypeFinders) {
            List result = finder.findAllDatatypes(uri);
            for (EObject object : result) {
                if (results.contains(object)) continue;
                results.add(object);
            }
        }
        return results;
    }
}

