/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.server.core.IServer;
import org.kie.eclipse.Activator;
import org.kie.eclipse.server.IKieOrganizationHandler;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;
import org.kie.eclipse.server.KieResourceHandler;

public class KieServerHandler
extends KieResourceHandler
implements IKieServerHandler {
    private final IServer server;
    private IKieServiceDelegate delegate;

    public KieServerHandler(IServer server) {
        super(null, server.getName());
        this.server = server;
    }

    @Override
    public Object getResource() {
        return this.server;
    }

    @Override
    public void dispose() {
    }

    @Override
    public IKieServiceDelegate getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.loadDelegate();
        }
        return this.delegate;
    }

    protected IKieServiceDelegate loadDelegate() {
        IKieServiceDelegate result = null;
        try {
            IConfigurationElement[] config;
            String serverTypeId = this.getServerTypeId();
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.kie.eclipse.serviceImpl");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                String serverId;
                IConfigurationElement e = iConfigurationElementArray[n2];
                if ("containerBinding".equals(e.getName()) && serverTypeId.matches(serverId = e.getAttribute("serverId"))) {
                    e.getAttribute("runtimeId");
                    this.server.getRuntime().getRuntimeType().getVersion();
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof IKieServiceDelegate) {
                        result = (IKieServiceDelegate)o;
                        result.setServer(this.server);
                        result.setHandler(this);
                        return result;
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            Activator.logError(ex.getMessage(), ex);
        }
        return result;
    }

    public static boolean isSupportedServer(IServer server) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.kie.eclipse.serviceImpl");
        String serverTypeId = server.getServerType().getId();
        if (serverTypeId != null) {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                String serverId;
                IConfigurationElement e = iConfigurationElementArray[n2];
                if ("containerBinding".equals(e.getName()) && serverTypeId.matches(serverId = e.getAttribute("serverId"))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public String getRuntimeId() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String value = store.getString(this.getKieVersionPreferenceKey());
        return value;
    }

    public void setRuntimeId(String version) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.putValue(this.getKieVersionPreferenceKey(), version);
    }

    public String getServerTypeId() {
        return this.server.getServerType().getId();
    }

    @Override
    public List<IKieOrganizationHandler> getOrganizations() throws IOException {
        return this.getDelegate().getOrganizations(this);
    }

    @Override
    public List<IKieRepositoryHandler> getRepositories(IKieOrganizationHandler organization) throws IOException {
        return this.getDelegate().getRepositories(organization);
    }

    @Override
    public List<IKieProjectHandler> getProjects(IKieRepositoryHandler repository) throws IOException {
        return this.getDelegate().getProjects(repository);
    }

    @Override
    public List<? extends IKieResourceHandler> getChildren() throws Exception {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (this.children.isEmpty()) {
            List<IKieRepositoryHandler> allRepositories = this.getDelegate().getRepositories(this);
            List<IKieOrganizationHandler> organizations = this.getDelegate().getOrganizations(this);
            for (IKieRepositoryHandler r1 : allRepositories) {
                boolean contained = false;
                block1: for (IKieOrganizationHandler o : organizations) {
                    for (IKieRepositoryHandler r2 : o.getRepositories()) {
                        if (!r1.getName().equals(r2.getName())) continue;
                        contained = true;
                        continue block1;
                    }
                }
                if (contained) continue;
                this.children.add(r1);
            }
            this.children.addAll(organizations);
        }
        return this.children;
    }

    public boolean isServerRunning() {
        return this.server.getServerState() == 2;
    }

    protected String getKieVersionPreferenceKey() {
        return String.valueOf(this.server.getId()) + "/kieVersion";
    }

    protected String getKieOrganizationsPreferenceKey() {
        return String.valueOf(this.server.getId()) + "/organizations";
    }

    protected String getKieRepositoriesPreferenceKey() {
        return String.valueOf(this.server.getId()) + "/repositories";
    }

    protected String getKieProjectsPreferenceKey() {
        return String.valueOf(this.server.getId()) + "/projects";
    }

    @Override
    public boolean isLoaded() {
        return this.isServerRunning();
    }

    @Override
    public IServer getServer() {
        return this.server;
    }
}

