/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.foundation.ui.actions.ConfigureColumnsDialog;
import org.fusesource.ide.foundation.ui.actions.Messages;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;
import org.fusesource.ide.foundation.ui.propsrc.PropertySourceTableSheetPage;
import org.fusesource.ide.foundation.ui.util.IConfigurableColumns;
import org.fusesource.ide.foundation.ui.views.TabFolderSupport2;
import org.fusesource.ide.foundation.ui.views.TableViewSupport;

public class ConfigureColumnsAction
extends Action {
    private IConfigurableColumns columns;
    private ConfigureColumnsDialog dialog;

    public ConfigureColumnsAction(IConfigurableColumns columns) {
        Assert.isNotNull((Object)columns);
        this.setText(Messages.configureColumnsLabel);
        this.setImageDescriptor(FoundationUIActivator.getDefault().getSharedImages().descriptor("icons/prop_ps.gif"));
        this.columns = columns;
        this.setId(((Object)((Object)this)).getClass().getName());
    }

    public void run() {
        this.determineColumns();
        if (this.columns == null) {
            return;
        }
        this.getDialog().open();
    }

    private void determineColumns() {
        this.columns = null;
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part instanceof PropertySheet) {
            PropertySheet ps = (PropertySheet)part;
            if (ps.getCurrentPage() instanceof PropertySourceTableSheetPage) {
                PropertySourceTableSheetPage sp = (PropertySourceTableSheetPage)ps.getCurrentPage();
                this.columns = sp.getTableView();
            } else {
                ISection[] secs = null;
                if (ps.getCurrentPage() instanceof TabFolderSupport2) {
                    TabFolderSupport2 tfs = (TabFolderSupport2)ps.getCurrentPage();
                    secs = tfs.getCurrentTab().getSections();
                } else if (ps.getCurrentPage() instanceof TabbedPropertySheetPage) {
                    TabbedPropertySheetPage tabbedPage = (TabbedPropertySheetPage)ps.getCurrentPage();
                    ISection[] iSectionArray = secs = tabbedPage.getCurrentTab() == null ? null : tabbedPage.getCurrentTab().getSections();
                }
                if (secs != null) {
                    ISection[] iSectionArray = secs;
                    int n = secs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ISection sec = iSectionArray[n2];
                        if (sec instanceof IConfigurableColumns) {
                            this.columns = (IConfigurableColumns)sec;
                            break;
                        }
                        FoundationUIActivator.pluginLog().logWarning("Unsupported type: " + sec.getClass().getName());
                        ++n2;
                    }
                } else {
                    FoundationUIActivator.pluginLog().logWarning("Unsupported type: " + ps.getCurrentPage().getClass().getName());
                }
            }
        } else if (part instanceof TableViewSupport) {
            this.columns = (TableViewSupport)part;
        } else {
            FoundationUIActivator.pluginLog().logWarning("Unsupported type: " + part.getClass().getName());
        }
    }

    private ConfigureColumnsDialog getDialog() {
        return new ConfigureColumnsDialog(this.columns);
    }
}

