/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.fusesource.ide.foundation.ui.actions.IConnectable;
import org.fusesource.ide.foundation.ui.actions.Messages;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;
import org.fusesource.ide.foundation.ui.util.Selections;

public class ConnectDisconnectAction
extends Action {
    private final StructuredViewer viewer;

    public ConnectDisconnectAction(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public String getText() {
        if (this.shouldConnect()) {
            return Messages.connectLabel;
        }
        return Messages.disconnectLabel;
    }

    public void run() {
        IConnectable connectable = this.getConnectable();
        if (connectable != null) {
            String message = null;
            try {
                if (this.shouldConnect()) {
                    message = "connecting";
                    connectable.connect();
                } else {
                    message = "disconnecting";
                    connectable.disconnect();
                }
            }
            catch (Exception e) {
                this.onConnectionError(message, e);
            }
        }
    }

    protected void onConnectionError(String kind, Exception e) {
        FoundationUIActivator.pluginLog().logWarning("Failed to " + kind + ". " + e, (Throwable)e);
    }

    public boolean isEnabled() {
        return this.getConnectable() != null;
    }

    public boolean shouldConnect() {
        IConnectable connectable = this.getConnectable();
        return connectable != null && connectable.shouldConnect();
    }

    public IConnectable getConnectable() {
        Object selection = Selections.getFirstSelection((Viewer)this.viewer);
        if (selection instanceof IConnectable) {
            return (IConnectable)selection;
        }
        return null;
    }

    public void refresh() {
        this.setText(this.getText());
    }
}

