/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.io;

import java.io.InputStream;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fusesource.ide.foundation.core.util.IOUtils;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;
import org.jboss.tools.jmx.core.tree.Node;

public class CamelContextNodeEditorInput
extends CamelXMLEditorInput {
    private final Node contextNode;
    private String contextId;

    public CamelContextNodeEditorInput(Node contextNode, IFile camelContextTempFile) {
        super(camelContextTempFile, null);
        this.contextNode = contextNode;
        if (contextNode.getClass().getName().equals("org.fusesource.ide.jmx.camel.navigator.CamelContextNode")) {
            try {
                Method m = contextNode.getClass().getMethod("getContextId", null);
                Object result = m.invoke((Object)contextNode, null);
                if (result instanceof String) {
                    this.contextId = (String)result;
                    this.setSelectedContainerId(this.contextId);
                }
            }
            catch (Exception ex) {
                FoundationUIActivator.pluginLog().logError(ex.getCause() != null ? ex.getCause() : ex);
            }
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return FoundationUIActivator.getDefault().getSharedImages().descriptor("icons/camel.png");
    }

    @Override
    public String getName() {
        return "Remote CamelContext: " + this.contextId;
    }

    @Override
    public String getToolTipText() {
        return this.getName();
    }

    @Override
    public void onEditorInputSave() {
        super.onEditorInputSave();
        String xml = null;
        try {
            this.getCamelContextFile().getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            xml = IOUtils.loadText((InputStream)this.getCamelContextFile().getContents(), (String)"utf-8");
            this.pushbackToRemoteContext(xml);
        }
        catch (Exception ex) {
            FoundationUIActivator.pluginLog().logError("Error saving changes to remote camel context " + this.contextId, (Throwable)ex);
        }
    }

    public void pushbackToRemoteContext(String xml) {
        if (this.contextNode.getClass().getName().equals("org.fusesource.ide.jmx.camel.navigator.CamelContextNode")) {
            try {
                Method m = this.contextNode.getClass().getMethod("updateXml", String.class);
                m.invoke((Object)this.contextNode, xml);
            }
            catch (Exception ex) {
                FoundationUIActivator.pluginLog().logError(ex.getCause() != null ? ex.getCause() : ex);
            }
        }
    }
}

