/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.io;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInputFactory;

public class CamelXMLEditorInput
implements IEditorInput,
IPersistableElement {
    public static final String KEY_CONTEXT_FILE = "camel.context.file.path";
    public static final String KEY_SELECTED_CONTAINER_ID = "camel.context.container.id";
    private IFile camelContextFile;
    private String selectedContainerId;

    public CamelXMLEditorInput(IFile contextFile, String containerId) {
        this.camelContextFile = contextFile;
        this.selectedContainerId = containerId;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IFile.class) || adapter.equals(IResource.class)) {
            return (T)this.camelContextFile;
        }
        return null;
    }

    public boolean exists() {
        return this.camelContextFile != null && this.camelContextFile.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return FoundationUIActivator.getDefault().getSharedImages().descriptor("icons/camel.png");
    }

    public String getName() {
        return this.camelContextFile.getName();
    }

    public IPersistableElement getPersistable() {
        if (this.camelContextFile != null) {
            return this;
        }
        return null;
    }

    public String getToolTipText() {
        return String.format("%s%s%s", this.camelContextFile.getProject().getName(), File.separator, this.camelContextFile.getProjectRelativePath().toString());
    }

    public void saveState(IMemento memento) {
        boolean exists = this.exists();
        if (!exists) {
            return;
        }
        memento.putString(KEY_CONTEXT_FILE, this.camelContextFile.getFullPath().toOSString());
        memento.putString(KEY_SELECTED_CONTAINER_ID, this.selectedContainerId);
    }

    public String getFactoryId() {
        return CamelXMLEditorInputFactory.class.getName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getCamelContextFile() == null ? 0 : this.getCamelContextFile().getLocation().toOSString().hashCode());
        result = 31 * result + (this.getSelectedContainerId() == null ? 0 : this.getSelectedContainerId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CamelXMLEditorInput) {
            CamelXMLEditorInput input2 = (CamelXMLEditorInput)obj;
            if (this.getCamelContextFile() != null && input2.getCamelContextFile() != null) {
                if (this.getSelectedContainerId() != null && input2.getSelectedContainerId() != null ? !this.getSelectedContainerId().equals(input2.getSelectedContainerId()) : this.getSelectedContainerId() == null && input2.getSelectedContainerId() != null || this.getSelectedContainerId() != null && input2.getSelectedContainerId() == null) {
                    return false;
                }
                if (this.getCamelContextFile() != null && this.getCamelContextFile().getLocation() != null && input2 != null && input2.getCamelContextFile() != null && input2.getCamelContextFile().getLocation() != null) {
                    return this.getCamelContextFile().getLocation().toOSString().equals(input2.getCamelContextFile().getLocation().toOSString());
                }
            }
        }
        return false;
    }

    public String getSelectedContainerId() {
        return this.selectedContainerId;
    }

    public IFile getCamelContextFile() {
        return this.camelContextFile;
    }

    public void setSelectedContainerId(String selectedContainerId) {
        this.selectedContainerId = selectedContainerId;
    }

    public void onEditorInputSave() {
    }
}

