/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.label;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.fusesource.ide.foundation.core.functions.Function1;
import org.fusesource.ide.foundation.ui.label.WrappedCellLabelProvider;
import org.fusesource.ide.preferences.PreferenceManager;

public class ChartLabelProvider
extends OwnerDrawLabelProvider
implements WrappedCellLabelProvider {
    private int arcWidth = 5;
    private int arcHeight = 5;
    private int widthOffset = 0;
    private int heightOffset = 0;
    private int textWidthOffset = 2;
    private int textHeightOffset = 1;
    private Color chartColour;
    private final CellLabelProvider labelProvider;
    private final ColumnViewer viewer;

    public ChartLabelProvider(CellLabelProvider labelProvider, ColumnViewer viewer) {
        this.labelProvider = labelProvider;
        this.viewer = viewer;
    }

    @Override
    public CellLabelProvider getWrappedLabelProvider() {
        return this.labelProvider;
    }

    protected void measure(Event event, Object element) {
    }

    protected double maximumValue(Function1 fn) {
        Object[] elements;
        double maximum = 0.0;
        boolean first = true;
        boolean allSame = true;
        IContentProvider contentProvider = this.viewer.getContentProvider();
        if (contentProvider instanceof IStructuredContentProvider && (elements = this.getElements(contentProvider)) != null) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Object value = fn.apply(object);
                double n3 = ChartLabelProvider.doubleValue(value);
                if (first) {
                    maximum = n3;
                    first = false;
                } else {
                    if (n3 != maximum) {
                        allSame = false;
                    }
                    if (n3 > maximum) {
                        maximum = n3;
                    }
                }
                ++n2;
            }
        }
        if (allSame) {
            return 0.0;
        }
        return maximum;
    }

    protected Object[] getElements(IContentProvider contentProvider) {
        IStructuredContentProvider scp = (IStructuredContentProvider)contentProvider;
        Object[] elements = scp.getElements(this.viewer.getInput());
        if (scp instanceof ITreeContentProvider) {
            ITreeContentProvider tcp = (ITreeContentProvider)scp;
            ArrayList list = new ArrayList();
            this.appendChildren(list, tcp, elements);
            return list.toArray();
        }
        return elements;
    }

    protected void appendChildren(List list, ITreeContentProvider tcp, Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            list.add(object);
            Object[] children = tcp.getChildren(object);
            if (children != null && children.length > 0) {
                this.appendChildren(list, tcp, children);
            }
            ++n2;
        }
    }

    public static double doubleValue(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.doubleValue();
        }
        return 0.0;
    }

    protected void paint(Event event, Object element) {
        Function1 fn;
        Object value;
        Color background;
        Color foreground;
        Rectangle bounds;
        TableItem item;
        if (event.item instanceof TableItem) {
            item = (TableItem)event.item;
            bounds = item.getBounds(event.index);
            foreground = item.getForeground();
            background = item.getBackground();
        } else if (event.item instanceof TreeItem) {
            item = (TreeItem)event.item;
            bounds = item.getBounds(event.index);
            foreground = item.getForeground();
            background = item.getBackground();
        } else {
            return;
        }
        String text = "";
        double percent = 0.0;
        if (this.labelProvider instanceof Function1 && (value = (fn = (Function1)this.labelProvider).apply(element)) != null) {
            double max;
            text = value.toString();
            double d = ChartLabelProvider.doubleValue(value);
            if (d != 0.0 && (max = this.maximumValue(fn)) > 0.0) {
                percent = d / max;
            }
        }
        int x = bounds.width > 0 ? bounds.x + this.widthOffset : bounds.x;
        int y = bounds.height > 0 ? bounds.y + this.heightOffset : bounds.y;
        GC gc = event.gc;
        int width = (int)Math.floor((double)(bounds.width - 2 * this.widthOffset) * percent);
        int height = bounds.height - 2 * this.heightOffset;
        if (this.chartColour != null) {
            this.chartColour.dispose();
            this.chartColour = null;
        }
        if (this.chartColour == null) {
            String colorString = PreferenceManager.getInstance().loadPreferenceAsString("diagramTableChartBackgroundColorPreference");
            int r = 0;
            int g = 0;
            int b = 0;
            StringTokenizer strTok = new StringTokenizer(colorString, ",");
            int i = 0;
            while (strTok.hasMoreTokens()) {
                String tok = strTok.nextToken();
                switch (i) {
                    case 0: {
                        r = Integer.parseInt(tok);
                        break;
                    }
                    case 1: {
                        g = Integer.parseInt(tok);
                        break;
                    }
                    case 2: {
                        b = Integer.parseInt(tok);
                    }
                }
                ++i;
            }
            this.chartColour = new Color(gc.getDevice(), r, g, b);
        }
        gc.setForeground(this.chartColour);
        gc.setBackground(this.chartColour);
        gc.fillRoundRectangle(x, y, width, height, this.arcWidth, this.arcHeight);
        gc.setForeground(foreground);
        gc.setBackground(background);
        gc.drawText(text, x + this.textWidthOffset, y + this.textHeightOffset, true);
        this.chartColour.dispose();
    }
}

