/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.label;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.fusesource.ide.foundation.core.functions.Function1;
import org.fusesource.ide.foundation.ui.label.Bar;
import org.fusesource.ide.foundation.ui.label.Health;

public class HealthLabelProvider
extends OwnerDrawLabelProvider {
    private final Function1 function;
    private int arcWidth = 5;
    private int arcHeight = 5;
    private int widthOffset = 0;
    private int heightOffset = 0;
    private int textWidthOffset = 2;
    private int textHeightOffset = 1;
    private Color chartColour;

    public HealthLabelProvider(Function1 function) {
        this.function = function;
    }

    protected void measure(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        Color background;
        Color foreground;
        Rectangle bounds;
        TableItem item;
        if (event.item instanceof TableItem) {
            item = (TableItem)event.item;
            bounds = item.getBounds(event.index);
            foreground = item.getForeground();
            background = item.getBackground();
        } else if (event.item instanceof TreeItem) {
            item = (TreeItem)event.item;
            bounds = item.getBounds(event.index);
            foreground = item.getForeground();
            background = item.getBackground();
        } else {
            return;
        }
        List<Bar> bars = this.getBars(element);
        int x = bounds.width > 0 ? bounds.x + this.widthOffset : bounds.x;
        int y = bounds.height > 0 ? bounds.y + this.heightOffset : bounds.y;
        GC gc = event.gc;
        int height = bounds.height - 2 * this.heightOffset;
        for (Bar bar : bars) {
            int width = (int)Math.floor((double)(bounds.width - 2 * this.widthOffset) * bar.getRate());
            if (this.chartColour != null) {
                this.chartColour.dispose();
                this.chartColour = null;
            }
            if (this.chartColour == null) {
                this.chartColour = bar.getColour().create(gc);
            }
            gc.setForeground(this.chartColour);
            gc.setBackground(this.chartColour);
            gc.fillRoundRectangle(x, y, width, height, this.arcWidth, this.arcHeight);
            String text = bar.getText();
            if (text != null) {
                gc.setForeground(foreground);
                gc.setBackground(background);
                gc.drawText(text, x + this.textWidthOffset, y + this.textHeightOffset, true);
            }
            x += width;
        }
        this.chartColour.dispose();
    }

    protected List<Bar> getBars(Object element) {
        ArrayList<Bar> bars = new ArrayList<Bar>();
        Health health = this.getHealth(element);
        if (health != null) {
            health.addBars(bars);
        }
        return bars;
    }

    protected Health getHealth(Object element) {
        Object value;
        if (this.function != null && (value = this.function.apply(element)) instanceof Health) {
            return (Health)value;
        }
        return null;
    }
}

