/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.properties;

import java.beans.PropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.foundation.core.functions.ReturnType;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;

public class PropertyDescriptors {
    public static String getReadablePropertyName(IPropertyDescriptor descriptor) {
        String name = descriptor.getDisplayName();
        Object id = descriptor.getId();
        if (id instanceof String && Objects.equal((Object)name, (Object)id)) {
            name = PropertyDescriptors.capitalizeAndSplitCamelCase(name);
        }
        return name;
    }

    public static String getReadablePropertyName(PropertyDescriptor descriptor) {
        String id;
        String name = descriptor.getDisplayName();
        if (Objects.equal((Object)name, (Object)(id = descriptor.getName()))) {
            name = PropertyDescriptors.capitalizeAndSplitCamelCase(name);
        }
        return name;
    }

    protected static String capitalizeAndSplitCamelCase(String name) {
        String name2 = Strings.splitCamelCase((String)name);
        name = Strings.capitalize((String)name2);
        return name;
    }

    public static Class<?> getPropertyType(IPropertyDescriptor descriptor) {
        if (descriptor instanceof ReturnType) {
            ReturnType rt = (ReturnType)descriptor;
            return rt.getReturnType();
        }
        if (descriptor instanceof TextPropertyDescriptor) {
            return String.class;
        }
        FoundationUIActivator.pluginLog().logInfo("Unknown property type for " + descriptor + " of class: " + descriptor.getClass().getName() + " " + descriptor.getId());
        return String.class;
    }
}

