/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.propsrc;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.fusesource.ide.foundation.ui.propsrc.BeanTypePropertyMetadata;
import org.fusesource.ide.foundation.ui.tree.HasOwner;

public class BeanPropertySource
implements IPropertySource2,
HasOwner {
    public static final long THROTTLE = 10000L;
    private static long lastGCRun = System.currentTimeMillis();
    private static Map<String, BeanCache> cachedValues = new HashMap<String, BeanCache>();
    private final Object bean;
    private final BeanTypePropertyMetadata metadata;
    private Object owner;

    public BeanPropertySource(Object bean) throws IntrospectionException {
        this(bean, bean.getClass());
    }

    public BeanPropertySource(Object bean, Class<?> beanType) throws IntrospectionException {
        this.bean = bean;
        this.metadata = BeanTypePropertyMetadata.beanMetadata(beanType);
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public Object getBean() {
        return this.bean;
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.metadata.getPropertyDescriptors();
    }

    public Object getPropertyValue(Object id) {
        String cacheKey = id + "~" + this.bean.hashCode();
        if (cachedValues.containsKey(cacheKey)) {
            return cachedValues.get(cacheKey).getValue();
        }
        Object value = this.metadata.getPropertyValue(this.bean, id);
        cachedValues.put(cacheKey, new BeanCache(value));
        return value;
    }

    public boolean isPropertySet(Object id) {
        return this.getPropertyValue(id) != null;
    }

    public void setPropertyValue(Object id, Object value) {
        this.metadata.setPropertyValue(this.bean, id, value);
    }

    public void resetPropertyValue(Object id) {
    }

    public void cleanCache() {
        cachedValues.clear();
        lastGCRun = System.currentTimeMillis();
    }

    class BeanCache {
        private long cacheTime = System.currentTimeMillis();
        private Object value;

        public BeanCache(Object value) {
            this.value = value;
        }

        public Object getValue() {
            if (System.currentTimeMillis() - lastGCRun > 10000L) {
                this.cleanup();
            }
            return this.value;
        }

        private void cleanup() {
            ArrayList<String> keysToBeCollected = new ArrayList<String>();
            for (String key : cachedValues.keySet()) {
                BeanCache bc = (BeanCache)cachedValues.get(key);
                if (System.currentTimeMillis() - bc.cacheTime <= 10000L) continue;
                keysToBeCollected.add(key);
            }
            for (String k : keysToBeCollected) {
                cachedValues.remove(k);
            }
            lastGCRun = System.currentTimeMillis();
        }
    }
}

